/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.internal.core.Logger;

public class AnonymousClassInstanceType
implements IClassType {
    private AnonymousClassDeclaration clazz;
    private ISourceModule module;

    public AnonymousClassInstanceType(ISourceModule module, AnonymousClassDeclaration clazz) {
        this.clazz = clazz;
        this.module = module;
    }

    public AnonymousClassDeclaration getTypeDeclaration() {
        return this.clazz;
    }

    public String getTypeName() {
        if (this.clazz != null) {
            return "anonymous class instance";
        }
        return "class instance: !!unknown!!";
    }

    public ISourceModule getModule() {
        return this.module;
    }

    public IType getType() {
        try {
            IModelElement element = this.module.getElementAt(this.clazz.sourceStart());
            if (element instanceof IType) {
                return (IType)element;
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        return null;
    }

    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 45 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 45 * result + (this.module == null ? 0 : this.module.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnonymousClassInstanceType other = (AnonymousClassInstanceType)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        return !(this.module == null ? other.module != null : !this.module.equals(other.module));
    }
}

