/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractGlobalStatementContext;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;

public final class TypeStatementContext
extends AbstractGlobalStatementContext {
    private boolean isAssignment = false;
    private Type type;

    public Type getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        try {
            PHPHeuristicScanner scanner2 = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.getCompanion().getDocument(), offset, true);
            if (!scanner2.isDefaultPartition(offset)) {
                return false;
            }
            ICompletionScope scope = this.getCompanion().getScope();
            if (scope.getType() == ICompletionScope.Type.FIELD || scope.getType() == ICompletionScope.Type.FUNCTION || scope.getType() == ICompletionScope.Type.TRAIT_USE || scope.getType() == ICompletionScope.Type.TRAIT_PRECEDENCE || scope.getType() == ICompletionScope.Type.TYPE_STATEMENT) {
                scope = scope.getParent();
            }
            if (scope.getType() != ICompletionScope.Type.BLOCK) {
                return false;
            }
            scope = scope.getParent();
            switch (scope.getType()) {
                case CLASS: {
                    this.type = Type.CLASS;
                    break;
                }
                case INTERFACE: {
                    this.type = Type.INTERFACE;
                    break;
                }
                case TRAIT: {
                    this.type = Type.TRAIT;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.isAssignment = scanner2.scanBackward(offset, this.getCompanion().getScope().getOffset(), '=') > -1;
            return true;
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
            return false;
        }
    }

    public boolean isAssignment() {
        return this.isAssignment;
    }

    public static enum Type {
        CLASS,
        TRAIT,
        INTERFACE;

    }
}

