/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.photran.internal.ui.search.ISearchContentProvider;
import org.eclipse.photran.internal.ui.search.SearchLabelProvider;
import org.eclipse.photran.internal.ui.search.SearchListContentProvider;
import org.eclipse.photran.internal.ui.search.SearchTreeContentProvider;
import org.eclipse.photran.internal.ui.vpg.Activator;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.texteditor.ITextEditor;

public class SearchViewPage
extends AbstractTextSearchViewPage {
    private ISearchContentProvider contentProvider;

    public SearchViewPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public SearchViewPage() {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new SearchTreeContentProvider();
        viewer.setContentProvider((IContentProvider)((SearchTreeContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new SearchLabelProvider(this));
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new SearchListContentProvider();
        viewer.setContentProvider((IContentProvider)((SearchListContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new SearchLabelProvider(this));
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        try {
            IEditorPart editor = this.openInEditor((IFile)match.getElement());
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private IEditorPart openInEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
        return page == null ? null : IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }
}

