/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.access;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.passage.lic.api.restrictions.RestrictionExecutorRegistry;
import org.eclipse.passage.lic.api.restrictions.RestrictionLevelDescriptor;
import org.eclipse.passage.lic.base.restrictions.BaseRestrictionLevelDescriptor;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.service.component.annotations.Component;

@Component
public class EquinoxRestrictionExecutorRegistry
implements RestrictionExecutorRegistry {
    private final Map<String, RestrictionLevelDescriptor> supportedLevels = new LinkedHashMap<String, RestrictionLevelDescriptor>();

    public EquinoxRestrictionExecutorRegistry() {
        String info = "info";
        this.supportedLevels.put(info, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(info, EquinoxMessages.EquinoxRestrictionExecutorRegistry_info_name, EquinoxMessages.EquinoxRestrictionExecutorRegistry_info_title));
        String warn = "warn";
        this.supportedLevels.put(warn, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(warn, EquinoxMessages.EquinoxRestrictionExecutorRegistry_warning_name, EquinoxMessages.EquinoxRestrictionExecutorRegistry_warning_title));
        String error = "error";
        this.supportedLevels.put(error, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(error, EquinoxMessages.EquinoxRestrictionExecutorRegistry_error_name, EquinoxMessages.EquinoxRestrictionExecutorRegistry_error_title));
        String fatal = "fatal";
        this.supportedLevels.put(fatal, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(fatal, EquinoxMessages.EquinoxRestrictionExecutorRegistry_fatal_name, EquinoxMessages.EquinoxRestrictionExecutorRegistry_fatal_title));
    }

    public Iterable<String> getRestrictionLevelIdentifiers() {
        return this.supportedLevels.keySet();
    }

    public String getDefaultRestrictionLevelIdentifier() {
        return "warn";
    }

    public RestrictionLevelDescriptor getRestrictionLevel(String identifier) {
        return this.supportedLevels.get(identifier);
    }

    public Iterable<? extends RestrictionLevelDescriptor> getRestrictionLevels() {
        return this.supportedLevels.values();
    }
}

