/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.openelement.service.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.services.openelement.Activator;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.IPapyrusPageInput;
import org.eclipse.papyrus.infra.ui.editor.PapyrusPageInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenElementServiceImpl
implements OpenElementService {
    private ServicesRegistry registry;
    private static final String PAPYRUS_EDITOR_ID = "org.eclipse.papyrus.infra.core.papyrusEditor";

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        this.registry = null;
    }

    public IMultiDiagramEditor openElement(EObject viewElement) throws PartInitException, ServiceException {
        URI pageURI = this.getPageForViewElement(viewElement);
        if (pageURI == null) {
            return null;
        }
        IMultiDiagramEditor editor = this.openURI(pageURI);
        this.reveal(editor, viewElement);
        if (editor != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        return editor;
    }

    protected void reveal(final IMultiDiagramEditor editor, final EObject element) {
        if (editor != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        URI elementURI = EcoreUtil.getURI((EObject)element);
                        ModelSet modelSet = (ModelSet)editor.getServicesRegistry().getService(ModelSet.class);
                        EObject elementToReveal = modelSet.getEObject(elementURI, false);
                        if (elementToReveal == null) {
                            return;
                        }
                        NavigationService navigationService = (NavigationService)editor.getServicesRegistry().getService(NavigationService.class);
                        if (navigationService != null) {
                            navigationService.navigate((Object)elementToReveal);
                        }
                    }
                    catch (ServiceException ex) {
                        Activator.log.error((Throwable)ex);
                    }
                }
            });
        }
    }

    public IMultiDiagramEditor openSemanticElement(EObject semanticElement) throws PartInitException, ServiceException {
        URI[] pages = this.getPagesForSemanticElement(semanticElement);
        IMultiDiagramEditor editor = this.openSemanticElement(semanticElement, pages);
        if (editor != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        return editor;
    }

    public IMultiDiagramEditor openSemanticElement(EObject semanticElement, Object[] pages) throws PartInitException, ServiceException {
        URI[] pageURIs = new URI[pages.length];
        int i = 0;
        Object[] objectArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Object pageElement = objectArray[n2];
            URI uri = null;
            if (pageElement instanceof EObject) {
                uri = EcoreUtil.getURI((EObject)((EObject)pageElement));
            }
            pageURIs[i++] = uri;
            ++n2;
        }
        IMultiDiagramEditor editor = this.openSemanticElement(semanticElement, pageURIs);
        return editor;
    }

    private IMultiDiagramEditor openSemanticElement(EObject semanticElement, URI[] pageURIs) throws ServiceException, PartInitException {
        IMultiDiagramEditor editor = this.getCurrentEditor();
        if (editor == null) {
            URI diFile = this.getDiResourceURI(semanticElement);
            editor = this.openURIsInNewEditor(diFile, pageURIs);
        } else {
            IPageManager pageManager = (IPageManager)this.registry.getService(IPageManager.class);
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            LinkedHashSet<EObject> pagesToOpen = new LinkedHashSet<EObject>();
            LinkedHashSet<EObject> pagesToSelect = new LinkedHashSet<EObject>();
            URI[] uRIArray = pageURIs;
            int n = pageURIs.length;
            int n2 = 0;
            while (n2 < n) {
                URI pageURI = uRIArray[n2];
                EObject page = modelSet.getEObject(pageURI, true);
                if (pageManager.allPages().contains(page)) {
                    if (pageManager.isOpen((Object)page)) {
                        pagesToSelect.add(page);
                    } else {
                        pagesToOpen.add(page);
                    }
                }
                ++n2;
            }
            if (!pagesToOpen.isEmpty()) {
                for (EObject page : pagesToOpen) {
                    pageManager.openPage((Object)page);
                }
            }
            for (EObject page : pagesToSelect) {
                pageManager.selectPage((Object)page);
            }
        }
        this.reveal(editor, semanticElement);
        if (editor != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        return editor;
    }

    /*
     * Unable to fully structure code
     */
    private URI[] getPagesForSemanticElement(EObject element) {
        try {
            pageManager = (IPageManager)this.registry.getService(IPageManager.class);
            usages = EMFHelper.getUsages((EObject)element);
            result = new LinkedList<URI>();
            block2: for (EStructuralFeature.Setting usage : usages) {
                referencer = usage.getEObject();
                do {
                    if (!pageManager.allPages().contains(referencer)) continue;
                    result.add(EcoreUtil.getURI((EObject)referencer));
                    continue block2;
                } while ((referencer = referencer.eContainer()) != null);
            }
            return result.toArray(new URI[result.size()]);
        }
        catch (ServiceException ex) {
            result = new HashSet<URI>();
            usages = EMFHelper.getUsages((EObject)element);
            ** for (usage : usages)
        }
lbl-1000:
        // 1 sources

        {
            referencer = usage.getEObject();
            while (result.add(EcoreUtil.getURI((EObject)referencer)) && (referencer = referencer.eContainer()) != null) {
            }
            continue;
        }
lbl23:
        // 1 sources

        return result.toArray(new URI[result.size()]);
    }

    private URI getPageForViewElement(EObject viewElement) {
        block5: {
            if (viewElement == null) {
                return null;
            }
            try {
                IPageManager pageManager = (IPageManager)this.registry.getService(IPageManager.class);
                EObject currentViewElement = viewElement;
                while (currentViewElement != null) {
                    if (pageManager.allPages().contains(currentViewElement)) break;
                    currentViewElement = currentViewElement.eContainer();
                }
                if (currentViewElement != null) {
                    return EcoreUtil.getURI((EObject)currentViewElement);
                }
            }
            catch (ServiceException ex) {
                EObject rootElement = EcoreUtil.getRootContainer((EObject)viewElement);
                if (rootElement == null) break block5;
                return EcoreUtil.getURI((EObject)rootElement);
            }
        }
        return null;
    }

    protected URI getDiResourceURI(URI uri) {
        URI fileURI = uri.trimFileExtension().trimFragment();
        if (this.exists(fileURI = fileURI.appendFileExtension("di"))) {
            return fileURI;
        }
        Activator.log.warn("The resource doesn't exist: " + fileURI);
        return null;
    }

    protected boolean exists(URI uri) {
        try {
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            return modelSet.getURIConverter().exists(uri, null);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return false;
        }
    }

    protected URI getDiResourceURI(EObject element) {
        Resource resource = element.eResource();
        URI fileURI = resource.getURI();
        return this.getDiResourceURI(fileURI);
    }

    private IMultiDiagramEditor getCurrentEditor() {
        try {
            IMultiDiagramEditor currentEditor = (IMultiDiagramEditor)this.registry.getService(IMultiDiagramEditor.class);
            return currentEditor;
        }
        catch (ServiceException ex) {
            return null;
        }
    }

    private IMultiDiagramEditor openURI(URI pageURI) throws ServiceException, PartInitException {
        IMultiDiagramEditor editor = this.getCurrentEditor();
        if (editor == null) {
            URI diFile = this.getDiResourceURI(pageURI);
            editor = this.openURIsInNewEditor(diFile, new URI[]{pageURI});
        } else {
            IPageManager pageManager = (IPageManager)this.registry.getService(IPageManager.class);
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            EObject page = modelSet.getEObject(pageURI, true);
            if (pageManager.allPages().contains(page)) {
                if (pageManager.isOpen((Object)page)) {
                    pageManager.selectPage((Object)page);
                } else {
                    pageManager.openPage((Object)page);
                }
            }
        }
        return editor;
    }

    protected IMultiDiagramEditor openURIsInNewEditor(URI diResourceURI, URI[] pageURIs) throws PartInitException {
        IPapyrusPageInput input = this.createPapyrusPageInput(diResourceURI, pageURIs);
        if (input == null) {
            return null;
        }
        RunnableWithResult.Impl<IMultiDiagramEditor> runnable = new RunnableWithResult.Impl<IMultiDiagramEditor>((IEditorInput)input){
            private final /* synthetic */ IEditorInput val$input;
            {
                this.val$input = iEditorInput;
            }

            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IMultiDiagramEditor openedEditor = OpenElementServiceImpl.this.openEditor(page, this.val$input);
                    this.setResult(openedEditor);
                    this.setStatus(Status.OK_STATUS);
                }
                catch (PartInitException ex) {
                    this.setStatus((IStatus)new Status(4, "org.eclipse.papyrus.infra.services.openelement", ex.getMessage(), (Throwable)ex));
                }
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getStatus().getSeverity() == 4) {
            throw (PartInitException)runnable.getStatus().getException();
        }
        return (IMultiDiagramEditor)runnable.getResult();
    }

    protected IPapyrusPageInput createPapyrusPageInput(URI diResourceURI, URI[] pageURIs) {
        IFile diFile = null;
        if (diResourceURI != null && diResourceURI.isPlatformResource()) {
            diFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(diResourceURI.toPlatformString(true)));
        }
        return diFile == null || !diFile.exists() ? null : new PapyrusPageInput(diFile, pageURIs, false);
    }

    protected IMultiDiagramEditor openEditor(IWorkbenchPage workbenchPage, IEditorInput input) throws PartInitException {
        return (IMultiDiagramEditor)IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)input, (String)PAPYRUS_EDITOR_ID);
    }
}

