/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OomphDropAdapter
extends EditingDomainViewerDropAdapter {
    private static final boolean HAS_EARLY_DRAG_SOURCE = "win32".equals(SWT.getPlatform());
    protected OomphTransferDelegate[] delegates;
    protected Set<OomphTransferDelegate> unavailableDelegates;

    public OomphDropAdapter(EditingDomain domain, Viewer viewer, Collection<? extends OomphTransferDelegate> delegates) {
        this(domain, viewer, delegates.toArray(new OomphTransferDelegate[delegates.size()]));
    }

    public OomphDropAdapter(EditingDomain domain, Viewer viewer, OomphTransferDelegate ... delegates) {
        super(domain, viewer);
        this.delegates = delegates;
    }

    public void dragEnter(DropTargetEvent event) {
        this.unavailableDelegates = !HAS_EARLY_DRAG_SOURCE ? null : new HashSet<OomphTransferDelegate>();
        super.dragEnter(event);
    }

    public void dropAccept(DropTargetEvent event) {
        if (!HAS_EARLY_DRAG_SOURCE) {
            this.unavailableDelegates = new HashSet<OomphTransferDelegate>();
        }
        super.dropAccept(event);
    }

    protected Collection<?> getDragSource(DropTargetEvent event) {
        if (this.unavailableDelegates != null) {
            OomphTransferDelegate delegate;
            TransferData dataType = event.currentDataType;
            OomphTransferDelegate[] oomphTransferDelegateArray = this.delegates;
            int n = this.delegates.length;
            int n2 = 0;
            while (n2 < n) {
                delegate = oomphTransferDelegateArray[n2];
                if (delegate.isSupportedType(dataType)) {
                    Collection<?> data = delegate.getData(this.domain, dataType);
                    if (data != null && !data.isEmpty()) {
                        return data;
                    }
                    if (HAS_EARLY_DRAG_SOURCE) {
                        this.unavailableDelegates.add(delegate);
                    }
                }
                ++n2;
            }
            oomphTransferDelegateArray = this.delegates;
            n = this.delegates.length;
            n2 = 0;
            while (n2 < n) {
                delegate = oomphTransferDelegateArray[n2];
                if (!this.unavailableDelegates.contains(delegate)) {
                    TransferData[] transferDataArray = event.dataTypes;
                    int n3 = event.dataTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TransferData availableDataType = transferDataArray[n4];
                        if (delegate.isSupportedType(availableDataType)) {
                            event.currentDataType = availableDataType;
                            return null;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            event.detail = 0;
        }
        return null;
    }

    public void drop(DropTargetEvent event) {
        if (this.dragAndDropCommandInformation != null) {
            this.command = this.dragAndDropCommandInformation.createCommand();
        } else {
            this.source = this.getDragSource(event);
            if (this.source == null) {
                this.command = UnexecutableCommand.INSTANCE;
            } else {
                Object target = this.extractDropTarget(event.item);
                this.command = DragAndDropCommand.create((EditingDomain)this.domain, (Object)target, (float)this.getLocation(event), (int)event.operations, (int)this.originalOperation, (Collection)this.source);
            }
        }
        if (this.command.canExecute()) {
            this.domain.getCommandStack().execute(this.command);
            if (this.command instanceof DragAndDropFeedback) {
                DragAndDropFeedback feedback = (DragAndDropFeedback)this.command;
                event.detail = feedback.getOperation();
            }
        } else {
            event.detail = 0;
            this.command.dispose();
        }
        this.command = null;
        this.commandTarget = null;
        this.source = null;
        this.dragAndDropCommandInformation = null;
        this.unavailableDelegates = null;
        event.currentDataType = null;
    }
}

