import { ILogger } from './main';
/**
 * The DockerRegistryClient provides a way to communicate with the
 * official Docker registry hosted on Docker Hub.
 */
export declare class DockerRegistryClient {
    private readonly logger;
    constructor(logger?: ILogger);
    /**
     * Gets the list of tags of the specified image from the Docker registry on Docker Hub.
     *
     * @param image the name of the interested image
     * @param prefix an optional prefix for filtering the list of tags
     * @return a promise that resolves to the specified image's list
     *         of tags, may be empty
     */
    getTags(image: string, prefix?: string): Promise<string[]>;
    /**
     * Requests for an authentication token from the Docker registry
     * for accessing the given image.
     *
     * @param image the name of the interested image
     * @return a promise that resolves to the authentication token if
     *         successful, or null if an error has occurred
     */
    private requestToken(image);
    /**
     * Queries the registry for the given image's list of tags.
     *
     * @param authToken the authentication token to use for the GET
     * @param image the name of the interested image
     * @return a promise that will resolve to the image's list of
     *         tags, an empty array will be returned if an error
     *         occurs during the GET request
     */
    private listTags(authToken, image);
    private performHttpsGet(opts);
    private log(error);
}
