/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.widgets.file;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.internal.TransformationsMessages;
import org.eclipse.jwt.transformations.widgets.file.AbstractFilePickerController;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFilePickerController
extends AbstractFilePickerController<File> {
    private static final char EXTENSION_SEPARATOR = '.';

    public LocalFilePickerController(ContentChangeListener pageListener, AbstractFilePickerController.FileFilter filter, File defaultFile) {
        super(pageListener, filter, defaultFile);
    }

    @Override
    protected String fileToPath(File file) {
        if (file == null) {
            return "";
        }
        return file.getPath();
    }

    @Override
    protected File pathToFile(String path) {
        return new File(path);
    }

    @Override
    protected boolean isValid(File file, AbstractFilePickerController.FileFilter filter) {
        if (file == null || "".equals(file.getPath())) {
            return false;
        }
        if (!filter.getValidExtensions().isEmpty()) {
            int extensionIndex = file.getName().lastIndexOf(46);
            String extension = null;
            if (extensionIndex >= 0) {
                extension = file.getName().substring(extensionIndex);
            }
            if (filter.getValidExtensions().contains(extension)) {
                return false;
            }
        }
        if (file.exists() && !file.isFile()) {
            return false;
        }
        return !filter.mustExist() || file.exists();
    }

    @Override
    protected File doSelectFileInDialog(AbstractFilePickerController.FileFilter filter) {
        FileDialog dialog = new FileDialog(this.view.getShell(), filter.mustExist() ? 4096 : 8192);
        dialog.setText(TransformationsMessages.selectFile);
        dialog.setFilterExtensions(LocalFilePickerController.getSwtFilterExtensions(filter));
        String newfilePath = dialog.open();
        File newFile = this.pathToFile(newfilePath);
        if (this.isValid(newFile, filter)) {
            return newFile;
        }
        return null;
    }

    private static String[] getSwtFilterExtensions(AbstractFilePickerController.FileFilter filter) {
        Collection<String> validExtensions = filter.getValidExtensions();
        if (validExtensions.isEmpty()) {
            return new String[]{"*.*"};
        }
        String[] result = new String[validExtensions.size()];
        int index = 0;
        for (String extension : validExtensions) {
            result[index++] = "*." + extension;
        }
        return result;
    }

    @Override
    public void openFile() throws CoreException {
        URI uri = ((File)this.getSelection()).toURI();
        IFileStore fileStore = EFS.getStore((URI)uri);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }
}

