/**
 * generated by Xtext 2.20.0
 */
package org.eclipse.emf.parsley.dsl.model.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.emf.parsley.dsl.model.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.parsley.dsl.model.ModelPackage
 * @generated
 */
public class ModelSwitch<T> extends Switch<T>
{
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static ModelPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ModelSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = ModelPackage.eINSTANCE;
    }
  }

  /**
   * Checks whether this is a switch for the given package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param ePackage the package in question.
   * @return whether this is a switch for the given package.
   * @generated
   */
  @Override
  protected boolean isSwitchFor(EPackage ePackage)
  {
    return ePackage == modelPackage;
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  @Override
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case ModelPackage.MODEL:
      {
        Model model = (Model)theEObject;
        T result = caseModel(model);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.MODULE:
      {
        Module module = (Module)theEObject;
        T result = caseModule(module);
        if (result == null) result = caseWithExtendsClause(module);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.EXTENDS_CLAUSE:
      {
        ExtendsClause extendsClause = (ExtendsClause)theEObject;
        T result = caseExtendsClause(extendsClause);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.BINDINGS_SPECIFICATION:
      {
        BindingsSpecification bindingsSpecification = (BindingsSpecification)theEObject;
        T result = caseBindingsSpecification(bindingsSpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.BINDING:
      {
        Binding binding = (Binding)theEObject;
        T result = caseBinding(binding);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.LABEL_PROVIDER:
      {
        LabelProvider labelProvider = (LabelProvider)theEObject;
        T result = caseLabelProvider(labelProvider);
        if (result == null) result = caseWithFields(labelProvider);
        if (result == null) result = caseWithExtendsClause(labelProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FIELD_SPECIFICATION:
      {
        FieldSpecification fieldSpecification = (FieldSpecification)theEObject;
        T result = caseFieldSpecification(fieldSpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.TEXTS:
      {
        Texts texts = (Texts)theEObject;
        T result = caseTexts(texts);
        if (result == null) result = caseWithExpressions(texts);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.IMAGES:
      {
        Images images = (Images)theEObject;
        T result = caseImages(images);
        if (result == null) result = caseWithExpressions(images);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FONTS:
      {
        Fonts fonts = (Fonts)theEObject;
        T result = caseFonts(fonts);
        if (result == null) result = caseWithExpressions(fonts);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FOREGROUNDS:
      {
        Foregrounds foregrounds = (Foregrounds)theEObject;
        T result = caseForegrounds(foregrounds);
        if (result == null) result = caseWithExpressions(foregrounds);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.BACKGROUNDS:
      {
        Backgrounds backgrounds = (Backgrounds)theEObject;
        T result = caseBackgrounds(backgrounds);
        if (result == null) result = caseWithExpressions(backgrounds);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.TABLE_LABEL_PROVIDER:
      {
        TableLabelProvider tableLabelProvider = (TableLabelProvider)theEObject;
        T result = caseTableLabelProvider(tableLabelProvider);
        if (result == null) result = caseWithFields(tableLabelProvider);
        if (result == null) result = caseWithExtendsClause(tableLabelProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.POLYMORPHIC_SPECIFICATION:
      {
        PolymorphicSpecification polymorphicSpecification = (PolymorphicSpecification)theEObject;
        T result = casePolymorphicSpecification(polymorphicSpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_CAPTION_PROVIDER:
      {
        FeatureCaptionProvider featureCaptionProvider = (FeatureCaptionProvider)theEObject;
        T result = caseFeatureCaptionProvider(featureCaptionProvider);
        if (result == null) result = caseWithFields(featureCaptionProvider);
        if (result == null) result = caseWithExtendsClause(featureCaptionProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FORM_FEATURE_CAPTION_PROVIDER:
      {
        FormFeatureCaptionProvider formFeatureCaptionProvider = (FormFeatureCaptionProvider)theEObject;
        T result = caseFormFeatureCaptionProvider(formFeatureCaptionProvider);
        if (result == null) result = caseAbstractFeatureCaptionProviderWithLabel(formFeatureCaptionProvider);
        if (result == null) result = caseWithFields(formFeatureCaptionProvider);
        if (result == null) result = caseWithExtendsClause(formFeatureCaptionProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.DIALOG_FEATURE_CAPTION_PROVIDER:
      {
        DialogFeatureCaptionProvider dialogFeatureCaptionProvider = (DialogFeatureCaptionProvider)theEObject;
        T result = caseDialogFeatureCaptionProvider(dialogFeatureCaptionProvider);
        if (result == null) result = caseAbstractFeatureCaptionProviderWithLabel(dialogFeatureCaptionProvider);
        if (result == null) result = caseWithFields(dialogFeatureCaptionProvider);
        if (result == null) result = caseWithExtendsClause(dialogFeatureCaptionProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_TEXTS:
      {
        FeatureTexts featureTexts = (FeatureTexts)theEObject;
        T result = caseFeatureTexts(featureTexts);
        if (result == null) result = caseWithFeatureAssociatedExpressions(featureTexts);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_IMAGES:
      {
        FeatureImages featureImages = (FeatureImages)theEObject;
        T result = caseFeatureImages(featureImages);
        if (result == null) result = caseWithFeatureAssociatedExpressions(featureImages);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_FONTS:
      {
        FeatureFonts featureFonts = (FeatureFonts)theEObject;
        T result = caseFeatureFonts(featureFonts);
        if (result == null) result = caseWithFeatureAssociatedExpressions(featureFonts);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_FOREGROUNDS:
      {
        FeatureForegrounds featureForegrounds = (FeatureForegrounds)theEObject;
        T result = caseFeatureForegrounds(featureForegrounds);
        if (result == null) result = caseWithFeatureAssociatedExpressions(featureForegrounds);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_BACKGROUNDS:
      {
        FeatureBackgrounds featureBackgrounds = (FeatureBackgrounds)theEObject;
        T result = caseFeatureBackgrounds(featureBackgrounds);
        if (result == null) result = caseWithFeatureAssociatedExpressions(featureBackgrounds);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_LABELS:
      {
        FeatureLabels featureLabels = (FeatureLabels)theEObject;
        T result = caseFeatureLabels(featureLabels);
        if (result == null) result = caseWithFeatureAssociatedExpressions(featureLabels);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.WITH_FEATURE_ASSOCIATED_EXPRESSIONS:
      {
        WithFeatureAssociatedExpressions withFeatureAssociatedExpressions = (WithFeatureAssociatedExpressions)theEObject;
        T result = caseWithFeatureAssociatedExpressions(withFeatureAssociatedExpressions);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.ROW_FONTS:
      {
        RowFonts rowFonts = (RowFonts)theEObject;
        T result = caseRowFonts(rowFonts);
        if (result == null) result = caseWithExpressions(rowFonts);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.ROW_FOREGROUNDS:
      {
        RowForegrounds rowForegrounds = (RowForegrounds)theEObject;
        T result = caseRowForegrounds(rowForegrounds);
        if (result == null) result = caseWithExpressions(rowForegrounds);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.ROW_BACKGROUNDS:
      {
        RowBackgrounds rowBackgrounds = (RowBackgrounds)theEObject;
        T result = caseRowBackgrounds(rowBackgrounds);
        if (result == null) result = caseWithExpressions(rowBackgrounds);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.WITH_EXPRESSIONS:
      {
        WithExpressions withExpressions = (WithExpressions)theEObject;
        T result = caseWithExpressions(withExpressions);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_ASSOCIATED_EXPRESSION:
      {
        FeatureAssociatedExpression featureAssociatedExpression = (FeatureAssociatedExpression)theEObject;
        T result = caseFeatureAssociatedExpression(featureAssociatedExpression);
        if (result == null) result = caseEmfFeatureAccess(featureAssociatedExpression);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURES_PROVIDER:
      {
        FeaturesProvider featuresProvider = (FeaturesProvider)theEObject;
        T result = caseFeaturesProvider(featuresProvider);
        if (result == null) result = caseAbstractFeatureProvider(featuresProvider);
        if (result == null) result = caseWithFields(featuresProvider);
        if (result == null) result = caseWithExtendsClause(featuresProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.TABLE_FEATURES_PROVIDER:
      {
        TableFeaturesProvider tableFeaturesProvider = (TableFeaturesProvider)theEObject;
        T result = caseTableFeaturesProvider(tableFeaturesProvider);
        if (result == null) result = caseAbstractFeatureProvider(tableFeaturesProvider);
        if (result == null) result = caseWithFields(tableFeaturesProvider);
        if (result == null) result = caseWithExtendsClause(tableFeaturesProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_SPECIFICATIONS:
      {
        FeatureSpecifications featureSpecifications = (FeatureSpecifications)theEObject;
        T result = caseFeatureSpecifications(featureSpecifications);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FEATURE_SPECIFICATION:
      {
        FeatureSpecification featureSpecification = (FeatureSpecification)theEObject;
        T result = caseFeatureSpecification(featureSpecification);
        if (result == null) result = caseEmfFeatureAccess(featureSpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.FORM_CONTROL_FACTORY:
      {
        FormControlFactory formControlFactory = (FormControlFactory)theEObject;
        T result = caseFormControlFactory(formControlFactory);
        if (result == null) result = caseAbstractControlFactory(formControlFactory);
        if (result == null) result = caseWithFields(formControlFactory);
        if (result == null) result = caseWithExtendsClause(formControlFactory);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.DIALOG_CONTROL_FACTORY:
      {
        DialogControlFactory dialogControlFactory = (DialogControlFactory)theEObject;
        T result = caseDialogControlFactory(dialogControlFactory);
        if (result == null) result = caseAbstractControlFactory(dialogControlFactory);
        if (result == null) result = caseWithFields(dialogControlFactory);
        if (result == null) result = caseWithExtendsClause(dialogControlFactory);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.CONTROL_FACTORY_SPECIFICATIONS:
      {
        ControlFactorySpecifications controlFactorySpecifications = (ControlFactorySpecifications)theEObject;
        T result = caseControlFactorySpecifications(controlFactorySpecifications);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.CONTROL_FACTORY_SPECIFICATION:
      {
        ControlFactorySpecification controlFactorySpecification = (ControlFactorySpecification)theEObject;
        T result = caseControlFactorySpecification(controlFactorySpecification);
        if (result == null) result = caseEmfFeatureAccess(controlFactorySpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.PROPOSAL_CREATOR:
      {
        ProposalCreator proposalCreator = (ProposalCreator)theEObject;
        T result = caseProposalCreator(proposalCreator);
        if (result == null) result = caseWithFields(proposalCreator);
        if (result == null) result = caseWithExtendsClause(proposalCreator);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.MENU_BUILDER:
      {
        MenuBuilder menuBuilder = (MenuBuilder)theEObject;
        T result = caseMenuBuilder(menuBuilder);
        if (result == null) result = caseWithFields(menuBuilder);
        if (result == null) result = caseWithExtendsClause(menuBuilder);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.MENUS:
      {
        Menus menus = (Menus)theEObject;
        T result = caseMenus(menus);
        if (result == null) result = caseWithExpressions(menus);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.EMF_MENUS:
      {
        EmfMenus emfMenus = (EmfMenus)theEObject;
        T result = caseEmfMenus(emfMenus);
        if (result == null) result = caseWithExpressions(emfMenus);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.CONFIGURATOR:
      {
        Configurator configurator = (Configurator)theEObject;
        T result = caseConfigurator(configurator);
        if (result == null) result = caseWithFields(configurator);
        if (result == null) result = caseWithExtendsClause(configurator);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.CONFIGURATOR_RESOURCE_URI:
      {
        ConfiguratorResourceURI configuratorResourceURI = (ConfiguratorResourceURI)theEObject;
        T result = caseConfiguratorResourceURI(configuratorResourceURI);
        if (result == null) result = caseWithExpressions(configuratorResourceURI);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.CONFIGURATOR_ECLASS:
      {
        ConfiguratorEClass configuratorEClass = (ConfiguratorEClass)theEObject;
        T result = caseConfiguratorEClass(configuratorEClass);
        if (result == null) result = caseWithExpressions(configuratorEClass);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.VIEWER_CONTENT_PROVIDER:
      {
        ViewerContentProvider viewerContentProvider = (ViewerContentProvider)theEObject;
        T result = caseViewerContentProvider(viewerContentProvider);
        if (result == null) result = caseWithFields(viewerContentProvider);
        if (result == null) result = caseWithExtendsClause(viewerContentProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.TABLE_VIEWER_CONTENT_PROVIDER:
      {
        TableViewerContentProvider tableViewerContentProvider = (TableViewerContentProvider)theEObject;
        T result = caseTableViewerContentProvider(tableViewerContentProvider);
        if (result == null) result = caseWithFields(tableViewerContentProvider);
        if (result == null) result = caseWithExtendsClause(tableViewerContentProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.CONTENT_PROVIDER_CHILDREN:
      {
        ContentProviderChildren contentProviderChildren = (ContentProviderChildren)theEObject;
        T result = caseContentProviderChildren(contentProviderChildren);
        if (result == null) result = caseWithExpressions(contentProviderChildren);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.CONTENT_PROVIDER_ELEMENTS:
      {
        ContentProviderElements contentProviderElements = (ContentProviderElements)theEObject;
        T result = caseContentProviderElements(contentProviderElements);
        if (result == null) result = caseWithExpressions(contentProviderElements);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.RESOURCE_MANAGER:
      {
        ResourceManager resourceManager = (ResourceManager)theEObject;
        T result = caseResourceManager(resourceManager);
        if (result == null) result = caseWithFields(resourceManager);
        if (result == null) result = caseWithExtendsClause(resourceManager);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.SIMPLE_METHOD_SPECIFICATION:
      {
        SimpleMethodSpecification simpleMethodSpecification = (SimpleMethodSpecification)theEObject;
        T result = caseSimpleMethodSpecification(simpleMethodSpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.EMF_FEATURE_ACCESS:
      {
        EmfFeatureAccess emfFeatureAccess = (EmfFeatureAccess)theEObject;
        T result = caseEmfFeatureAccess(emfFeatureAccess);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL:
      {
        AbstractFeatureCaptionProviderWithLabel abstractFeatureCaptionProviderWithLabel = (AbstractFeatureCaptionProviderWithLabel)theEObject;
        T result = caseAbstractFeatureCaptionProviderWithLabel(abstractFeatureCaptionProviderWithLabel);
        if (result == null) result = caseWithFields(abstractFeatureCaptionProviderWithLabel);
        if (result == null) result = caseWithExtendsClause(abstractFeatureCaptionProviderWithLabel);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.ABSTRACT_FEATURE_PROVIDER:
      {
        AbstractFeatureProvider abstractFeatureProvider = (AbstractFeatureProvider)theEObject;
        T result = caseAbstractFeatureProvider(abstractFeatureProvider);
        if (result == null) result = caseWithFields(abstractFeatureProvider);
        if (result == null) result = caseWithExtendsClause(abstractFeatureProvider);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.ABSTRACT_CONTROL_FACTORY:
      {
        AbstractControlFactory abstractControlFactory = (AbstractControlFactory)theEObject;
        T result = caseAbstractControlFactory(abstractControlFactory);
        if (result == null) result = caseWithFields(abstractControlFactory);
        if (result == null) result = caseWithExtendsClause(abstractControlFactory);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.WITH_EXTENDS_CLAUSE:
      {
        WithExtendsClause withExtendsClause = (WithExtendsClause)theEObject;
        T result = caseWithExtendsClause(withExtendsClause);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.WITH_FIELDS:
      {
        WithFields withFields = (WithFields)theEObject;
        T result = caseWithFields(withFields);
        if (result == null) result = caseWithExtendsClause(withFields);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.PARTS_SPECIFICATIONS:
      {
        PartsSpecifications partsSpecifications = (PartsSpecifications)theEObject;
        T result = casePartsSpecifications(partsSpecifications);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.PART_SPECIFICATION:
      {
        PartSpecification partSpecification = (PartSpecification)theEObject;
        T result = casePartSpecification(partSpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.VIEW_SPECIFICATION:
      {
        ViewSpecification viewSpecification = (ViewSpecification)theEObject;
        T result = caseViewSpecification(viewSpecification);
        if (result == null) result = casePartSpecification(viewSpecification);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.TYPE_BINDING:
      {
        TypeBinding typeBinding = (TypeBinding)theEObject;
        T result = caseTypeBinding(typeBinding);
        if (result == null) result = caseBinding(typeBinding);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.PROVIDER_BINDING:
      {
        ProviderBinding providerBinding = (ProviderBinding)theEObject;
        T result = caseProviderBinding(providerBinding);
        if (result == null) result = caseBinding(providerBinding);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case ModelPackage.VALUE_BINDING:
      {
        ValueBinding valueBinding = (ValueBinding)theEObject;
        T result = caseValueBinding(valueBinding);
        if (result == null) result = caseBinding(valueBinding);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Model</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Model</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseModel(Model object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Module</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Module</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseModule(Module object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Extends Clause</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Extends Clause</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseExtendsClause(ExtendsClause object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Bindings Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Bindings Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBindingsSpecification(BindingsSpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Binding</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Binding</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBinding(Binding object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Label Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Label Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLabelProvider(LabelProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Field Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Field Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFieldSpecification(FieldSpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Texts</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Texts</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTexts(Texts object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Images</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Images</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseImages(Images object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Fonts</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Fonts</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFonts(Fonts object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Foregrounds</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Foregrounds</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseForegrounds(Foregrounds object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Backgrounds</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Backgrounds</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBackgrounds(Backgrounds object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Table Label Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Table Label Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTableLabelProvider(TableLabelProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Polymorphic Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Polymorphic Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePolymorphicSpecification(PolymorphicSpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Caption Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Caption Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureCaptionProvider(FeatureCaptionProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Form Feature Caption Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Form Feature Caption Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFormFeatureCaptionProvider(FormFeatureCaptionProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Dialog Feature Caption Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Dialog Feature Caption Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDialogFeatureCaptionProvider(DialogFeatureCaptionProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Texts</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Texts</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureTexts(FeatureTexts object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Images</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Images</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureImages(FeatureImages object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Fonts</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Fonts</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureFonts(FeatureFonts object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Foregrounds</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Foregrounds</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureForegrounds(FeatureForegrounds object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Backgrounds</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Backgrounds</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureBackgrounds(FeatureBackgrounds object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Labels</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Labels</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureLabels(FeatureLabels object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>With Feature Associated Expressions</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>With Feature Associated Expressions</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseWithFeatureAssociatedExpressions(WithFeatureAssociatedExpressions object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Row Fonts</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Row Fonts</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRowFonts(RowFonts object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Row Foregrounds</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Row Foregrounds</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRowForegrounds(RowForegrounds object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Row Backgrounds</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Row Backgrounds</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRowBackgrounds(RowBackgrounds object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>With Expressions</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>With Expressions</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseWithExpressions(WithExpressions object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Associated Expression</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Associated Expression</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureAssociatedExpression(FeatureAssociatedExpression object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Features Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Features Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeaturesProvider(FeaturesProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Table Features Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Table Features Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTableFeaturesProvider(TableFeaturesProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Specifications</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Specifications</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureSpecifications(FeatureSpecifications object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureSpecification(FeatureSpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Form Control Factory</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Form Control Factory</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFormControlFactory(FormControlFactory object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Dialog Control Factory</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Dialog Control Factory</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDialogControlFactory(DialogControlFactory object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Control Factory Specifications</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Control Factory Specifications</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseControlFactorySpecifications(ControlFactorySpecifications object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Control Factory Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Control Factory Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseControlFactorySpecification(ControlFactorySpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Proposal Creator</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Proposal Creator</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseProposalCreator(ProposalCreator object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Menu Builder</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Menu Builder</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMenuBuilder(MenuBuilder object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Menus</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Menus</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMenus(Menus object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Emf Menus</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Emf Menus</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEmfMenus(EmfMenus object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Configurator</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Configurator</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseConfigurator(Configurator object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Configurator Resource URI</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Configurator Resource URI</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseConfiguratorResourceURI(ConfiguratorResourceURI object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Configurator EClass</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Configurator EClass</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseConfiguratorEClass(ConfiguratorEClass object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Viewer Content Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Viewer Content Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseViewerContentProvider(ViewerContentProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Table Viewer Content Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Table Viewer Content Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTableViewerContentProvider(TableViewerContentProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Content Provider Children</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Content Provider Children</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseContentProviderChildren(ContentProviderChildren object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Content Provider Elements</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Content Provider Elements</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseContentProviderElements(ContentProviderElements object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Resource Manager</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Resource Manager</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseResourceManager(ResourceManager object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Simple Method Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Simple Method Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSimpleMethodSpecification(SimpleMethodSpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Emf Feature Access</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Emf Feature Access</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEmfFeatureAccess(EmfFeatureAccess object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Abstract Feature Caption Provider With Label</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Abstract Feature Caption Provider With Label</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAbstractFeatureCaptionProviderWithLabel(AbstractFeatureCaptionProviderWithLabel object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Abstract Feature Provider</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Abstract Feature Provider</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAbstractFeatureProvider(AbstractFeatureProvider object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Abstract Control Factory</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Abstract Control Factory</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAbstractControlFactory(AbstractControlFactory object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>With Extends Clause</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>With Extends Clause</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseWithExtendsClause(WithExtendsClause object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>With Fields</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>With Fields</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseWithFields(WithFields object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Parts Specifications</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Parts Specifications</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePartsSpecifications(PartsSpecifications object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Part Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Part Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePartSpecification(PartSpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>View Specification</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>View Specification</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseViewSpecification(ViewSpecification object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Type Binding</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Type Binding</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTypeBinding(TypeBinding object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Provider Binding</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Provider Binding</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseProviderBinding(ProviderBinding object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Value Binding</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Value Binding</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseValueBinding(ValueBinding object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  @Override
  public T defaultCase(EObject object)
  {
    return null;
  }

} //ModelSwitch
