/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfstore.client.observer.ESExceptionObserver;
import org.eclipse.emf.emfstore.internal.client.model.Activator;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;

public final class WorkspaceUtil {
    private static IResourceLogger resourceLogger = new IResourceLogger(){

        public void logWarning(String msg) {
            WorkspaceUtil.log(msg, 2);
        }

        public void logError(String msg) {
            WorkspaceUtil.log(msg, 4);
        }
    };

    private WorkspaceUtil() {
    }

    public static IResourceLogger getResourceLogger() {
        return resourceLogger;
    }

    public static void logException(String message, Exception e) {
        WorkspaceUtil.log(message, e, 4);
    }

    public static void logWarning(String message, Exception e) {
        WorkspaceUtil.log(message, e, 2);
    }

    public static void log(String message, Exception exception, int statusInt) {
        Activator activator = Activator.getDefault();
        Status status = new Status(statusInt, activator.getBundle().getSymbolicName(), statusInt, message, (Throwable)exception);
        activator.getLog().log((IStatus)status);
    }

    public static void log(String message, int statusInt) {
        Activator activator = Activator.getDefault();
        Status status = new Status(statusInt, activator.getBundle().getSymbolicName(), message);
        activator.getLog().log((IStatus)status);
    }

    public static void handleException(String errorMessage, Exception exception) {
        WorkspaceUtil.wrapAndHandleException(errorMessage, exception);
    }

    public static void handleException(Exception exception) {
        WorkspaceUtil.wrapAndHandleException(exception.getMessage(), exception);
    }

    private static void wrapAndHandleException(String errorMessage, Exception exception) {
        RuntimeException runtimeException = new RuntimeException(errorMessage, exception);
        Boolean errorHandeled = ((ESExceptionObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESExceptionObserver.class)).handleError(runtimeException);
        WorkspaceUtil.logException(exception.getMessage(), exception);
        if (!errorHandeled.booleanValue()) {
            throw runtimeException;
        }
    }
}

