/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl.api;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESWorkspace;
import org.eclipse.emf.emfstore.client.exceptions.ESServerNotFoundException;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.UnkownProjectException;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.Messages;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithResult;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.common.api.AbstractAPIImpl;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESWorkspaceImpl
extends AbstractAPIImpl<ESWorkspaceImpl, Workspace>
implements ESWorkspace {
    public ESWorkspaceImpl(Workspace workspace) {
        super((APIDelegate)workspace);
    }

    @Override
    public List<ESLocalProject> getLocalProjects() {
        return RunESCommand.runWithResult(new Callable<List<ESLocalProject>>(){

            @Override
            public List<ESLocalProject> call() throws Exception {
                return APIUtil.mapToAPI(ESLocalProject.class, ((Workspace)ESWorkspaceImpl.this.toInternalAPI()).getProjectSpaces());
            }
        });
    }

    @Override
    public ESLocalProjectImpl createLocalProject(final String projectName) {
        return (ESLocalProjectImpl)new EMFStoreCommandWithResult<ESLocalProjectImpl>(){

            @Override
            protected ESLocalProjectImpl doRun() {
                ProjectSpace projectSpace = ((Workspace)ESWorkspaceImpl.this.toInternalAPI()).createLocalProject(projectName);
                return (ESLocalProjectImpl)projectSpace.toAPI();
            }
        }.run(false);
    }

    @Override
    public List<ESServer> getServers() {
        return RunESCommand.runWithResult(new Callable<List<ESServer>>(){

            @Override
            public List<ESServer> call() throws Exception {
                return APIUtil.mapToAPI(ESServer.class, ((Workspace)ESWorkspaceImpl.this.toInternalAPI()).getServerInfos());
            }
        });
    }

    @Override
    public ESServerImpl addServer(ESServer server) {
        final ESServerImpl serverImpl = (ESServerImpl)server;
        RunESCommand.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((Workspace)ESWorkspaceImpl.this.toInternalAPI()).addServerInfo((ServerInfo)serverImpl.toInternalAPI());
                return null;
            }
        });
        return serverImpl;
    }

    public boolean serverExists(ESServer server) {
        ESServer existingServer = this.getExistingServer(server);
        return existingServer != null;
    }

    private ESServer getExistingServer(ESServer server) {
        for (ESServer s : this.getServers()) {
            if (s != server) continue;
            return s;
        }
        return null;
    }

    @Override
    public void removeServer(ESServer server) throws ESServerNotFoundException {
        ESServerImpl serverImpl = (ESServerImpl)server;
        final ESServerImpl existingServer = (ESServerImpl)this.getExistingServer(serverImpl);
        if (existingServer == null) {
            throw new ESServerNotFoundException(MessageFormat.format(Messages.ESWorkspaceImpl_Server_Not_Found, server));
        }
        RunESCommand.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((Workspace)ESWorkspaceImpl.this.toInternalAPI()).removeServerInfo((ServerInfo)existingServer.toInternalAPI());
                return null;
            }
        });
        ((Workspace)this.toInternalAPI()).save();
    }

    @Override
    public ESLocalProject getLocalProject(final EObject modelElement) {
        try {
            return RunESCommand.WithException.runWithResult(UnkownProjectException.class, new Callable<ESLocalProject>(){

                @Override
                public ESLocalProject call() throws Exception {
                    Project project = ModelUtil.getProject((EObject)modelElement);
                    ProjectSpace projectSpace = ((Workspace)ESWorkspaceImpl.this.toInternalAPI()).getProjectSpace(project);
                    return (ESLocalProject)projectSpace.toAPI();
                }
            });
        }
        catch (UnkownProjectException unkownProjectException) {
            return null;
        }
    }

    @Override
    public Set<ESLocalProject> getLocalProjectByName(String projectName) {
        LinkedHashSet<ESLocalProject> projects = new LinkedHashSet<ESLocalProject>();
        List<ESLocalProject> localProjects = this.getLocalProjects();
        for (ESLocalProject localProject : localProjects) {
            if (!localProject.getProjectName().equalsIgnoreCase(projectName)) continue;
            projects.add(localProject);
        }
        return projects;
    }
}

