/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transaction;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler2;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

public class CDOTransactionCommentator
implements Closeable {
    public static final String MERGE_PREFIX = "Merge from ";
    private final IListener transactionListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOTransactionCommentator.this.close();
        }
    };
    private final CDOTransactionHandler2 transactionHandler = new CDOTransactionHandler2(){
        private String lastComment;

        public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.lastComment = CDOTransactionCommentator.this.createComment(commitContext);
            if (this.lastComment != null) {
                String commitComment = transaction.getCommitComment();
                if (commitComment != null) {
                    transaction.setCommitComment(String.valueOf(commitComment) + " " + this.lastComment);
                } else {
                    transaction.setCommitComment(this.lastComment);
                }
            }
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.cleanUp();
        }

        public void rolledBackTransaction(CDOTransaction transaction) {
            this.cleanUp();
        }

        private void cleanUp() {
            String commitComment;
            if (this.lastComment != null && (commitComment = CDOTransactionCommentator.this.transaction.getCommitComment()) != null && commitComment.endsWith(this.lastComment)) {
                commitComment = commitComment.substring(0, commitComment.length() - this.lastComment.length());
                CDOTransactionCommentator.this.transaction.setCommitComment(commitComment.trim());
            }
            this.lastComment = null;
        }
    };
    private CDOTransaction transaction;
    private boolean showMerges;

    public CDOTransactionCommentator(CDOTransaction transaction) {
        this(transaction, false);
    }

    public CDOTransactionCommentator(final CDOTransaction transaction, boolean showMerges) {
        this.transaction = transaction;
        this.showMerges = showMerges;
        transaction.syncExec(new Runnable(){

            public void run() {
                transaction.addListener(CDOTransactionCommentator.this.transactionListener);
                transaction.addTransactionHandler(CDOTransactionCommentator.this.transactionHandler);
            }
        });
    }

    public final CDOTransaction getTransaction() {
        return this.transaction;
    }

    public final boolean isShowMerges() {
        return this.showMerges;
    }

    public final void setShowMerges(final boolean showMerges) {
        this.transaction.syncExec(new Runnable(){

            public void run() {
                CDOTransactionCommentator.this.showMerges = showMerges;
            }
        });
    }

    public final boolean isClosed() {
        return this.transaction == null;
    }

    public void close() {
        this.transaction.syncExec(new Runnable(){

            public void run() {
                CDOTransactionCommentator.this.transaction.removeTransactionHandler(CDOTransactionCommentator.this.transactionHandler);
                CDOTransactionCommentator.this.transaction.removeListener(CDOTransactionCommentator.this.transactionListener);
            }
        });
        this.transaction = null;
    }

    protected String createComment(CDOCommitContext commitContext) {
        StringBuilder builder = new StringBuilder();
        CDOTransactionCommentator.appendSummary(builder, commitContext);
        return builder.toString();
    }

    public static boolean appendMerge(StringBuilder builder, CDOBranchPoint mergeSource) {
        if (mergeSource != null) {
            builder.append(MERGE_PREFIX);
            builder.append(mergeSource.getBranch().getPathName());
            builder.append(", ");
            builder.append(CDOCommonUtil.formatTimeStamp((long)mergeSource.getTimeStamp()));
            return true;
        }
        return false;
    }

    public static void appendSummary(StringBuilder builder, CDOCommitContext commitContext) {
        CDOTransactionCommentator.appendSummary(builder, commitContext, false);
    }

    public static boolean appendSummary(StringBuilder builder, CDOCommitContext commitContext, boolean showMerges) {
        boolean needComma = false;
        if (showMerges) {
            CDOBranchPoint mergeSource = commitContext.getCommitMergeSource();
            needComma |= CDOTransactionCommentator.appendMerge(builder, mergeSource);
        }
        needComma |= CDOTransactionCommentator.appendSummary(builder, needComma, commitContext.getNewObjects().size(), "addition");
        needComma |= CDOTransactionCommentator.appendSummary(builder, needComma, commitContext.getDirtyObjects().size(), "change");
        needComma |= CDOTransactionCommentator.appendSummary(builder, needComma, commitContext.getDetachedObjects().size(), "removal");
        return needComma;
    }

    private static boolean appendSummary(StringBuilder builder, boolean needComma, int count, String label) {
        if (count > 0) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append(count);
            builder.append(" ");
            builder.append(label);
            if (count > 1) {
                builder.append("s");
            }
            return true;
        }
        return false;
    }
}

