/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.example.collab.share.GenericSharedObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class HelloMessageSharedObject
extends GenericSharedObject {
    private String message;
    private String sender;

    public HelloMessageSharedObject() {
        this.sender = "<unknown>";
        this.message = " says hello";
    }

    public HelloMessageSharedObject(String message, String sender) {
        this.message = message;
        this.sender = sender;
    }

    public void init(ISharedObjectConfig soconfig) throws SharedObjectInitException {
        super.init(soconfig);
        Map aMap = soconfig.getProperties();
        Object[] args = (Object[])aMap.get("args");
        if (args != null && args.length == 2) {
            this.message = (String)args[0];
            this.sender = (String)args[1];
        }
    }

    public void activated(ID[] others) {
        super.activated(others);
        this.showMessage();
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID remoteID) {
        Object[] remoteArgs = new Object[]{this.message, this.sender};
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("args", remoteArgs);
        return new ReplicaSharedObjectDescription(this.getClass(), this.getID(), this.getConfig().getHomeContainerID(), map, HelloMessageSharedObject.getNextReplicateID());
    }

    protected void showMessage() {
        try {
            if (!this.getContext().isGroupManager()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Display.getDefault().beep();
                        MessageDialog.openInformation(null, (String)NLS.bind((String)"Message from ", (Object)HelloMessageSharedObject.this.sender), (String)NLS.bind((String)"{0} says {1}", (Object)HelloMessageSharedObject.this.sender, (Object)HelloMessageSharedObject.this.message));
                    }
                });
            }
        }
        catch (Exception e) {
            this.log("Exception showing message dialog ", e);
        }
        this.destroySelf();
    }
}

