/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.startcommand;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cft.server.standalone.core.internal.startcommand.StartCommand;
import org.eclipse.cft.server.standalone.core.internal.startcommand.StartCommandType;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.StartCommandPart;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.StartCommandPartFactory;
import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StandaloneStartCommandPart
extends UIPart
implements IPartChangeListener {
    private final StartCommand startCommand;
    private Map<StartCommandType, StartCommandPart> startCommandAreas = new HashMap<StartCommandType, StartCommandPart>();
    private final IProject project;

    public StandaloneStartCommandPart(StartCommand startCommand, IProject project) {
        this.startCommand = startCommand;
        this.project = project;
    }

    public Composite createPart(Composite parent) {
        this.createStandaloneSection(parent);
        return parent;
    }

    protected void createStandaloneSection(Composite parent) {
        List commandTypes = this.startCommand.getStartCommandTypes();
        StartCommandPartFactory partFactory = new StartCommandPartFactory(this.startCommand, this.project);
        boolean createdControls = false;
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        label.setText("Start Command:");
        Composite startCommandArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(startCommandArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)startCommandArea);
        if (!commandTypes.isEmpty()) {
            createdControls = this.createStartCommandArea(commandTypes, partFactory, startCommandArea);
        }
        if (!createdControls) {
            partFactory.createStartCommandTypePart(StartCommandType.Other, startCommandArea);
        }
    }

    protected boolean createStartCommandArea(List<StartCommandType> commandTypes, StartCommandPartFactory partFactory, Composite parent) {
        if (commandTypes.isEmpty()) {
            return false;
        }
        int columnNumber = commandTypes.size();
        Composite buttonSelectionArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(columnNumber).applyTo(buttonSelectionArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonSelectionArea);
        StartCommandType defaultStartCommandType = this.startCommand.getDefaultStartCommandType();
        for (StartCommandType commandType : commandTypes) {
            if (defaultStartCommandType == null) {
                defaultStartCommandType = commandType;
            }
            final Button radio = new Button(buttonSelectionArea, 16);
            radio.setText(commandType.name());
            radio.setToolTipText(commandType.getDescription());
            radio.setData((Object)commandType);
            boolean isSelected = commandType.equals((Object)defaultStartCommandType);
            radio.setSelection(isSelected);
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (radio.getSelection()) {
                        StartCommandType type = (StartCommandType)radio.getData();
                        StandaloneStartCommandPart.this.makeStartCommandControlsVisible(type);
                        StartCommandPart part = (StartCommandPart)((Object)StandaloneStartCommandPart.this.startCommandAreas.get(type));
                        if (part != null) {
                            part.updateStartCommand();
                        }
                    }
                }
            });
        }
        Composite startCompositeArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(startCompositeArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)startCompositeArea);
        for (StartCommandType commandType : commandTypes) {
            StartCommandPart commandPart = partFactory.createStartCommandTypePart(commandType, startCompositeArea);
            if (commandPart == null) continue;
            commandPart.addPartChangeListener(this);
            this.startCommandAreas.put(commandType, commandPart);
        }
        this.makeStartCommandControlsVisible(defaultStartCommandType);
        return true;
    }

    protected void makeStartCommandControlsVisible(StartCommandType typeToMakeVisible) {
        Control areaToMakeVisible;
        StartCommandPart part = this.startCommandAreas.get(typeToMakeVisible);
        Control control = areaToMakeVisible = part != null ? part.getComposite() : null;
        if (areaToMakeVisible != null && !areaToMakeVisible.isDisposed()) {
            GridData data = (GridData)areaToMakeVisible.getLayoutData();
            GridDataFactory.createFrom((GridData)data).exclude(false).applyTo(areaToMakeVisible);
            areaToMakeVisible.setVisible(true);
            for (StartCommandType otherTypes : this.startCommandAreas.keySet()) {
                Control otherAreaComposite;
                StartCommandPart otherArea;
                if (otherTypes.equals((Object)typeToMakeVisible) || (otherArea = this.startCommandAreas.get(otherTypes)) == null || (otherAreaComposite = otherArea.getComposite()).isDisposed()) continue;
                data = (GridData)otherAreaComposite.getLayoutData();
                GridDataFactory.createFrom((GridData)data).exclude(true).applyTo(otherAreaComposite);
                otherAreaComposite.setVisible(false);
            }
            areaToMakeVisible.getParent().layout(true, true);
        }
    }

    public void handleChange(PartChangeEvent event) {
        this.notifyStatusChange(event.getData(), event.getStatus());
    }
}

