/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.impl;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.client.subsystem.sftp.impl.AbstractSftpClient;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.subsystem.sftp.SftpConstants;
import org.apache.sshd.common.subsystem.sftp.extensions.ParserUtils;
import org.apache.sshd.common.subsystem.sftp.extensions.VersionsParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class DefaultSftpClient
extends AbstractSftpClient {
    private final ClientSession clientSession;
    private final ChannelSubsystem channel;
    private final Map<Integer, Buffer> messages = new HashMap<Integer, Buffer>();
    private final AtomicInteger cmdId = new AtomicInteger(100);
    private final Buffer receiveBuffer = new ByteArrayBuffer();
    private final byte[] workBuf = new byte[4];
    private final AtomicInteger versionHolder = new AtomicInteger(0);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final NavigableMap<String, byte[]> extensions = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
    private final NavigableMap<String, byte[]> exposedExtensions = Collections.unmodifiableNavigableMap(this.extensions);
    private Charset nameDecodingCharset = DEFAULT_NAME_DECODING_CHARSET;

    public DefaultSftpClient(ClientSession clientSession) throws IOException {
        this.nameDecodingCharset = PropertyResolverUtils.getCharset((PropertyResolver)clientSession, (String)"sftp-name-decoding-charset", (Charset)DEFAULT_NAME_DECODING_CHARSET);
        this.clientSession = Objects.requireNonNull(clientSession, "No client session");
        this.channel = clientSession.createSubsystemChannel("sftp");
        this.channel.setOut(new OutputStream(){
            private final byte[] singleByte = new byte[1];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b) throws IOException {
                byte[] byArray = this.singleByte;
                synchronized (this.singleByte) {
                    this.singleByte[0] = (byte)b;
                    this.write(this.singleByte);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                DefaultSftpClient.this.data(b, off, len);
            }
        });
        this.channel.setErr((OutputStream)new ByteArrayOutputStream(127));
        long initializationTimeout = clientSession.getLongProperty("sftp-channel-open-timeout", DEFAULT_CHANNEL_OPEN_TIMEOUT);
        this.channel.open().verify(initializationTimeout);
        this.channel.onClose(() -> {
            Map<Integer, Buffer> map = this.messages;
            synchronized (map) {
                this.closing.set(true);
                this.messages.notifyAll();
            }
            if (this.versionHolder.get() <= 0) {
                this.log.warn("onClose({}) closed before version negotiated", (Object)this.channel);
            }
        });
        try {
            this.init(initializationTimeout);
        }
        catch (IOException | RuntimeException e) {
            this.channel.close(true);
            throw e;
        }
    }

    @Override
    public int getVersion() {
        return this.versionHolder.get();
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public ClientChannel getClientChannel() {
        return this.channel;
    }

    @Override
    public NavigableMap<String, byte[]> getServerExtensions() {
        return this.exposedExtensions;
    }

    @Override
    public Charset getNameDecodingCharset() {
        return this.nameDecodingCharset;
    }

    @Override
    public void setNameDecodingCharset(Charset nameDecodingCharset) {
        this.nameDecodingCharset = Objects.requireNonNull(nameDecodingCharset, "No charset provided");
    }

    @Override
    public boolean isClosing() {
        return this.closing.get();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            this.channel.close(false);
        }
    }

    protected int data(byte[] buf, int start, int len) throws IOException {
        ByteArrayBuffer incoming = new ByteArrayBuffer(buf, start, len);
        if (this.receiveBuffer.available() > 0) {
            this.receiveBuffer.putBuffer((Readable)incoming);
            incoming = this.receiveBuffer;
        }
        int rpos = incoming.rpos();
        boolean traceEnabled = this.log.isTraceEnabled();
        int count = 1;
        while (this.receive((Buffer)incoming)) {
            if (traceEnabled) {
                this.log.trace("data({}) Processed {} data messages", (Object)this.getClientChannel(), (Object)count);
            }
            ++count;
        }
        int read = incoming.rpos() - rpos;
        this.receiveBuffer.compact();
        if (this.receiveBuffer != incoming && incoming.available() > 0) {
            this.receiveBuffer.putBuffer((Readable)incoming);
        }
        return read;
    }

    protected boolean receive(Buffer incoming) throws IOException {
        int rpos = incoming.rpos();
        int wpos = incoming.wpos();
        ClientSession session = this.getClientSession();
        session.resetIdleTimeout();
        if (wpos - rpos > 4) {
            int length = incoming.getInt();
            if (length < 5) {
                throw new IOException("Illegal sftp packet length: " + length);
            }
            if (length > 262144) {
                throw new StreamCorruptedException("Illogical sftp packet length: " + length);
            }
            if (wpos - rpos >= length + 4) {
                incoming.rpos(rpos);
                incoming.wpos(rpos + 4 + length);
                this.process(incoming);
                incoming.rpos(rpos + 4 + length);
                incoming.wpos(wpos);
                return true;
            }
        }
        incoming.rpos(rpos);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Buffer incoming) throws IOException {
        ByteArrayBuffer buffer = new ByteArrayBuffer(incoming.available() + 64, false);
        buffer.putBuffer((Readable)incoming);
        int rpos = buffer.rpos();
        int length = buffer.getInt();
        int type = buffer.getUByte();
        Integer id = buffer.getInt();
        buffer.rpos(rpos);
        if (this.log.isTraceEnabled()) {
            this.log.trace("process({}) id={}, type={}, len={}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(type), length});
        }
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            this.messages.put(id, (Buffer)buffer);
            this.messages.notifyAll();
        }
    }

    @Override
    public int send(int cmd, Buffer buffer) throws IOException {
        int id = this.cmdId.incrementAndGet();
        int len = buffer.available();
        if (this.log.isTraceEnabled()) {
            this.log.trace("send({}) cmd={}, len={}, id={}", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(cmd), len, id});
        }
        OutputStream dos = this.channel.getInvertedIn();
        BufferUtils.writeInt((OutputStream)dos, (int)(5 + len), (byte[])this.workBuf);
        dos.write(cmd & 0xFF);
        BufferUtils.writeInt((OutputStream)dos, (int)id, (byte[])this.workBuf);
        dos.write(buffer.array(), buffer.rpos(), len);
        dos.flush();
        return id;
    }

    @Override
    public Buffer receive(int id) throws IOException {
        Integer reqId = id;
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            int count = 1;
            while (true) {
                if (this.isClosing() || !this.isOpen()) {
                    throw new SshException("Channel is being closed");
                }
                Buffer buffer = this.messages.remove(reqId);
                if (buffer != null) {
                    return buffer;
                }
                try {
                    this.messages.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted while waiting for messages at iteration #" + count).initCause(e);
                }
                ++count;
            }
        }
    }

    protected Buffer read() throws IOException {
        int readLen;
        InputStream dis = this.channel.getInvertedOut();
        int length = BufferUtils.readInt((InputStream)dis, (byte[])this.workBuf);
        if (length < 5) {
            throw new IllegalArgumentException("Bad length: " + length);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(length + 4, false);
        buffer.putInt((long)length);
        for (int nb = length; nb > 0; nb -= readLen) {
            readLen = dis.read(buffer.array(), buffer.wpos(), nb);
            if (readLen < 0) {
                throw new IllegalArgumentException("Premature EOF while read " + length + " bytes - remaining=" + nb);
            }
            buffer.wpos(buffer.wpos() + readLen);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(long initializationTimeout) throws IOException {
        Buffer buffer;
        ValidateUtils.checkTrue((initializationTimeout > 0L ? 1 : 0) != 0, (String)"Invalid initialization timeout: %d", (long)initializationTimeout);
        OutputStream dos = this.channel.getInvertedIn();
        BufferUtils.writeInt((OutputStream)dos, (int)5, (byte[])this.workBuf);
        dos.write(1);
        BufferUtils.writeInt((OutputStream)dos, (int)6, (byte[])this.workBuf);
        dos.flush();
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            long remainingTimeout = initializationTimeout;
            while (remainingTimeout > 0L && this.messages.isEmpty() && !this.isClosing() && this.isOpen()) {
                try {
                    long sleepStart = System.nanoTime();
                    this.messages.wait(remainingTimeout);
                    long sleepEnd = System.nanoTime();
                    long sleepDuration = sleepEnd - sleepStart;
                    long sleepMillis = TimeUnit.NANOSECONDS.toMillis(sleepDuration);
                    if (sleepMillis < 1L) {
                        --remainingTimeout;
                        continue;
                    }
                    remainingTimeout -= sleepMillis;
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted init()").initCause(e);
                }
            }
            if (this.isClosing() || !this.isOpen()) {
                throw new EOFException("Closing while await init message");
            }
            if (this.messages.isEmpty()) {
                throw new SocketTimeoutException("No incoming initialization response received within " + initializationTimeout + " msec.");
            }
            Set<Integer> ids = this.messages.keySet();
            Iterator iter = ids.iterator();
            Integer reqId = (Integer)iter.next();
            buffer = this.messages.remove(reqId);
        }
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("init({}) id={} type={} len={}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(type), length});
        }
        if (type == 2) {
            if (id < 3) {
                throw new SshException("Unsupported sftp version " + id);
            }
            this.versionHolder.set(id);
            if (traceEnabled) {
                this.log.trace("init({}) version={}", (Object)this.getClientChannel(), (Object)this.versionHolder);
            }
            while (buffer.available() > 0) {
                String name = buffer.getString();
                byte[] data = buffer.getBytes();
                if (traceEnabled) {
                    this.log.trace("init({}) added extension=", (Object)this.getClientChannel(), (Object)name);
                }
                this.extensions.put(name, data);
            }
        } else if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (traceEnabled) {
                this.log.trace("init({})[id={}] - status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(1, id, substatus, msg, lang);
        } else {
            IOException err = this.handleUnexpectedPacket(1, 2, id, type, length, buffer);
            if (err != null) {
                throw err;
            }
        }
    }

    public int negotiateVersion(SftpVersionSelector selector) throws IOException {
        int current = this.getVersion();
        if (selector == null) {
            return current;
        }
        NavigableSet available = GenericUtils.asSortedSet(Collections.singleton(current));
        Map<String, Object> parsed = this.getParsedServerExtensions();
        Set<String> extensions = ParserUtils.supportedExtensions(parsed);
        if (GenericUtils.size(extensions) > 0 && extensions.contains("version-select")) {
            List<String> reported;
            VersionsParser.Versions vers = GenericUtils.isEmpty(parsed) ? null : (VersionsParser.Versions)parsed.get("versions");
            List<String> list = reported = vers == null ? null : vers.getVersions();
            if (GenericUtils.size(reported) > 0) {
                for (String v : reported) {
                    if (available.add(Integer.valueOf(v))) continue;
                }
            }
        }
        int selected = selector.selectVersion(this.getClientSession(), current, new ArrayList<Integer>(available));
        if (this.log.isDebugEnabled()) {
            this.log.debug("negotiateVersion({}) current={} {} -> {}", new Object[]{this.getClientChannel(), current, available, selected});
        }
        if (selected == current) {
            return current;
        }
        if (!available.contains(selected)) {
            throw new StreamCorruptedException("Selected version (" + selected + ") not part of available: " + available);
        }
        String verVal = String.valueOf(selected);
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + "version-select".length() + 4 + verVal.length() + 8, false);
        buffer.putString("version-select");
        buffer.putString(verVal);
        this.checkCommandStatus(200, (Buffer)buffer);
        this.versionHolder.set(selected);
        return selected;
    }
}

