/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model.ui;

import com.google.common.collect.Maps;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.controls.Separator;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionTemplate;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeConstantInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.ConstantSizeComposite;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.DefaultAlignmentDescription;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.UnitDescription;

abstract class DimensionEditDialog<T extends FormDimensionInfo>
extends ResizableDialog {
    private final FormLayoutInfo m_layout;
    private final List<T> m_dimensions;
    private T m_currentDimension;
    private T m_dimension;
    private final boolean m_horizontal;
    private final String m_dimensionName;
    private final DefaultAlignmentDescription[] m_alignments;
    private final UnitDescription[] m_units;
    private Text m_indexText;
    private Button m_prevButton;
    private Button m_nextButton;
    private Text m_specificationText;
    private Button[] m_alignmentButtons;
    private Combo m_templateCombo;
    private final Map<Size, Button> m_componentSizeToButton = Maps.newHashMap();
    private ConstantSizeComposite m_constantSizeComposite;
    private Button m_constantSizeButton;
    private Button m_lowerSizeButton;
    private ConstantSizeComposite m_lowerSizeComposite;
    private Button m_upperSizeButton;
    private ConstantSizeComposite m_upperSizeComposite;
    private Button m_noGrowButton;
    private Button m_growButton;
    private Spinner m_growSpinner;
    private static final int APPLY_ID = 1025;

    public DimensionEditDialog(Shell parentShell, FormLayoutInfo layout, List<T> dimensions, T dimension, String dimensionName, DefaultAlignmentDescription[] alignments, UnitDescription[] units) {
        super(parentShell, (AbstractUIPlugin)Activator.getDefault());
        this.setShellStyle(67680);
        this.m_layout = layout;
        this.m_dimensions = dimensions;
        this.setEditDimension(dimension);
        this.m_horizontal = dimension instanceof FormColumnInfo;
        this.m_dimensionName = dimensionName;
        this.m_alignments = alignments;
        this.m_units = units;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createHeaderComposite(container);
        this.createAlignmentComposite(container);
        this.createSizeComposite(container);
        this.createResizeComposite(container);
        this.showDimension();
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormat.format(ModelMessages.DimensionEditDialog_dialogTitle, this.m_dimensionName));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.m_layout != null) {
            this.createButton(parent, 1025, ModelMessages.DimensionEditDialog_applyButton, false);
        }
    }

    protected void buttonPressed(int buttonId) {
        try {
            if (buttonId == 0 || buttonId == 1025) {
                this.applyChanges();
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
        super.buttonPressed(buttonId);
    }

    private void applyChanges() throws Exception {
        ((FormDimensionInfo)this.m_currentDimension).assign((FormDimensionInfo)this.m_dimension);
        if (this.m_layout != null) {
            try {
                this.m_layout.startEdit();
                this.m_layout.writeDimensions();
            }
            finally {
                this.m_layout.endEdit();
            }
        }
    }

    private void setEditDimension(T dimension) {
        try {
            if (this.m_currentDimension != null && !((FormDimensionInfo)this.m_currentDimension).equals2(this.m_dimension)) {
                String title = ModelMessages.DimensionEditDialog_applyConfirmTitle;
                String message = MessageFormat.format(ModelMessages.DimensionEditDialog_applyConfirmMessage, this.m_dimensionName);
                MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                int dialogResult = dialog.open();
                if (dialogResult == 2) {
                    return;
                }
                if (dialogResult == 0) {
                    this.applyChanges();
                }
            }
            this.m_currentDimension = dimension;
            this.m_dimension = DimensionEditDialog.getCopy(dimension);
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    private static <T extends FormDimensionInfo> T getCopy(T dimension) throws Exception {
        return (T)dimension.copy();
    }

    private void createHeaderComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill();
        GridLayoutFactory.create((Composite)composite).noMargins().columns(4);
        new Label(composite, 0).setText(String.valueOf(this.m_dimensionName) + ":");
        this.m_indexText = new Text(composite, 2056);
        GridDataFactory.create((Control)this.m_indexText).grabH().fillH().indentHC(3);
        this.m_prevButton = new Button(composite, 0);
        this.m_prevButton.setToolTipText(MessageFormat.format(ModelMessages.DimensionEditDialog_previousButton, this.m_dimensionName));
        this.m_prevButton.setImage(this.m_horizontal ? Activator.getImage("navigation/left.gif") : Activator.getImage("navigation/up.gif"));
        this.m_prevButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = DimensionEditDialog.this.m_dimensions.indexOf(DimensionEditDialog.this.m_currentDimension);
                DimensionEditDialog.this.setEditDimension((FormDimensionInfo)DimensionEditDialog.this.m_dimensions.get(index - 1));
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_nextButton = new Button(composite, 0);
        this.m_nextButton.setToolTipText(MessageFormat.format(ModelMessages.DimensionEditDialog_nextButton, this.m_dimensionName));
        this.m_nextButton.setImage(this.m_horizontal ? Activator.getImage("navigation/right.gif") : Activator.getImage("navigation/down.gif"));
        this.m_nextButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = DimensionEditDialog.this.m_dimensions.indexOf(DimensionEditDialog.this.m_currentDimension);
                DimensionEditDialog.this.setEditDimension((FormDimensionInfo)DimensionEditDialog.this.m_dimensions.get(index + 1));
                DimensionEditDialog.this.showDimension();
            }
        });
        new Label(composite, 0).setText(ModelMessages.DimensionEditDialog_template);
        this.m_templateCombo = new Combo(composite, 8);
        GridDataFactory.create((Control)this.m_templateCombo).spanH(3).hintHC(40).grabH().fillH().indentHC(3);
        final FormDimensionTemplate[] templates = ((FormDimensionInfo)this.m_dimension).getTemplates();
        this.m_templateCombo.setVisibleItemCount(templates.length);
        int i = 0;
        while (i < templates.length) {
            FormDimensionTemplate template = templates[i];
            this.m_templateCombo.add(template.getTitle());
            ++i;
        }
        this.m_templateCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int index = DimensionEditDialog.this.m_templateCombo.getSelectionIndex();
                    FormDimensionTemplate template = templates[index];
                    DimensionEditDialog.this.m_dimension.setTemplate(template);
                    DimensionEditDialog.this.showDimension();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new Label(composite, 0).setText(ModelMessages.DimensionEditDialog_specification);
        this.m_specificationText = new Text(composite, 2056);
        GridDataFactory.create((Control)this.m_specificationText).spanH(3).grabH().fillH().indentHC(3);
    }

    private void createAlignmentComposite(Composite parent) {
        DimensionEditDialog.createSeparator(parent, ModelMessages.DimensionEditDialog_defaultAlignment);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill().indentHC(2);
        GridLayoutFactory.create((Composite)composite).noMargins().columns(this.m_alignments.length);
        this.m_alignmentButtons = new Button[this.m_alignments.length];
        int i = 0;
        while (i < this.m_alignments.length) {
            final DefaultAlignmentDescription description = this.m_alignments[i];
            Button button = new Button(composite, 16);
            button.setText(description.getTitle());
            this.m_alignmentButtons[i] = button;
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DimensionEditDialog.this.m_dimension.setAlignment(description.getAlignment());
                    DimensionEditDialog.this.showDimension();
                }
            });
            ++i;
        }
    }

    private void createSizeComposite(Composite parent) {
        DimensionEditDialog.createSeparator(parent, ModelMessages.DimensionEditDialog_size);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill().indentHC(2);
        GridLayoutFactory.create((Composite)composite).noMargins();
        Composite sizesComposite = new Composite(composite, 0);
        GridDataFactory.create((Control)sizesComposite).grabH().fill();
        GridLayoutFactory.create((Composite)sizesComposite).columns(3).noMargins();
        this.createComponentSizeButton(sizesComposite, (Size)Sizes.DEFAULT, "&default");
        this.createComponentSizeButton(sizesComposite, (Size)Sizes.PREFERRED, "&preferred");
        this.createComponentSizeButton(sizesComposite, (Size)Sizes.MINIMUM, "minim&um");
        Composite constantsComposite = new Composite(composite, 0);
        GridDataFactory.create((Control)constantsComposite).grabH().fill();
        GridLayoutFactory.create((Composite)constantsComposite).columns(2).noMargins();
        this.m_constantSizeButton = new Button(constantsComposite, 16);
        this.m_constantSizeButton.setText(ModelMessages.DimensionEditDialog_18);
        GridDataFactory.create((Control)this.m_constantSizeButton).hintHC(15);
        this.m_constantSizeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormSizeInfo size = DimensionEditDialog.this.m_dimension.getSize();
                size.setComponentSize(null);
                if (size.getConstantSize() == null) {
                    size.setConstantSize(new FormSizeConstantInfo(50.0, DimensionEditDialog.this.m_units[0].getUnit()));
                }
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_constantSizeComposite = new ConstantSizeComposite(constantsComposite, 0, this.m_units);
        this.m_constantSizeComposite.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormSizeInfo size = DimensionEditDialog.this.m_dimension.getSize();
                size.setConstantSize(DimensionEditDialog.this.m_constantSizeComposite.getConstantSize());
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_lowerSizeButton = new Button(constantsComposite, 32);
        this.m_lowerSizeButton.setText(ModelMessages.DimensionEditDialog_19);
        this.m_lowerSizeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormSizeInfo size = DimensionEditDialog.this.m_dimension.getSize();
                size.setLowerSize(DimensionEditDialog.this.m_lowerSizeButton.getSelection());
                if (size.getLowerSize() == null) {
                    size.setLowerSize(new FormSizeConstantInfo(50.0, DimensionEditDialog.this.m_units[0].getUnit()));
                }
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_lowerSizeComposite = new ConstantSizeComposite(constantsComposite, 0, this.m_units);
        this.m_lowerSizeComposite.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormSizeInfo size = DimensionEditDialog.this.m_dimension.getSize();
                size.setLowerSize(DimensionEditDialog.this.m_lowerSizeComposite.getConstantSize());
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_upperSizeButton = new Button(constantsComposite, 32);
        this.m_upperSizeButton.setText(ModelMessages.DimensionEditDialog_20);
        this.m_upperSizeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormSizeInfo size = DimensionEditDialog.this.m_dimension.getSize();
                size.setUpperSize(DimensionEditDialog.this.m_upperSizeButton.getSelection());
                if (size.getUpperSize() == null) {
                    size.setUpperSize(new FormSizeConstantInfo(50.0, DimensionEditDialog.this.m_units[0].getUnit()));
                }
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_upperSizeComposite = new ConstantSizeComposite(constantsComposite, 0, this.m_units);
        this.m_upperSizeComposite.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormSizeInfo size = DimensionEditDialog.this.m_dimension.getSize();
                size.setUpperSize(DimensionEditDialog.this.m_upperSizeComposite.getConstantSize());
                DimensionEditDialog.this.showDimension();
            }
        });
    }

    private void createComponentSizeButton(Composite parent, final Size componentSize, String text) {
        Button button = new Button(parent, 16);
        this.m_componentSizeToButton.put(componentSize, button);
        button.setText(text);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionEditDialog.this.m_dimension.getSize().setComponentSize(componentSize);
                DimensionEditDialog.this.showDimension();
            }
        });
    }

    private void createResizeComposite(Composite parent) {
        DimensionEditDialog.createSeparator(parent, ModelMessages.DimensionEditDialog_resizeBehavior);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill().indentHC(2);
        GridLayoutFactory.create((Composite)composite).noMargins().columns(2);
        this.m_noGrowButton = new Button(composite, 16);
        GridDataFactory.create((Control)this.m_noGrowButton).spanH(2);
        this.m_noGrowButton.setText("&none");
        this.m_noGrowButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionEditDialog.this.m_dimension.setWeight(0.0);
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_growButton = new Button(composite, 16);
        GridDataFactory.create((Control)this.m_growButton).hintHC(15);
        this.m_growButton.setText("&grow");
        this.m_growButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionEditDialog.this.m_dimension.setWeight(1.0);
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_growSpinner = new Spinner(composite, 2048);
        GridDataFactory.create((Control)this.m_growSpinner).hintHC(10);
        this.m_growSpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionEditDialog.this.m_dimension.setWeight(DimensionEditDialog.this.m_growSpinner.getSelection());
                DimensionEditDialog.this.showDimension();
            }
        });
    }

    private void showDimension() {
        int index = 1 + this.m_dimensions.indexOf(this.m_currentDimension);
        this.m_indexText.setText("" + index);
        this.m_prevButton.setEnabled(index != 1);
        this.m_nextButton.setEnabled(index < this.m_dimensions.size());
        FormDimensionTemplate[] templates = ((FormDimensionInfo)this.m_dimension).getTemplates();
        this.m_templateCombo.deselectAll();
        int i = 0;
        while (i < templates.length) {
            FormDimensionTemplate template = templates[i];
            if (((FormDimensionInfo)this.m_dimension).isTemplate(template)) {
                this.m_templateCombo.select(i);
                break;
            }
            ++i;
        }
        this.m_specificationText.setText(((FormDimensionInfo)this.m_dimension).getDisplayString());
        int i2 = 0;
        while (i2 < this.m_alignments.length) {
            DefaultAlignmentDescription description = this.m_alignments[i2];
            Button button = this.m_alignmentButtons[i2];
            button.setSelection(((FormDimensionInfo)this.m_dimension).getAlignment() == description.getAlignment());
            ++i2;
        }
        FormSizeInfo size = ((FormDimensionInfo)this.m_dimension).getSize();
        boolean hasConstantSize = size.getComponentSize() == null;
        for (Map.Entry<Size, Button> entry : this.m_componentSizeToButton.entrySet()) {
            Size componentSize = entry.getKey();
            Button button = entry.getValue();
            button.setSelection(componentSize == size.getComponentSize());
        }
        UiUtils.changeControlEnable((Control)this.m_constantSizeComposite, (boolean)hasConstantSize);
        this.m_constantSizeButton.setSelection(hasConstantSize);
        this.m_constantSizeComposite.setConstantSize(size.getConstantSize());
        this.m_lowerSizeButton.setEnabled(!hasConstantSize);
        this.m_lowerSizeButton.setSelection(size.hasLowerSize());
        UiUtils.changeControlEnable((Control)this.m_lowerSizeComposite, (boolean)size.hasLowerSize());
        this.m_lowerSizeComposite.setConstantSize(size.getLowerSize());
        this.m_upperSizeButton.setEnabled(!hasConstantSize);
        this.m_upperSizeButton.setSelection(size.hasUpperSize());
        UiUtils.changeControlEnable((Control)this.m_upperSizeComposite, (boolean)size.hasUpperSize());
        this.m_upperSizeComposite.setConstantSize(size.getUpperSize());
        if (((FormDimensionInfo)this.m_dimension).hasGrow()) {
            this.m_noGrowButton.setSelection(false);
            this.m_growButton.setSelection(true);
            this.m_growSpinner.setEnabled(true);
            int weight = Math.max((int)((FormDimensionInfo)this.m_dimension).getWeight(), 1);
            if (this.m_growSpinner.getSelection() != weight) {
                this.m_growSpinner.setSelection(weight);
            }
        } else {
            this.m_noGrowButton.setSelection(true);
            this.m_growButton.setSelection(false);
            this.m_growSpinner.setEnabled(false);
            this.m_growSpinner.setSelection(0);
        }
    }

    private static void createSeparator(Composite parent, String text) {
        Separator separator = new Separator(parent, 0);
        GridDataFactory.create((Control)separator).grabH().fillH();
        separator.setText(text);
        separator.setForeground(separator.getDisplay().getSystemColor(26));
    }
}

