/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences.code;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;

public final class GenerationDescriptionEditor
implements IDataEditor {
    private final TabFolder m_tabFolder;
    private static final Image TAB_IMAGE_SELECTION_FALSE = DesignerPlugin.getImage((String)"preferences/tab_selection_false.gif");
    private static final Image TAB_IMAGE_SELECTION_TRUE = DesignerPlugin.getImage((String)"preferences/tab_selection_true.gif");

    public GenerationDescriptionEditor(TabFolder tabFolder) {
        this.m_tabFolder = tabFolder;
        this.trackTabFolderSelection();
    }

    public void setValue(Object value) {
        TabItem[] tabItemArray = this.m_tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = tabItemArray[n2];
            if (tabItem.getData() == value) {
                this.m_tabFolder.setSelection(tabItem);
                this.updateTabFolderSelection();
            }
            ++n2;
        }
    }

    public Object getValue() {
        return this.m_tabFolder.getSelection()[0].getData();
    }

    private void trackTabFolderSelection() {
        this.updateTabFolderSelection();
        this.m_tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GenerationDescriptionEditor.this.updateTabFolderSelection();
            }
        });
    }

    private void updateTabFolderSelection() {
        Object[] selectedItems = this.m_tabFolder.getSelection();
        TabItem[] tabItemArray = this.m_tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem;
            tabItem.setImage(ArrayUtils.contains((Object[])selectedItems, (Object)(tabItem = tabItemArray[n2])) ? TAB_IMAGE_SELECTION_TRUE : TAB_IMAGE_SELECTION_FALSE);
            ++n2;
        }
    }
}

