/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.services;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistableURIProvider;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.AbstractService;

public class URIPersistenceService
extends AbstractService
implements IURIPersistenceService {
    @Override
    public void write(Object context, URI uri) throws IOException {
        Assert.isNotNull((Object)context);
        uri = uri != null ? uri : this.getURI(context);
        IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(context, uri);
        if (delegate == null) {
            throw new IOException("The persistence delegate for context '" + context.getClass().getName() + "' cannot be determined.");
        }
        delegate.write(context, uri);
    }

    @Override
    public Object read(Object context, URI uri) throws IOException {
        Assert.isNotNull((Object)context);
        uri = uri != null ? uri : this.getURI(context);
        IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(context, uri);
        if (delegate == null) {
            throw new IOException("The persistence delegate for context '" + context.getClass().getName() + "' cannot be determined.");
        }
        return delegate.read(context, uri);
    }

    @Override
    public boolean delete(Object context, URI uri) throws IOException {
        Assert.isNotNull((Object)context);
        uri = uri != null ? uri : this.getURI(context);
        IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(context, uri);
        if (delegate == null) {
            throw new IOException("The persistence delegate for context '" + context.getClass().getName() + "' cannot be determined.");
        }
        return delegate.delete(context, uri);
    }

    @Override
    public URI getURI(Object context) throws IOException {
        IPersistableURIProvider persistableURIProvider;
        Assert.isNotNull((Object)context);
        IPersistableURIProvider iPersistableURIProvider = persistableURIProvider = context instanceof IPersistableURIProvider ? (IPersistableURIProvider)context : null;
        if (persistableURIProvider == null) {
            IPersistableURIProvider iPersistableURIProvider2 = persistableURIProvider = context instanceof IAdaptable ? (IPersistableURIProvider)((IAdaptable)context).getAdapter(IPersistableURIProvider.class) : null;
        }
        if (persistableURIProvider == null) {
            persistableURIProvider = (IPersistableURIProvider)Platform.getAdapterManager().getAdapter(context, IPersistableURIProvider.class);
        }
        if (persistableURIProvider == null) {
            throw new IOException("'context' must be adaptable to IPersistableURIProvider.");
        }
        URI uri = persistableURIProvider.getURI(context);
        if (uri == null) {
            throw new IOException("The URI cannot be determined for context '" + context.getClass().getName() + "'.");
        }
        return uri;
    }
}

