/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasField;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.ElementsStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ConstantsStrategy
extends ElementsStrategy {
    public ConstantsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ConstantsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        String nsUseGroupPrefix = null;
        boolean isUseConstStatement = false;
        if (context instanceof UseStatementContext) {
            nsUseGroupPrefix = ((UseStatementContext)context).getGroupPrefixBeforeOpeningCurly();
            isUseConstStatement = ((UseStatementContext)context).isUseConstStatement();
        }
        String prefix = abstractContext.getPrefix();
        if (!isUseConstStatement && StringUtils.isBlank((CharSequence)prefix) || prefix.startsWith("$")) {
            return;
        }
        ISearchEngine.MatchRule matchRule = ISearchEngine.MatchRule.PREFIX;
        if (requestor.isContextInformationMode()) {
            matchRule = ISearchEngine.MatchRule.EXACT;
        }
        ISourceModule sourceModule = abstractContext.getSourceModule();
        IType enclosingType = null;
        try {
            IModelElement enclosingElement = sourceModule.getElementAt(abstractContext.getOffset());
            if (enclosingElement != null && enclosingElement instanceof IType) {
                enclosingType = (IType)enclosingElement;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        IDLTKSearchScope scope = null;
        IField[] enclosingTypeConstants = null;
        scope = enclosingType != null && nsUseGroupPrefix != null && this.isStartOfStatement(prefix, abstractContext, abstractContext.getOffset()) ? SearchEngine.createSearchScope((IModelElement)enclosingType) : this.getSearchScope(abstractContext);
        String memberName = abstractContext.getMemberName();
        String namespaceName = abstractContext.getQualifier(true);
        int extraInfo = this.getExtraInfo();
        if (abstractContext.isAbsoluteName()) {
            extraInfo |= 8;
            extraInfo |= 0x200;
            extraInfo |= 0x400;
        }
        if (abstractContext.isAbsolute()) {
            extraInfo |= 8;
            extraInfo |= 0x200;
        }
        if (nsUseGroupPrefix != null) {
            extraInfo |= 0x40;
            extraInfo |= 0x200;
        }
        enclosingTypeConstants = PHPModelAccess.getDefault().findFileFields(namespaceName, memberName, matchRule, 2, 0, scope, null);
        if (this.isCaseSensitive()) {
            enclosingTypeConstants = this.filterByCase((IModelElement[])enclosingTypeConstants, prefix);
        }
        enclosingTypeConstants = this.filterClassConstants((IModelElement[])enclosingTypeConstants);
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        ISourceRange memberReplacementRange = this.getReplacementRangeForMember(abstractContext);
        boolean isAbsoluteField = abstractContext.isAbsoluteName() || abstractContext.isAbsolute();
        String namespace = abstractContext.getCurrentNamespace();
        IField[] iFieldArray = enclosingTypeConstants;
        int n = enclosingTypeConstants.length;
        int n2 = 0;
        while (n2 < n) {
            IField constant;
            IField field = constant = iFieldArray[n2];
            if (nsUseGroupPrefix != null) {
                reporter.reportField(field, nsUseGroupPrefix, "", memberReplacementRange, this.getRelevance(namespace, (IMember)constant), (Object)extraInfo);
            } else {
                reporter.reportField(field, "", isAbsoluteField ? replacementRange : memberReplacementRange, false, this.getRelevance(namespace, (IMember)constant), (Object)(isAbsoluteField ? extraInfo | 0x80 : extraInfo));
            }
            ++n2;
        }
        this.addAlias(reporter);
    }

    protected void addAlias(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (abstractContext.getCompletionRequestor().isContextInformationMode()) {
            return;
        }
        String prefix = abstractContext.getPrefix();
        if (prefix.indexOf(92) != -1) {
            return;
        }
        IModuleSource module = reporter.getModule();
        ISourceModule sourceModule = (ISourceModule)module.getModelElement();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        int offset = abstractContext.getOffset();
        IType namespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
        Map<String, UsePart> result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, namespace, false);
        this.reportAlias(reporter, abstractContext, module, result);
    }

    protected void reportAlias(ICompletionReporter reporter, AbstractCompletionContext abstractContext, IModuleSource module, Map<String, UsePart> result) throws BadLocationException {
        ISourceRange replacementRange = this.getReplacementRangeForMember(abstractContext);
        IDLTKSearchScope scope = this.createSearchScope();
        for (Map.Entry<String, UsePart> entry : result.entrySet()) {
            String elementName;
            String name = entry.getKey();
            String fullName = entry.getValue().getFullUseStatementName();
            IField[] elements = PHPModelAccess.getDefault().findFields(null, fullName, ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
            int i = 0;
            while (i < elements.length) {
                elementName = elements[i].getElementName();
                this.reportAlias(reporter, scope, module, replacementRange, (IMember)elements[i], elementName, elementName.replace(fullName, name));
                ++i;
            }
            elements = PHPModelAccess.getDefault().findFields(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            i = 0;
            while (i < elements.length) {
                elementName = elements[i].getElementName();
                this.reportAlias(reporter, scope, module, replacementRange, (IMember)elements[i], elementName, name);
                ++i;
            }
        }
    }

    protected void reportAlias(ICompletionReporter reporter, IDLTKSearchScope scope, IModuleSource module, ISourceRange replacementRange, IMember member, String fullName, String alias) {
        reporter.reportField((IField)new AliasField((ModelElement)member, fullName, alias), "", replacementRange, false, 0, (Object)this.getExtraInfo());
    }

    private boolean isStartOfStatement(String prefix, AbstractCompletionContext abstractContext, int offset) {
        IStructuredDocument doc = abstractContext.getDocument();
        try {
            int pos = offset - prefix.length() - 1;
            char previousChar = doc.getChar(pos);
            while (Character.isWhitespace(previousChar)) {
                previousChar = doc.getChar(--pos);
            }
            return previousChar == '{' || previousChar == ';';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private IModelElement[] filterClassConstants(IModelElement[] elements) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>(elements.length);
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            try {
                if ((((IField)element).getFlags() & 0x400) == 0) {
                    result.add(element);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    protected int getExtraInfo() {
        return 1;
    }

    private IDLTKSearchScope getSearchScope(AbstractCompletionContext abstractContext) {
        IDLTKSearchScope scope = this.createSearchScope();
        return scope;
    }
}

