/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.ParameterLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;

public class ParameterLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        Parameter parameter = this.getUMLElement();
        if (parameter == null) {
            return;
        }
        if (parameter.getType() != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
        }
    }

    public Collection<String> getDefaultDisplayValue() {
        return ICustomAppearance.DEFAULT_UML_PARAMETER;
    }

    public Map<String, String> getMasks() {
        return ParameterLabelHelper.getInstance().getMasks();
    }

    public Parameter getUMLElement() {
        return (Parameter)super.getUMLElement();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        Parameter parameter = (Parameter)this.hostSemanticElement;
        if (object == null || this.hostSemanticElement == null) {
            return;
        }
        if (object.equals(parameter)) {
            this.notifyParameterChanged(parameter, notification);
        } else if (object.equals(parameter.getType())) {
            this.notifyParameterTypeChanged(parameter.getType(), notification);
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    protected void notifyParameterChanged(Parameter parameter, Notification notification) {
        switch (notification.getFeatureID(Parameter.class)) {
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.refreshDisplay();
                break;
            }
            case 10: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    protected void notifyParameterTypeChanged(Type type, Notification notification) {
        switch (notification.getFeatureID(Parameter.class)) {
            case 5: {
                this.refreshDisplay();
                break;
            }
        }
    }

    public void refreshDisplay() {
        ParameterLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)this.getHost());
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Parameter parameter = this.getUMLElement();
        if (parameter == null) {
            return;
        }
        if (parameter.getType() != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
        }
    }
}

