/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.ui.CAbstractMainTab;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.linuxtools.internal.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.ProxyLaunchMessages;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.profiling.launch.ui.ResourceSelectorWidget;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class RemoteProxyCMainTab
extends CAbstractMainTab {
    public static final String TAB_ID = "org.eclipse.linuxtools.profiling.launch.RemoteProxyCMainTab";
    private final boolean fWantsTerminalOption;
    protected Button fTerminalButton;
    protected ResourceSelectorWidget exeSelector;
    protected Text copyFromExeText;
    protected Button enableCopyFromExeButton;
    protected ResourceSelectorWidget copyFromExeSelector;
    protected Label toLabel;
    protected String fPreviouslyCheckedCopyFromExe;
    protected boolean fPreviouslyCheckedCopyFromExeIsValid;
    protected String fPreviouslyCheckedCopyFromExeErrorMsg;
    protected Text workingDirText;
    protected String fPreviouslyCheckedWorkingDir;
    protected boolean fPreviouslyCheckedWorkingDirIsValid;
    protected String fPreviouslyCheckedWorkingDirErrorMsg;
    private final boolean dontCheckProgram;
    private final boolean fSpecifyCoreFile;
    public static final int WANTS_TERMINAL = 1;
    public static final int DONT_CHECK_PROGRAM = 2;
    public static final int SPECIFY_CORE_FILE = 4;
    public static final String ATTR_REMOTE_WORKING_DIRECTORY_NAME = "REMOTE_WORKING_DIRECTORY_NAME";
    public static final String ATTR_COPY_FROM_EXE_NAME = "COPY_FROM_EXE_NAME";
    public static final String ATTR_ENABLE_COPY_FROM_EXE = "ENABLE_COPY_FROM_EXE";

    public RemoteProxyCMainTab() {
        this(1);
    }

    public RemoteProxyCMainTab(boolean terminalOption) {
        this(terminalOption ? 1 : 0);
    }

    public RemoteProxyCMainTab(int flags) {
        this.fWantsTerminalOption = (flags & 1) != 0;
        this.dontCheckProgram = (flags & 2) != 0;
        this.fSpecifyCoreFile = (flags & 4) != 0;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        ProfileLaunchPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.launch.launch_configuration_dialog_main_tab");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createCopyFromExeGroup(comp, 1);
        this.createExeFileGroup(comp, 1);
        this.createWorkingDirGroup(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createBuildOptionGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
        if (this.fSpecifyCoreFile) {
            this.createCoreFileGroup(comp, 1);
        }
        if (this.wantsTerminalOption()) {
            this.createTerminalOption(comp, 1);
        }
    }

    protected boolean wantsTerminalOption() {
        return this.fWantsTerminalOption;
    }

    protected void createTerminalOption(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 1;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        this.fTerminalButton = this.createCheckButton(mainComp, LaunchMessages.CMainTab_UseTerminal);
        this.fTerminalButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.fTerminalButton.setEnabled(PTY.isSupported());
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.filterPlatform = this.getPlatform(config);
        this.updateProjectFromConfig(config);
        this.updateCopyFromExeFromConfig(config);
        this.updateProgramFromConfig(config);
        this.updateWorkingDirFromConfig(config);
        this.updateCoreFromConfig(config);
        this.updateBuildOptionFromConfig(config);
        this.updateTerminalFromConfig(config);
    }

    protected void updateTerminalFromConfig(ILaunchConfiguration config) {
        if (this.fTerminalButton != null) {
            boolean useTerminal = true;
            try {
                useTerminal = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            }
            catch (CoreException e) {
                ProfileLaunchPlugin.log(e);
            }
            this.fTerminalButton.setSelection(useTerminal);
        }
    }

    protected void updateCoreFromConfig(ILaunchConfiguration config) {
        if (this.fCoreText != null) {
            String coreName = "";
            try {
                coreName = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
            }
            catch (CoreException ce) {
                ProfileLaunchPlugin.log(ce);
            }
            this.fCoreText.setText(coreName);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        ICProject cProject = this.getCProject();
        if (cProject != null && cProject.exists()) {
            config.setMappedResources(new IResource[]{cProject.getProject()});
        } else {
            config.setMappedResources(null);
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        if (this.enableCopyFromExeButton != null) {
            config.setAttribute(ATTR_ENABLE_COPY_FROM_EXE, this.enableCopyFromExeButton.getSelection());
        }
        if (this.copyFromExeText != null) {
            config.setAttribute(ATTR_COPY_FROM_EXE_NAME, this.copyFromExeText.getText());
        }
        if (this.fProgText != null) {
            config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fProgText.getText());
        }
        if (this.workingDirText != null) {
            config.setAttribute(ATTR_REMOTE_WORKING_DIRECTORY_NAME, this.workingDirText.getText());
        }
        if (this.fCoreText != null) {
            config.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", this.fCoreText.getText());
        }
        if (this.fTerminalButton != null) {
            config.setAttribute("org.eclipse.cdt.launch.use_terminal", this.fTerminalButton.getSelection());
        }
    }

    protected void handleSearchButtonSelected() {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.CMainTab_Project_required, (String)LaunchMessages.CMainTab_Enter_project_before_searching_for_program);
            return;
        }
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuilder name = new StringBuilder();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                IBinary belement;
                if (!(element instanceof ICElement)) {
                    return super.getImage(element);
                }
                ICElement celement = (ICElement)element;
                if (celement.getElementType() == 14 && (belement = (IBinary)celement).isExecutable()) {
                    return DebugUITools.getImage((String)"IMG_ACT_RUN");
                }
                return super.getImage(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuilder name = new StringBuilder();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements((Object[])this.getBinaryFiles(this.getCProject()));
        dialog.setMessage(LaunchMessages.CMainTab_Choose_program_to_run);
        dialog.setTitle(LaunchMessages.CMainTab_Program_Selection);
        dialog.setUpperListLabel(LaunchMessages.Launch_common_BinariesColon);
        dialog.setLowerListLabel(LaunchMessages.Launch_common_QualifierColon);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            IBinary binary = (IBinary)dialog.getFirstResult();
            this.fProgText.setText(binary.getResource().getProjectRelativePath().toString());
        }
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LaunchMessages.CMainTab_ProjectColon);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(evt -> {
            this.fPreviouslyCheckedProgram = null;
            this.updateBuildConfigCombo("");
            this.updateLaunchConfigurationDialog();
        });
        this.fProjButton = this.createPushButton(projComp, LaunchMessages.Launch_common_Browse_1, null);
        this.fProjButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.handleProjectButtonSelected();
            this.updateLaunchConfigurationDialog();
        }));
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        super.updateProgramFromConfig(config);
        if (this.fProgText.getText().equals("")) {
            IProject project;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (this.fProjText != null && (project = root.getProject(this.fProjText.getText())) != null) {
                this.fProgText.setText(project.getLocationURI().toString());
            }
        }
    }

    protected void updateCopyFromExeFromConfig(ILaunchConfiguration config) {
        if (this.copyFromExeText != null) {
            String workingDir = "";
            try {
                workingDir = config.getAttribute(ATTR_COPY_FROM_EXE_NAME, "");
            }
            catch (CoreException ce) {
                ProfileLaunchPlugin.log(ce);
            }
            this.copyFromExeText.setText(workingDir);
        }
        if (this.enableCopyFromExeButton != null) {
            boolean enableCopyFromExe = false;
            try {
                enableCopyFromExe = config.getAttribute(ATTR_ENABLE_COPY_FROM_EXE, false);
            }
            catch (CoreException ce) {
                ProfileLaunchPlugin.log(ce);
            }
            this.setEnableCopyFromSection(enableCopyFromExe);
        }
    }

    private void setEnableCopyFromSection(boolean enable) {
        this.enableCopyFromExeButton.setSelection(enable);
        this.copyFromExeSelector.setEnabled(enable);
        this.toLabel.setEnabled(enable);
    }

    protected void createCopyFromExeGroup(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 1;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        this.enableCopyFromExeButton = this.createCheckButton(mainComp, ProxyLaunchMessages.copy_cpp_executable);
        this.copyFromExeSelector = new ResourceSelectorWidget(mainComp, ResourceSelectorWidget.ResourceType.FILE, 2, ProxyLaunchMessages.executable_origin, null);
        this.toLabel = new Label(mainComp, 0);
        this.toLabel.setText(ProxyLaunchMessages.to);
        this.copyFromExeSelector.setEnabled(false);
        this.enableCopyFromExeButton.setSelection(false);
        this.toLabel.setEnabled(false);
        this.enableCopyFromExeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean copyEnabled = this.enableCopyFromExeButton.getSelection();
            this.setEnableCopyFromSection(copyEnabled);
            this.updateLaunchConfigurationDialog();
        }));
        this.copyFromExeText = this.copyFromExeSelector.getURIText();
        this.copyFromExeText.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
    }

    protected void createExeFileGroup(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 1;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        this.exeSelector = new ResourceSelectorWidget(mainComp, ResourceSelectorWidget.ResourceType.FILE, 2, "C/C++ executable", null);
        this.fProgText = this.exeSelector.getURIText();
        this.fProgText.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
    }

    protected void updateWorkingDirFromConfig(ILaunchConfiguration config) {
        if (this.workingDirText != null) {
            String projectDir = "";
            try {
                projectDir = config.getAttribute(ATTR_REMOTE_WORKING_DIRECTORY_NAME, "");
            }
            catch (CoreException ce) {
                ProfileLaunchPlugin.log(ce);
            }
            if (projectDir.equals("") && this.fProjText != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = root.getProject(this.fProjText.getText());
                try {
                    projectDir = RemoteProxyManager.getInstance().getRemoteProjectLocation(project);
                }
                catch (CoreException e) {
                    this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.error_accessing_working_directory;
                    this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                }
            }
            this.workingDirText.setText(projectDir);
        }
    }

    protected void createWorkingDirGroup(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 1;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        ResourceSelectorWidget workingDirSelector = new ResourceSelectorWidget(mainComp, ResourceSelectorWidget.ResourceType.DIRECTORY, 2, "Working directory", null);
        this.workingDirText = workingDirSelector.getURIText();
        this.workingDirText.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
    }

    private boolean checkCopyFromExe(IProject project) {
        boolean passed;
        URI exeURI;
        block23: {
            if (!this.enableCopyFromExeButton.getSelection()) {
                this.setErrorMessage(null);
                return true;
            }
            String name = this.copyFromExeText.getText().trim();
            if (name.length() == 0) {
                this.setErrorMessage(ProxyLaunchMessages.copy_from_exe_is_not_specified);
                return false;
            }
            if (name.equals(this.fPreviouslyCheckedCopyFromExe)) {
                if (this.fPreviouslyCheckedCopyFromExeErrorMsg != null) {
                    this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
                }
                return this.fPreviouslyCheckedCopyFromExeIsValid;
            }
            this.fPreviouslyCheckedCopyFromExe = name;
            this.fPreviouslyCheckedCopyFromExeIsValid = true;
            this.fPreviouslyCheckedCopyFromExeErrorMsg = null;
            exeURI = null;
            passed = false;
            try {
                exeURI = new URI(name);
                String exePathStr = exeURI.getPath();
                if (exePathStr != null) break block23;
                this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.uri_of_copy_from_exe_is_invalid;
                this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
                this.fPreviouslyCheckedCopyFromExeIsValid = false;
                return false;
            }
            catch (URISyntaxException e) {
                this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.uri_of_copy_from_exe_is_invalid;
                this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
                this.fPreviouslyCheckedCopyFromExeIsValid = false;
                return false;
            }
        }
        IPath exePath = Path.fromOSString((String)exeURI.getPath());
        if (!exePath.isAbsolute() && exeURI != null && !exeURI.isAbsolute()) {
            URI projectURI = project.getLocationURI();
            exeURI = new URI(projectURI.getScheme(), projectURI.getAuthority(), String.valueOf(projectURI.getRawPath()) + '/' + exePath.toString(), "");
        }
        if (exeURI != null) {
            passed = true;
        }
        if (!passed) {
            this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.copy_from_exe_does_not_exist;
            this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
            this.fPreviouslyCheckedCopyFromExeIsValid = false;
            return false;
        }
        passed = false;
        try {
            IRemoteFileProxy exeFileProxy = RemoteProxyManager.getInstance().getFileProxy(exeURI);
            if (exeFileProxy != null) {
                String exeFilePath = exeURI.getPath();
                IFileStore exeFS = exeFileProxy.getResource(exeFilePath);
                if (exeFS != null) {
                    IFileInfo exeFI = exeFS.fetchInfo();
                    if (exeFI != null) {
                        if (exeFI.exists()) {
                            if (exeFI.getAttribute(4) && !exeFI.isDirectory()) {
                                passed = true;
                            } else {
                                this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.copy_from_exe_does_not_have_execution_rights;
                                this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
                            }
                        } else {
                            this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.copy_from_exe_does_not_exist;
                            this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
                        }
                    } else {
                        this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.error_accessing_copy_from_exe;
                        this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
                    }
                } else {
                    this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.error_accessing_copy_from_exe;
                    this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
                }
            } else {
                this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.scheme_error_in_copy_from_exe;
                this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
            }
        }
        catch (CoreException e) {
            this.fPreviouslyCheckedCopyFromExeErrorMsg = ProxyLaunchMessages.connection_of_copy_from_exe_cannot_be_opened;
            this.setErrorMessage(this.fPreviouslyCheckedCopyFromExeErrorMsg);
        }
        if (!passed) {
            this.fPreviouslyCheckedCopyFromExeIsValid = false;
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean checkProgram(IProject project) {
        boolean passed;
        URI exeURI;
        block24: {
            String name = this.fProgText.getText().trim();
            if (name.length() == 0) {
                this.setErrorMessage(ProxyLaunchMessages.executable_is_not_specified);
                return false;
            }
            if (name.equals(this.fPreviouslyCheckedProgram)) {
                if (this.fPreviouslyCheckedProgramErrorMsg != null) {
                    this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
                }
                return this.fPreviouslyCheckedProgramIsValid;
            }
            this.fPreviouslyCheckedProgram = name;
            this.fPreviouslyCheckedProgramIsValid = true;
            this.fPreviouslyCheckedProgramErrorMsg = null;
            exeURI = null;
            passed = false;
            try {
                exeURI = new URI(name);
                String exePathStr = exeURI.getPath();
                if (exePathStr != null) break block24;
                this.fPreviouslyCheckedProgramErrorMsg = ProxyLaunchMessages.uri_of_executable_is_invalid;
                this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
                this.fPreviouslyCheckedProgramIsValid = false;
                return false;
            }
            catch (URISyntaxException e) {
                this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.uri_of_executable_is_invalid;
                this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                this.fPreviouslyCheckedProgramIsValid = false;
                return false;
            }
        }
        IPath exePath = Path.fromOSString((String)exeURI.getPath());
        if (!exePath.isAbsolute() && exeURI != null && !exeURI.isAbsolute()) {
            URI projectURI = project.getLocationURI();
            exeURI = new URI(projectURI.getScheme(), projectURI.getAuthority(), String.valueOf(projectURI.getRawPath()) + '/' + exePath.toString(), "");
        }
        if (exeURI != null) {
            passed = true;
        }
        if (!passed) {
            this.fPreviouslyCheckedProgramErrorMsg = LaunchMessages.CMainTab_Program_does_not_exist;
            this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
            this.fPreviouslyCheckedProgramIsValid = false;
            return false;
        }
        passed = false;
        try {
            IRemoteFileProxy exeFileProxy = RemoteProxyManager.getInstance().getFileProxy(exeURI);
            if (exeFileProxy != null) {
                String exeFilePath = exeURI.getPath();
                IFileStore exeFS = exeFileProxy.getResource(exeFilePath);
                if (exeFS != null) {
                    IFileInfo exeFI = exeFS.fetchInfo();
                    if (exeFI != null) {
                        if (this.dontCheckProgram || this.enableCopyFromExeButton.getSelection()) {
                            passed = true;
                        } else if (exeFI.exists()) {
                            if (exeFI.getAttribute(4) && !exeFI.isDirectory()) {
                                passed = true;
                            } else {
                                this.fPreviouslyCheckedProgramErrorMsg = ProxyLaunchMessages.executable_does_not_have_execution_rights;
                                this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
                            }
                        } else {
                            this.fPreviouslyCheckedProgramErrorMsg = ProxyLaunchMessages.executable_does_not_exist;
                            this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
                        }
                    } else {
                        this.fPreviouslyCheckedProgramErrorMsg = ProxyLaunchMessages.error_accessing_executable;
                        this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
                    }
                } else {
                    this.fPreviouslyCheckedProgramErrorMsg = ProxyLaunchMessages.error_accessing_executable;
                    this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
                }
            } else {
                this.fPreviouslyCheckedProgramErrorMsg = ProxyLaunchMessages.scheme_error_in_executable;
                this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
            }
        }
        catch (CoreException e) {
            this.fPreviouslyCheckedProgramErrorMsg = ProxyLaunchMessages.connection_of_executable_cannot_be_opened;
            this.setErrorMessage(this.fPreviouslyCheckedProgramErrorMsg);
        }
        if (!passed) {
            this.fPreviouslyCheckedProgramIsValid = false;
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean checkWorkingDir(IProject project) {
        boolean passed;
        URI wdURI;
        block22: {
            String name = this.workingDirText.getText().trim();
            if (name.length() == 0) {
                return true;
            }
            if (name.equals(this.fPreviouslyCheckedWorkingDir)) {
                if (this.fPreviouslyCheckedWorkingDirErrorMsg != null) {
                    this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                }
                return this.fPreviouslyCheckedWorkingDirIsValid;
            }
            this.fPreviouslyCheckedWorkingDir = name;
            this.fPreviouslyCheckedWorkingDirIsValid = true;
            this.fPreviouslyCheckedWorkingDirErrorMsg = null;
            wdURI = null;
            passed = false;
            try {
                wdURI = new URI(name);
                String wdPathStr = wdURI.getPath();
                if (wdPathStr != null) break block22;
                this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.uri_of_working_directory_is_invalid;
                this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                this.fPreviouslyCheckedWorkingDirIsValid = false;
                return false;
            }
            catch (URISyntaxException e) {
                this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.uri_of_working_directory_is_invalid;
                this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                this.fPreviouslyCheckedWorkingDirIsValid = false;
                return false;
            }
        }
        IPath wdPath = Path.fromOSString((String)wdURI.getPath());
        if (!wdPath.isAbsolute() && wdURI != null && !wdURI.isAbsolute()) {
            URI projectURI = project.getLocationURI();
            wdURI = new URI(projectURI.getScheme(), projectURI.getAuthority(), String.valueOf(projectURI.getRawPath()) + '/' + wdPath.toString(), "");
        }
        if (wdURI != null) {
            passed = true;
        }
        if (!passed) {
            this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.working_directory_does_not_exist;
            this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
            this.fPreviouslyCheckedWorkingDirIsValid = false;
            return false;
        }
        passed = false;
        try {
            IRemoteFileProxy wdFileProxy = RemoteProxyManager.getInstance().getFileProxy(wdURI);
            if (wdFileProxy != null) {
                IFileStore wdFS = wdFileProxy.getResource(wdURI.getPath());
                if (wdFS != null) {
                    IFileInfo wdFI = wdFS.fetchInfo();
                    if (wdFI != null) {
                        if (wdFI.exists()) {
                            if (wdFI.isDirectory()) {
                                passed = true;
                            } else {
                                this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.working_directory_is_not_a_directory;
                                this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                            }
                        } else {
                            this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.working_directory_does_not_exist;
                            this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                        }
                    } else {
                        this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.error_accessing_working_directory;
                        this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                    }
                } else {
                    this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.error_accessing_working_directory;
                    this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
                }
            } else {
                this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.scheme_error_in_working_directory;
                this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
            }
        }
        catch (CoreException e) {
            this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.connection_of_working_directory_cannot_be_opened;
            this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
        }
        if (!passed) {
            this.fPreviouslyCheckedWorkingDirIsValid = false;
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private static boolean equal(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private boolean checkCompatibility() {
        String progQuery;
        String progAuth;
        URI progURI;
        URI wdURI;
        String wdName = this.workingDirText.getText().trim();
        String progName = this.fProgText.getText().trim();
        try {
            wdURI = new URI(wdName);
            progURI = new URI(progName);
        }
        catch (URISyntaxException e) {
            System.err.println(ProxyLaunchMessages.uri_syntax_error);
            return false;
        }
        String wdScheme = wdURI.getScheme();
        String progScheme = progURI.getScheme();
        if (wdScheme == null && progScheme == null) {
            this.setErrorMessage(null);
            return true;
        }
        if (!RemoteProxyCMainTab.equal(wdScheme, progScheme)) {
            this.setErrorMessage(ProxyLaunchMessages.scheme_of_working_directory_and_program_do_not_match);
            return false;
        }
        String wdAuth = wdURI.getAuthority();
        if (!RemoteProxyCMainTab.equal(wdAuth, progAuth = progURI.getAuthority())) {
            this.setErrorMessage(ProxyLaunchMessages.connection_of_working_directory_and_program_do_not_match);
            return false;
        }
        String wdQuery = wdURI.getQuery();
        if (!RemoteProxyCMainTab.equal(wdQuery, progQuery = progURI.getQuery())) {
            this.setErrorMessage(ProxyLaunchMessages.connection_of_working_directory_and_program_do_not_match);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean isValid(ILaunchConfiguration config) {
        String coreName;
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LaunchMessages.CMainTab_Project_not_specified);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            this.setErrorMessage(LaunchMessages.Launch_common_Project_does_not_exist);
            return false;
        }
        if (!project.isOpen()) {
            this.setErrorMessage(LaunchMessages.CMainTab_Project_must_be_opened);
            return false;
        }
        if (!this.checkCopyFromExe(project)) {
            return false;
        }
        if (!this.checkProgram(project)) {
            return false;
        }
        if (!this.checkWorkingDir(project)) {
            return false;
        }
        if (!this.checkCompatibility()) {
            return false;
        }
        if (this.fCoreText != null && !(coreName = this.fCoreText.getText().trim()).equals("")) {
            if (coreName.equals(".") || coreName.equals("..")) {
                this.setErrorMessage(LaunchMessages.CMainTab_Core_does_not_exist);
                return false;
            }
            Path corePath = new Path(coreName);
            if (!corePath.toFile().exists()) {
                this.setErrorMessage(LaunchMessages.CMainTab_Core_does_not_exist);
                return false;
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
        config.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", true);
        ICElement cElement = null;
        cElement = this.getContext((ILaunchConfiguration)config, this.getPlatform((ILaunchConfiguration)config));
        if (cElement != null) {
            this.initializeCProject(cElement, config);
            this.initializeProgramName(cElement, config);
        } else {
            config.setMappedResources(null);
        }
        if (this.wantsTerminalOption()) {
            config.setAttribute("org.eclipse.cdt.launch.use_terminal", true);
        }
    }

    protected void initializeProgramName(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        String name;
        boolean renamed = false;
        if (!(cElement instanceof IBinary)) {
            cElement = cElement.getCProject();
        }
        if (cElement instanceof ICProject) {
            IProject project = cElement.getCProject().getProject();
            String name2 = project.getName();
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigName = projDes.getActiveConfiguration().getName();
                name2 = NLS.bind((String)LaunchMessages.CMainTab_Configuration_name, (Object)name2, (Object)buildConfigName);
            }
            name2 = this.getLaunchConfigurationDialog().generateName(name2);
            config.rename(name2);
            renamed = true;
        }
        IBinary binary = null;
        if (cElement instanceof ICProject) {
            IBinary[] bins = this.getBinaryFiles((ICProject)cElement);
            if (bins != null && bins.length == 1) {
                binary = bins[0];
            }
        } else if (cElement instanceof IBinary) {
            binary = (IBinary)cElement;
        }
        String projectDir = "";
        IProject project = null;
        try {
            project = ConfigUtils.getProject(ConfigUtils.getProjectName((ILaunchConfiguration)config));
        }
        catch (CoreException e) {
            this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.error_accessing_working_directory;
            this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
        }
        if (project != null) {
            try {
                projectDir = RemoteProxyManager.getInstance().getRemoteProjectLocation(project);
            }
            catch (CoreException e) {
                this.fPreviouslyCheckedWorkingDirErrorMsg = ProxyLaunchMessages.error_accessing_working_directory;
                this.setErrorMessage(this.fPreviouslyCheckedWorkingDirErrorMsg);
            }
        }
        String path = "";
        if (binary != null) {
            path = binary.getResource().getProjectRelativePath().toOSString();
            if (!renamed) {
                name = binary.getElementName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
                name = this.getLaunchConfigurationDialog().generateName(name);
                config.rename(name);
                renamed = true;
            }
        }
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", String.valueOf(projectDir) + '/' + path);
        if (!renamed) {
            name = this.getLaunchConfigurationDialog().generateName(cElement.getCProject().getElementName());
            config.rename(name);
        }
    }

    public String getId() {
        return TAB_ID;
    }

    public String getName() {
        return LaunchMessages.CMainTab_Main;
    }

    public Image getImage() {
        return LaunchImages.get((String)LaunchImages.IMG_VIEW_MAIN_TAB);
    }
}

