/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.extensions.externalNotificationListener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.properties.extension.FeatureFullDescription;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.ui.WorkbenchException;

public class ExtensionPointNotifyChangedListener
implements INotifyChangedListener {
    private static Logger log = Logger.getLogger(ExtensionPointNotifyChangedListener.class);
    private static Map<FeatureFullDescription, List<INotifyChangedListener>> extensionPointEntries;
    private static Map<FeatureFullDescription, List<INotifyChangedListener>> listeners;
    public static final String EXTENSION_POINT;
    private static final String PACKAGE_NAME = "packageName";
    private static final String CLASS_NAME = "className";
    private static final String FEATURE_NAME = "featureName";
    private static final String NOTIFYCHANGED_CLASS = "NotifyChangedListener";

    static {
        EXTENSION_POINT = PluginProperties.extension_point_notifychangedlistener;
    }

    public void notifyChanged(Notification notification) {
        ExtensionPointNotifyChangedListener.init();
        if (notification.getNotifier() instanceof EObject) {
            EObject eObject = (EObject)notification.getNotifier();
            Object featureFound = notification.getFeature();
            if (featureFound instanceof EStructuralFeature) {
                String featureName = ((EStructuralFeature)featureFound).getName();
                FeatureFullDescription currentFeature = new FeatureFullDescription((Object)eObject, featureName);
                if (!listeners.containsKey(currentFeature)) {
                    this.computeListenersFor(currentFeature);
                }
                for (INotifyChangedListener listener : listeners.get(currentFeature)) {
                    listener.notifyChanged(notification);
                }
            }
        }
    }

    private void computeListenersFor(FeatureFullDescription feature) {
        ArrayList featureListeners = new ArrayList();
        for (FeatureFullDescription availableFeature : extensionPointEntries.keySet()) {
            if (!feature.isFeatureFromSuperclass(availableFeature)) continue;
            featureListeners.addAll(extensionPointEntries.get(availableFeature));
        }
        listeners.put(feature, featureListeners);
    }

    private static synchronized void init() {
        if (extensionPointEntries == null) {
            extensionPointEntries = new HashMap<FeatureFullDescription, List<INotifyChangedListener>>();
            listeners = new HashMap<FeatureFullDescription, List<INotifyChangedListener>>();
            try {
                ExtensionPointNotifyChangedListener.processExtensionPoint();
            }
            catch (Exception e) {
                log.severe("An error occured while processing extension point");
                e.printStackTrace();
            }
        }
    }

    private static void processExtensionPoint() throws WorkbenchException {
        log.debug("Processing extension point " + EXTENSION_POINT);
        IConfigurationElement[] confElements = ExtensionsHelper.findConfigurationElements(EXTENSION_POINT);
        int m = 0;
        while (m < confElements.length) {
            IConfigurationElement member = confElements[m];
            String featureName = member.getAttribute(FEATURE_NAME);
            String className = member.getAttribute(CLASS_NAME);
            String packageName = member.getAttribute(PACKAGE_NAME);
            log.info("JWT Extension - found NotifyChangedListener at " + EXTENSION_POINT + ": {" + packageName + "}" + className + "/" + featureName);
            FeatureFullDescription featureFullDescription = new FeatureFullDescription(featureName, className, packageName);
            INotifyChangedListenerProxy proxy = new INotifyChangedListenerProxy(member);
            if (!extensionPointEntries.containsKey(featureFullDescription) || extensionPointEntries.get(featureFullDescription) == null) {
                extensionPointEntries.put(featureFullDescription, new ArrayList());
            }
            extensionPointEntries.get(featureFullDescription).add(proxy);
            ++m;
        }
    }

    private static class INotifyChangedListenerProxy
    implements INotifyChangedListener {
        private INotifyChangedListener delegate = null;
        private IConfigurationElement element;
        private boolean invoked = false;

        public INotifyChangedListenerProxy(IConfigurationElement element) {
            this.element = element;
        }

        private final INotifyChangedListener getDelegate() throws Exception {
            if (this.invoked) {
                return this.delegate;
            }
            this.invoked = true;
            Object callback = this.element.createExecutableExtension(ExtensionPointNotifyChangedListener.NOTIFYCHANGED_CLASS);
            if (!(callback instanceof INotifyChangedListener)) {
                throw new ClassCastException("Class [" + callback.getClass().getName() + "] is not an instance of INotifyChangedListener");
            }
            this.delegate = (INotifyChangedListener)callback;
            return this.delegate;
        }

        public void notifyChanged(Notification notification) {
            try {
                this.getDelegate().notifyChanged(notification);
            }
            catch (Exception ex) {
                log.severe("An error occured while trying to retrieve delegate");
                ex.printStackTrace();
            }
        }
    }
}

