/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.properties.extension.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.properties.extension.FeatureFullDescription;
import org.eclipse.jwt.we.editors.properties.extension.PropertyDescriptorFactory;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertyDescriptorExtensionPoint {
    private static Map<FeatureFullDescription, PropertyDescriptorFactory> extensionPointEntries = new HashMap<FeatureFullDescription, PropertyDescriptorFactory>();
    private static Map<FeatureFullDescription, PropertyDescriptorFactory> propertyDescriptors = new HashMap<FeatureFullDescription, PropertyDescriptorFactory>();
    private static Logger log = Logger.getLogger(PropertyDescriptorExtensionPoint.class);
    private static boolean initialized = false;
    public static final String EXTENSION_POINT = PluginProperties.extension_point_propertydescriptor;
    private static final String PACKAGE_NAME = "packageName";
    private static final String CLASS_NAME = "className";
    private static final String FEATURE_NAME = "featureName";
    private static final String ITEMPROVIDERFACTORY_CLASS = "PropertyDescriptorFactoryImpl";

    private static synchronized void init() {
        if (!initialized) {
            try {
                PropertyDescriptorExtensionPoint.processExtensionPoint();
            }
            catch (WorkbenchException workbenchException) {
                Logger.getLogger(PropertyDescriptorExtensionPoint.class).severe("Could not process extension point for custom PropertyDescriptor");
            }
            initialized = true;
        }
    }

    public static IPropertyDescriptor getPropertyDescriptor(Object eObject, IItemPropertyDescriptor itemPropertyDescriptor) {
        PropertyDescriptorFactory propertyDescriptorFactory;
        PropertyDescriptorExtensionPoint.init();
        FeatureFullDescription currentFeature = new FeatureFullDescription(eObject, itemPropertyDescriptor);
        if (!propertyDescriptors.containsKey(currentFeature)) {
            PropertyDescriptorExtensionPoint.computePropertyDescriptorFor(currentFeature);
        }
        if ((propertyDescriptorFactory = propertyDescriptors.get(currentFeature)) != null) {
            return propertyDescriptorFactory.getPropertyDescriptor(eObject, itemPropertyDescriptor);
        }
        return null;
    }

    private static void computePropertyDescriptorFor(FeatureFullDescription currentFeature) {
        FeatureFullDescription bestFeature = null;
        for (FeatureFullDescription availableFeature : extensionPointEntries.keySet()) {
            if (!currentFeature.isFeatureFromSuperclass(availableFeature) || bestFeature != null && !availableFeature.isFeatureFromSuperclass(bestFeature)) continue;
            bestFeature = availableFeature;
        }
        if (bestFeature == null) {
            propertyDescriptors.put(currentFeature, null);
        } else {
            propertyDescriptors.put(currentFeature, extensionPointEntries.get(bestFeature));
        }
    }

    private static void processExtensionPoint() throws WorkbenchException {
        log.debug("Processing extension point " + EXTENSION_POINT);
        IConfigurationElement[] confElements = ExtensionsHelper.findConfigurationElements(EXTENSION_POINT);
        int m = 0;
        while (m < confElements.length) {
            IConfigurationElement member = confElements[m];
            String featureName = member.getAttribute(FEATURE_NAME);
            String className = member.getAttribute(CLASS_NAME);
            String packageName = member.getAttribute(PACKAGE_NAME);
            log.info("JWT Extension - found PropertyDescriptor at " + EXTENSION_POINT + ": {" + packageName + "}" + className + "/" + featureName);
            PropertyDescriptorFactoryProxy proxy = new PropertyDescriptorFactoryProxy(member);
            extensionPointEntries.put(new FeatureFullDescription(featureName, className, packageName), proxy);
            ++m;
        }
    }

    private static class PropertyDescriptorFactoryProxy
    implements PropertyDescriptorFactory {
        private PropertyDescriptorFactory delegate = null;
        private IConfigurationElement element;
        private boolean invoked = false;

        public PropertyDescriptorFactoryProxy(IConfigurationElement element) {
            this.element = element;
        }

        private final PropertyDescriptorFactory getDelegate() throws Exception {
            if (this.invoked) {
                return this.delegate;
            }
            this.invoked = true;
            Object callback = this.element.createExecutableExtension(PropertyDescriptorExtensionPoint.ITEMPROVIDERFACTORY_CLASS);
            if (!(callback instanceof PropertyDescriptorFactory)) {
                throw new ClassCastException("Class [" + callback.getClass().getName() + "] is not an instance of PropertyDescriptorFactory");
            }
            this.delegate = (PropertyDescriptorFactory)callback;
            return this.delegate;
        }

        public IPropertyDescriptor getPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            PropertyDescriptorFactory propertyDescriptorFactory = null;
            try {
                propertyDescriptorFactory = this.getDelegate();
            }
            catch (Exception exception) {
                log.warning("Could not get implementation for a PropertyDescriptor Extension point");
            }
            return propertyDescriptorFactory.getPropertyDescriptor(object, itemPropertyDescriptor);
        }
    }
}

