/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.LayoutData;

public class SetGraphicalElementConstraintCommand
extends Command {
    private static final Logger logger = Logger.getLogger(SetGraphicalElementConstraintCommand.class);
    private WEEditor weeditor;
    private CreateRequest createRequest;
    private GraphicalElement element;
    private Rectangle newBounds;
    private LayoutData oldLayoutData;

    public SetGraphicalElementConstraintCommand(WEEditor weeditor, CreateRequest createRequest, Rectangle newBounds) {
        this.createRequest = createRequest;
        this.newBounds = newBounds;
        this.weeditor = weeditor;
    }

    public SetGraphicalElementConstraintCommand(WEEditor weeditor, GraphicalElement element, Rectangle newBounds) {
        this.element = element;
        this.newBounds = newBounds;
        this.weeditor = weeditor;
    }

    public boolean canExecute() {
        return this.element != null || this.createRequest != null && this.createRequest.getNewObjectType() instanceof Class && GraphicalElement.class.isAssignableFrom((Class)this.createRequest.getNewObjectType());
    }

    public void execute() {
        if (this.element == null) {
            this.element = (GraphicalElement)this.createRequest.getNewObject();
        }
        this.oldLayoutData = (LayoutData)new EcoreUtil.Copier().copy((EObject)LayoutDataManager.getLayoutData(this.weeditor, this.element));
        this.redo();
    }

    public void redo() {
        if (this.newBounds.x != this.oldLayoutData.getX() || this.newBounds.y != this.oldLayoutData.getY() || this.newBounds.width != this.oldLayoutData.getWidth() || this.newBounds.height != this.oldLayoutData.getHeight()) {
            if (this.newBounds.x != -1) {
                LayoutDataManager.setX(this.weeditor, this.element, this.newBounds.x);
            }
            if (this.newBounds.y != -1) {
                LayoutDataManager.setY(this.weeditor, this.element, this.newBounds.y);
            }
            if (this.newBounds.width != -1) {
                LayoutDataManager.setWidth(this.weeditor, this.element, this.newBounds.width);
            }
            if (this.newBounds.height != -1) {
                LayoutDataManager.setHeight(this.weeditor, this.element, this.newBounds.height);
            }
            logger.valueChanged("element.layoutdata", this.oldLayoutData, this.newBounds);
        }
    }

    public void undo() {
        LayoutDataManager.setLayoutData(this.weeditor, this.element, this.oldLayoutData);
    }

    public void dispose() {
        super.dispose();
        this.createRequest = null;
        this.newBounds = null;
        this.oldLayoutData = null;
    }
}

