/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.presentation;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.we.conf.presentation.ConfMetaModelEditorPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreationWizardPageFileName
extends WizardPage {
    protected Text fileField;
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(ConfMetaModelEditorPlugin.INSTANCE.getString("_UI_ConfEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = ConfMetaModelEditorPlugin.INSTANCE.getString("_UI_ConfEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CreationWizardPageFileName.this.setPageComplete(CreationWizardPageFileName.this.validatePage());
        }
    };

    public CreationWizardPageFileName(String pageId) {
        super(pageId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label resourceURILabel = new Label(composite, 16384);
        resourceURILabel.setText("File");
        data = new GridData();
        data.horizontalAlignment = 4;
        resourceURILabel.setLayoutData((Object)data);
        Composite fileComposite = new Composite(composite, 0);
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        fileComposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        data2.horizontalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        fileComposite.setLayout((Layout)layout2);
        this.fileField = new Text(fileComposite, 2048);
        data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.horizontalSpan = 1;
        this.fileField.setLayoutData((Object)data2);
        this.fileField.addModifyListener(this.validator);
        Button resourceURIBrowseFileSystemButton = new Button(fileComposite, 8);
        resourceURIBrowseFileSystemButton.setText("Browse");
        resourceURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String fileExtension = ConfMetaModelEditorPlugin.INSTANCE.getString("_UI_ConfEditorFilenameExtensions");
                String filePath = CreationWizardPageFileName.openFilePathDialog(CreationWizardPageFileName.this.getShell(), null, 4096);
                if (filePath != null) {
                    if (!filePath.endsWith("." + fileExtension)) {
                        filePath = String.valueOf(filePath) + "." + fileExtension;
                    }
                    CreationWizardPageFileName.this.fileField.setText(filePath);
                }
            }
        });
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    private static String openFilePathDialog(Shell shell, String fileExtensionFilter, int style) {
        FileDialog fileDialog = new FileDialog(shell, style);
        if (fileExtensionFilter == null) {
            fileExtensionFilter = "*." + ConfMetaModelEditorPlugin.INSTANCE.getString("_UI_ConfEditorFilenameExtensions");
        }
        fileDialog.setFilterExtensions(new String[]{fileExtensionFilter});
        fileDialog.setFilterNames(new String[]{ConfMetaModelEditorPlugin.INSTANCE.getString("_UI_ConfEditorFilenameExtensions")});
        fileDialog.open();
        if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
            return String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
        }
        return null;
    }

    protected boolean validatePage() {
        URI fileURI = this.getFileURI();
        this.setErrorMessage(null);
        if (fileURI == null || fileURI.isEmpty()) {
            return false;
        }
        String extension = new Path(this.getFileURI().toFileString()).getFileExtension();
        if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
            String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
            this.setErrorMessage(ConfMetaModelEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
            return false;
        }
        return true;
    }

    public URI getFileURI() {
        try {
            return URI.createFileURI((String)this.fileField.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fileField.getVisible()) {
            this.fileField.setFocus();
        }
    }

    public File getModelFile() {
        try {
            return new File(URI.createFileURI((String)this.fileField.getText()).toFileString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void selectFileField() {
        this.fileField.selectAll();
        this.fileField.setFocus();
    }
}

