/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.dialogs.EnterCommentDialog;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.validator.MaxStringLengthValidator;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class EditNodeComment
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        INodePO node = (INodePO)this.getFirstElement(INodePO.class);
        if (node != null) {
            String origComment = node.getComment();
            EnterCommentDialog dialog = new EnterCommentDialog(this.getActiveShell(), (IValidator)new MaxStringLengthValidator(), origComment);
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.testResultSummaryAddCommentContextId");
            int result = dialog.open();
            if (result != 0) {
                return null;
            }
            String newComment = dialog.getCommentTitle();
            if (!StringUtils.equals((String)origComment, (String)newComment)) {
                try {
                    NodePM.setComment((INodePO)node, (String)newComment);
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all);
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleProjectDeletedException();
                }
            }
        }
        return null;
    }
}

