/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionDelegate;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;

public class CreateLogicElementActionDelegate
extends AbstractActionDelegate
implements IObjectActionDelegate {
    protected void doRun(IProgressMonitor progressMonitor) {
        String actionId = this.getAction().getId();
        IElementType elementType = ElementTypeRegistry.getInstance().getType(actionId);
        if (elementType == null) {
            throw new IllegalArgumentException("Action id '" + actionId + "' does not correspond to an existing element type ID.");
        }
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        Object selection = structuredSelection.getFirstElement();
        if (!(selection instanceof IGraphicalEditPart)) {
            throw new IllegalArgumentException("Selected element '" + selection + "' is not an IGraphicalEditPart.");
        }
        IGraphicalEditPart container = (IGraphicalEditPart)selection;
        CreateViewRequest createRequest = CreateViewRequestFactory.getCreateShapeRequest((IElementType)elementType, (PreferencesHint)container.getDiagramPreferencesHint());
        Command command = container.getCommand((Request)createRequest);
        if (command == null || !command.canExecute()) {
            throw new IllegalArgumentException("Command for '" + actionId + "' is not executable.");
        }
        DiagramCommandStack commandStack = container.getDiagramEditDomain().getDiagramCommandStack();
        commandStack.execute(command);
    }
}

