/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.markoccurrences;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.occurrences.DefaultOccurrenceComputer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DotOccurrenceComputer
extends DefaultOccurrenceComputer {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private Provider<TargetURIs> targetURIsProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    public Map<Annotation, Position> createAnnotationMap(XtextEditor editor, final ITextSelection selection, SubMonitor monitor) {
        final Map annotationMap = super.createAnnotationMap(editor, selection, monitor);
        final IXtextDocument document = editor.getDocument();
        if (document != null) {
            return (Map)document.readOnly((IUnitOfWork)new CancelableUnitOfWork<Map<Annotation, Position>, XtextResource>(){

                public Map<Annotation, Position> exec(XtextResource resource, CancelIndicator cancelIndicator) throws Exception {
                    EObject target;
                    if (resource != null && (target = DotOccurrenceComputer.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset())) != null && !target.eIsProxy()) {
                        Iterable targetURIs = DotOccurrenceComputer.this.getTargetURIs(target);
                        if (!(targetURIs instanceof TargetURIs)) {
                            TargetURIs result = (TargetURIs)DotOccurrenceComputer.this.targetURIsProvider.get();
                            result.addAllURIs(targetURIs);
                            targetURIs = result;
                        }
                        for (EObject occurrence : DotOccurrenceComputer.this.getAllOccurrences((TargetURIs)targetURIs, (Resource)resource)) {
                            try {
                                ITextRegion textRegion = DotOccurrenceComputer.this.locationInFileProvider.getSignificantTextRegion(occurrence, (EStructuralFeature)DotPackage.Literals.NODE_ID__NAME, -1);
                                DotOccurrenceComputer.this.addOccurrenceAnnotation("org.eclipse.xtext.ui.editor.defaultOccurrenceAnnotation", (IDocument)document, textRegion, annotationMap);
                            }
                            catch (Exception exception) {}
                        }
                        return annotationMap;
                    }
                    return annotationMap;
                }
            });
        }
        return annotationMap;
    }

    private List<? extends EObject> getAllOccurrences(TargetURIs targetURIs, Resource resource) {
        for (URI targetURI : targetURIs) {
            EObject eObject = resource.getEObject(targetURI.fragment());
            if (!(eObject instanceof NodeId)) continue;
            NodeId selectedNodeId = (NodeId)eObject;
            return DotAstHelper.getAllNodeIds((NodeId)selectedNodeId);
        }
        return new ArrayList();
    }
}

