/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.osgi.service.event.Event;

public class UIEvents {
    public static final String TOPIC_SEP = "/";
    public static final String ALL_SUB_TOPICS = "*";
    public static final String UITopicBase = "org/eclipse/e4/ui";
    public static final String UIModelTopicBase = "org/eclipse/e4/ui/model";
    public static final String UIRendererTopicBase = "org/eclipse/e4/ui/renderer";
    public static final String REQUEST_ENABLEMENT_UPDATE_TOPIC = "org/eclipse/e4/ui/renderer/requestEnablementUpdate";
    public static final String ALL_ELEMENT_ID = "ALL";

    public static boolean isADD(Event event) {
        Object type = event.getProperty("EventType");
        return "ADD".equals(type) || "ADD_MANY".equals(type);
    }

    public static boolean isREMOVE(Event event) {
        Object type = event.getProperty("EventType");
        return "REMOVE".equals(type) || "REMOVE_MANY".equals(type);
    }

    public static boolean isMOVE(Event event) {
        return "MOVE".equals(event.getProperty("EventType"));
    }

    public static boolean isSET(Event event) {
        return "SET".equals(event.getProperty("EventType"));
    }

    public static boolean isCREATE(Event event) {
        return "CREATE".equals(event.getProperty("EventType"));
    }

    public static boolean contains(Event event, String propertyName, Object o) {
        Object container = event.getProperty(propertyName);
        if (container == null) {
            return false;
        }
        if (container instanceof Collection && ((Collection)container).contains(o)) {
            return true;
        }
        if (container instanceof Object[]) {
            Object[] objectArray = (Object[])container;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (o.equals(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return o.equals(container);
    }

    public static Iterable<?> asIterable(Event event, String propertyName) {
        Object o = event.getProperty(propertyName);
        return o instanceof Collection ? (Set<Object>)o : Collections.singleton(o);
    }

    public static boolean publishEvent(String topic, MUIElement changedElement) {
        if (topic == null || topic.length() == 0 || changedElement == null) {
            return false;
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>(1);
        argMap.put("ChangedElement", changedElement);
        return UIEvents.publishEvent(topic, argMap);
    }

    public static boolean publishEvent(String topic, Map<String, Object> argMap) {
        IEclipseContext context;
        if (topic == null || topic.length() == 0 || argMap == null) {
            return false;
        }
        Object uiElement = argMap.get("ChangedElement");
        if (uiElement == null || !(uiElement instanceof MUIElement)) {
            return false;
        }
        IEclipseContext iEclipseContext = context = uiElement instanceof MApplication ? ((MApplication)uiElement).getContext() : ModelUtils.getContainingContext((MApplicationElement)((MUIElement)uiElement));
        if (context == null) {
            return false;
        }
        IEventBroker eventBroker = (IEventBroker)context.get(IEventBroker.class);
        if (eventBroker == null) {
            return false;
        }
        return eventBroker.send(topic, argMap);
    }

    @Deprecated
    public static String buildTopic(String topic) {
        return String.valueOf(topic) + TOPIC_SEP + ALL_SUB_TOPICS;
    }

    @Deprecated
    public static String buildTopic(String topic, String attrName) {
        return String.valueOf(topic) + TOPIC_SEP + attrName + TOPIC_SEP + ALL_SUB_TOPICS;
    }

    @Deprecated
    public static String buildTopic(String topic, String attrName, String eventType) {
        return String.valueOf(topic) + TOPIC_SEP + attrName + TOPIC_SEP + eventType;
    }

    public static interface Application {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/application/Application";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/application/Application/*";
        public static final String TOPIC_ADDONS = "org/eclipse/e4/ui/model/application/Application/addons/*";
        public static final String TOPIC_CATEGORIES = "org/eclipse/e4/ui/model/application/Application/categories/*";
        public static final String TOPIC_COMMANDS = "org/eclipse/e4/ui/model/application/Application/commands/*";
        public static final String TOPIC_DIALOGS = "org/eclipse/e4/ui/model/application/Application/dialogs/*";
        public static final String ADDONS = "addons";
        public static final String CATEGORIES = "categories";
        public static final String COMMANDS = "commands";
        @Deprecated
        public static final String DIALOGS = "dialogs";
    }

    public static interface ApplicationElement {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/application/ApplicationElement";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/application/ApplicationElement/*";
        public static final String TOPIC_CONTRIBUTORURI = "org/eclipse/e4/ui/model/application/ApplicationElement/contributorURI/*";
        public static final String TOPIC_ELEMENTID = "org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*";
        public static final String TOPIC_PERSISTEDSTATE = "org/eclipse/e4/ui/model/application/ApplicationElement/persistedState/*";
        public static final String TOPIC_TAGS = "org/eclipse/e4/ui/model/application/ApplicationElement/tags/*";
        public static final String TOPIC_TRANSIENTDATA = "org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*";
        public static final String CONTRIBUTORURI = "contributorURI";
        public static final String ELEMENTID = "elementId";
        public static final String PERSISTEDSTATE = "persistedState";
        public static final String TAGS = "tags";
        public static final String TRANSIENTDATA = "transientData";
    }

    public static interface BindingContext {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/BindingContext";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/BindingContext/*";
        public static final String TOPIC_CHILDREN = "org/eclipse/e4/ui/model/commands/BindingContext/children/*";
        public static final String TOPIC_DESCRIPTION = "org/eclipse/e4/ui/model/commands/BindingContext/description/*";
        public static final String TOPIC_NAME = "org/eclipse/e4/ui/model/commands/BindingContext/name/*";
        public static final String CHILDREN = "children";
        public static final String DESCRIPTION = "description";
        public static final String NAME = "name";
    }

    public static interface BindingTable {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/BindingTable";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/BindingTable/*";
        public static final String TOPIC_BINDINGCONTEXT = "org/eclipse/e4/ui/model/commands/BindingTable/bindingContext/*";
        public static final String TOPIC_BINDINGS = "org/eclipse/e4/ui/model/commands/BindingTable/bindings/*";
        public static final String BINDINGCONTEXT = "bindingContext";
        public static final String BINDINGS = "bindings";
    }

    public static interface BindingTableContainer {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/BindingTableContainer";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/BindingTableContainer/*";
        public static final String TOPIC_BINDINGTABLES = "org/eclipse/e4/ui/model/commands/BindingTableContainer/bindingTables/*";
        public static final String TOPIC_ROOTCONTEXT = "org/eclipse/e4/ui/model/commands/BindingTableContainer/rootContext/*";
        public static final String BINDINGTABLES = "bindingTables";
        public static final String ROOTCONTEXT = "rootContext";
    }

    public static interface Bindings {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/Bindings";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/Bindings/*";
        public static final String TOPIC_BINDINGCONTEXTS = "org/eclipse/e4/ui/model/commands/Bindings/bindingContexts/*";
        public static final String BINDINGCONTEXTS = "bindingContexts";
    }

    public static interface Category {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/Category";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/Category/*";
        public static final String TOPIC_DESCRIPTION = "org/eclipse/e4/ui/model/commands/Category/description/*";
        public static final String TOPIC_NAME = "org/eclipse/e4/ui/model/commands/Category/name/*";
        public static final String TOPIC_LOCALIZED_NAME = "org/eclipse/e4/ui/model/commands/Category/localizedName/*";
        public static final String DESCRIPTION = "description";
        public static final String NAME = "name";
        public static final String LOCALIZED_NAME = "localizedName";
    }

    public static interface Command {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/Command";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/Command/*";
        public static final String TOPIC_CATEGORY = "org/eclipse/e4/ui/model/commands/Command/category/*";
        public static final String TOPIC_COMMANDNAME = "org/eclipse/e4/ui/model/commands/Command/commandName/*";
        public static final String TOPIC_DESCRIPTION = "org/eclipse/e4/ui/model/commands/Command/description/*";
        public static final String TOPIC_PARAMETERS = "org/eclipse/e4/ui/model/commands/Command/parameters/*";
        public static final String TOPIC_LOCALIZED_COMMANDNAME = "org/eclipse/e4/ui/model/commands/Command/localizedCommandName/*";
        public static final String TOPIC_LOCALIZED_DESCRIPTION = "org/eclipse/e4/ui/model/commands/Command/localizedDescription/*";
        public static final String CATEGORY = "category";
        public static final String COMMANDNAME = "commandName";
        public static final String DESCRIPTION = "description";
        public static final String PARAMETERS = "parameters";
        public static final String LOCALIZED_COMMANDNAME = "localizedCommandName";
        public static final String LOCALIZED_DESCRIPTION = "localizedDescription";
    }

    public static interface CommandParameter {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/CommandParameter";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/CommandParameter/*";
        public static final String TOPIC_NAME = "org/eclipse/e4/ui/model/commands/CommandParameter/name/*";
        public static final String TOPIC_OPTIONAL = "org/eclipse/e4/ui/model/commands/CommandParameter/optional/*";
        public static final String TOPIC_TYPEID = "org/eclipse/e4/ui/model/commands/CommandParameter/typeId/*";
        public static final String NAME = "name";
        public static final String OPTIONAL = "optional";
        public static final String TYPEID = "typeId";
    }

    public static interface Context {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/Context";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/Context/*";
        public static final String TOPIC_CONTEXT = "org/eclipse/e4/ui/model/ui/Context/context/*";
        public static final String TOPIC_PROPERTIES = "org/eclipse/e4/ui/model/ui/Context/properties/*";
        public static final String TOPIC_VARIABLES = "org/eclipse/e4/ui/model/ui/Context/variables/*";
        public static final String CONTEXT = "context";
        public static final String PROPERTIES = "properties";
        public static final String VARIABLES = "variables";
    }

    public static interface Contribution {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/application/Contribution";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/application/Contribution/*";
        public static final String TOPIC_CONTRIBUTIONURI = "org/eclipse/e4/ui/model/application/Contribution/contributionURI/*";
        public static final String TOPIC_OBJECT = "org/eclipse/e4/ui/model/application/Contribution/object/*";
        public static final String CONTRIBUTIONURI = "contributionURI";
        public static final String OBJECT = "object";
    }

    public static interface CoreExpression {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/CoreExpression";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/CoreExpression/*";
        public static final String TOPIC_COREEXPRESSION = "org/eclipse/e4/ui/model/ui/CoreExpression/coreExpression/*";
        public static final String TOPIC_COREEXPRESSIONID = "org/eclipse/e4/ui/model/ui/CoreExpression/coreExpressionId/*";
        public static final String COREEXPRESSION = "coreExpression";
        public static final String COREEXPRESSIONID = "coreExpressionId";
    }

    public static interface Dirtyable {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/Dirtyable";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/Dirtyable/*";
        public static final String TOPIC_DIRTY = "org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*";
        public static final String DIRTY = "dirty";
    }

    public static interface ElementContainer {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/ElementContainer";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/ElementContainer/*";
        public static final String TOPIC_CHILDREN = "org/eclipse/e4/ui/model/ui/ElementContainer/children/*";
        public static final String TOPIC_SELECTEDELEMENT = "org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*";
        public static final String CHILDREN = "children";
        public static final String SELECTEDELEMENT = "selectedElement";
    }

    public static interface EventTags {
        public static final String ELEMENT = "ChangedElement";
        public static final String WIDGET = "Widget";
        public static final String TYPE = "EventType";
        public static final String ATTNAME = "AttName";
        public static final String OLD_VALUE = "OldValue";
        public static final String NEW_VALUE = "NewValue";
        public static final String POSITION = "Position";
    }

    public static interface EventTypes {
        public static final String CREATE = "CREATE";
        public static final String SET = "SET";
        public static final String ADD = "ADD";
        public static final String ADD_MANY = "ADD_MANY";
        public static final String REMOVE = "REMOVE";
        public static final String REMOVE_MANY = "REMOVE_MANY";
        public static final String MOVE = "MOVE";
    }

    public static interface GenericTile {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/GenericTile";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/GenericTile/*";
        public static final String TOPIC_HORIZONTAL = "org/eclipse/e4/ui/model/ui/GenericTile/horizontal/*";
        public static final String HORIZONTAL = "horizontal";
    }

    public static interface GenericTrimContainer {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/GenericTrimContainer";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/GenericTrimContainer/*";
        public static final String TOPIC_SIDE = "org/eclipse/e4/ui/model/ui/GenericTrimContainer/side/*";
        public static final String SIDE = "side";
    }

    public static interface HandledItem {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/HandledItem";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/HandledItem/*";
        public static final String TOPIC_COMMAND = "org/eclipse/e4/ui/model/menu/HandledItem/command/*";
        public static final String TOPIC_PARAMETERS = "org/eclipse/e4/ui/model/menu/HandledItem/parameters/*";
        public static final String TOPIC_WBCOMMAND = "org/eclipse/e4/ui/model/menu/HandledItem/wbCommand/*";
        public static final String COMMAND = "command";
        public static final String PARAMETERS = "parameters";
        public static final String WBCOMMAND = "wbCommand";
    }

    public static interface Handler {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/Handler";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/Handler/*";
        public static final String TOPIC_COMMAND = "org/eclipse/e4/ui/model/commands/Handler/command/*";
        public static final String COMMAND = "command";
    }

    public static interface HandlerContainer {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/HandlerContainer";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/HandlerContainer/*";
        public static final String TOPIC_HANDLERS = "org/eclipse/e4/ui/model/commands/HandlerContainer/handlers/*";
        public static final String HANDLERS = "handlers";
    }

    public static interface ImperativeExpression {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/ImperativeExpression";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/ImperativeExpression/*";
        public static final String TOPIC_TRACKING = "org/eclipse/e4/ui/model/ui/ImperativeExpression/tracking/*";
        public static final String TRACKING = "tracking";
    }

    @Deprecated
    public static interface Input {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/Input";
        @Deprecated
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/Input/*";
        @Deprecated
        public static final String TOPIC_INPUTURI = "org/eclipse/e4/ui/model/ui/Input/inputURI/*";
        @Deprecated
        public static final String INPUTURI = "inputURI";
    }

    public static interface Item {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/Item";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/Item/*";
        public static final String TOPIC_ENABLED = "org/eclipse/e4/ui/model/menu/Item/enabled/*";
        public static final String TOPIC_SELECTED = "org/eclipse/e4/ui/model/menu/Item/selected/*";
        public static final String TOPIC_TYPE = "org/eclipse/e4/ui/model/menu/Item/type/*";
        public static final String ENABLED = "enabled";
        public static final String SELECTED = "selected";
        public static final String TYPE = "type";
    }

    public static interface KeyBinding {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/KeyBinding";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/KeyBinding/*";
        public static final String TOPIC_COMMAND = "org/eclipse/e4/ui/model/commands/KeyBinding/command/*";
        public static final String TOPIC_PARAMETERS = "org/eclipse/e4/ui/model/commands/KeyBinding/parameters/*";
        public static final String COMMAND = "command";
        public static final String PARAMETERS = "parameters";
    }

    public static interface KeySequence {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/KeySequence";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/KeySequence/*";
        public static final String TOPIC_KEYSEQUENCE = "org/eclipse/e4/ui/model/commands/KeySequence/keySequence/*";
        public static final String KEYSEQUENCE = "keySequence";
    }

    public static interface Menu {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/Menu";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/Menu/*";
        public static final String TOPIC_ENABLED = "org/eclipse/e4/ui/model/menu/Menu/enabled/*";
        public static final String ENABLED = "enabled";
    }

    public static interface MenuContribution {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/MenuContribution";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/MenuContribution/*";
        public static final String TOPIC_PARENTID = "org/eclipse/e4/ui/model/menu/MenuContribution/parentId/*";
        public static final String TOPIC_POSITIONINPARENT = "org/eclipse/e4/ui/model/menu/MenuContribution/positionInParent/*";
        public static final String PARENTID = "parentId";
        public static final String POSITIONINPARENT = "positionInParent";
    }

    public static interface MenuContributions {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/MenuContributions";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/MenuContributions/*";
        public static final String TOPIC_MENUCONTRIBUTIONS = "org/eclipse/e4/ui/model/menu/MenuContributions/menuContributions/*";
        public static final String MENUCONTRIBUTIONS = "menuContributions";
    }

    public static interface MenuElement {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/MenuElement";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/MenuElement/*";
        public static final String TOPIC_MNEMONICS = "org/eclipse/e4/ui/model/menu/MenuElement/mnemonics/*";
        public static final String MNEMONICS = "mnemonics";
    }

    public static interface OpaqueMenuItem {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/OpaqueMenuItem";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/OpaqueMenuItem/*";
        public static final String TOPIC_OPAQUEITEM = "org/eclipse/e4/ui/model/menu/OpaqueMenuItem/opaqueItem/*";
        public static final String OPAQUEITEM = "opaqueItem";
    }

    public static interface OpaqueMenuSeparator {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/OpaqueMenuSeparator";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/OpaqueMenuSeparator/*";
        public static final String TOPIC_OPAQUEITEM = "org/eclipse/e4/ui/model/menu/OpaqueMenuSeparator/opaqueItem/*";
        public static final String OPAQUEITEM = "opaqueItem";
    }

    public static interface OpaqueToolItem {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/OpaqueToolItem";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/OpaqueToolItem/*";
        public static final String TOPIC_OPAQUEITEM = "org/eclipse/e4/ui/model/menu/OpaqueToolItem/opaqueItem/*";
        public static final String OPAQUEITEM = "opaqueItem";
    }

    public static interface Parameter {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/commands/Parameter";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/commands/Parameter/*";
        public static final String TOPIC_NAME = "org/eclipse/e4/ui/model/commands/Parameter/name/*";
        public static final String TOPIC_VALUE = "org/eclipse/e4/ui/model/commands/Parameter/value/*";
        public static final String NAME = "name";
        public static final String VALUE = "value";
    }

    public static interface Part {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/basic/Part";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/basic/Part/*";
        public static final String TOPIC_CLOSEABLE = "org/eclipse/e4/ui/model/basic/Part/closeable/*";
        public static final String TOPIC_DESCRIPTION = "org/eclipse/e4/ui/model/basic/Part/description/*";
        public static final String TOPIC_MENUS = "org/eclipse/e4/ui/model/basic/Part/menus/*";
        public static final String TOPIC_TOOLBAR = "org/eclipse/e4/ui/model/basic/Part/toolbar/*";
        public static final String TOPIC_TRIMBARS = "org/eclipse/e4/ui/model/basic/Part/trimBars/*";
        public static final String TOPIC_LOCALIZED_DESCRIPTION = "org/eclipse/e4/ui/model/basic/Part/localizedDescription/*";
        public static final String CLOSEABLE = "closeable";
        public static final String DESCRIPTION = "description";
        public static final String MENUS = "menus";
        public static final String TOOLBAR = "toolbar";
        public static final String LOCALIZED_DESCRIPTION = "localizedDescription";
    }

    public static interface PartDescriptor {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/basic/PartDescriptor";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/basic/PartDescriptor/*";
        public static final String TOPIC_ALLOWMULTIPLE = "org/eclipse/e4/ui/model/basic/PartDescriptor/allowMultiple/*";
        public static final String TOPIC_CATEGORY = "org/eclipse/e4/ui/model/basic/PartDescriptor/category/*";
        public static final String TOPIC_CLOSEABLE = "org/eclipse/e4/ui/model/basic/PartDescriptor/closeable/*";
        public static final String TOPIC_CONTRIBUTIONURI = "org/eclipse/e4/ui/model/basic/PartDescriptor/contributionURI/*";
        public static final String TOPIC_DESCRIPTION = "org/eclipse/e4/ui/model/basic/PartDescriptor/description/*";
        @Deprecated
        public static final String TOPIC_DIRTYABLE = "org/eclipse/e4/ui/model/basic/PartDescriptor/dirtyable/*";
        public static final String TOPIC_MENUS = "org/eclipse/e4/ui/model/basic/PartDescriptor/menus/*";
        public static final String TOPIC_TOOLBAR = "org/eclipse/e4/ui/model/basic/PartDescriptor/toolbar/*";
        public static final String TOPIC_LOCALIZED_DESCRIPTION = "org/eclipse/e4/ui/model/basic/PartDescriptor/localizedDescription/*";
        public static final String ALLOWMULTIPLE = "allowMultiple";
        public static final String CATEGORY = "category";
        public static final String CLOSEABLE = "closeable";
        public static final String CONTRIBUTIONURI = "contributionURI";
        public static final String DESCRIPTION = "description";
        public static final String DIRTYABLE = "dirtyable";
        public static final String MENUS = "menus";
        public static final String TOOLBAR = "toolbar";
        public static final String LOCALIZED_DESCRIPTION = "localizedDescription";
    }

    public static interface PartDescriptorContainer {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/basic/PartDescriptorContainer";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/basic/PartDescriptorContainer/*";
        public static final String TOPIC_DESCRIPTORS = "org/eclipse/e4/ui/model/basic/PartDescriptorContainer/descriptors/*";
        public static final String DESCRIPTORS = "descriptors";
    }

    public static interface Perspective {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/advanced/Perspective";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/advanced/Perspective/*";
        public static final String TOPIC_WINDOWS = "org/eclipse/e4/ui/model/advanced/Perspective/windows/*";
        public static final String TOPIC_TRIMBARS = "org/eclipse/e4/ui/model/advanced/Perspective/trimBars/*";
        public static final String WINDOWS = "windows";
    }

    public static interface Placeholder {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/advanced/Placeholder";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/advanced/Placeholder/*";
        public static final String TOPIC_CLOSEABLE = "org/eclipse/e4/ui/model/advanced/Placeholder/closeable/*";
        public static final String TOPIC_REF = "org/eclipse/e4/ui/model/advanced/Placeholder/ref/*";
        public static final String CLOSEABLE = "closeable";
        public static final String REF = "ref";
    }

    public static interface RenderedMenu {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/RenderedMenu";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/RenderedMenu/*";
        public static final String TOPIC_CONTRIBUTIONMANAGER = "org/eclipse/e4/ui/model/menu/RenderedMenu/contributionManager/*";
        public static final String CONTRIBUTIONMANAGER = "contributionManager";
    }

    public static interface RenderedMenuItem {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/RenderedMenuItem";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/RenderedMenuItem/*";
        public static final String TOPIC_CONTRIBUTIONITEM = "org/eclipse/e4/ui/model/menu/RenderedMenuItem/contributionItem/*";
        public static final String CONTRIBUTIONITEM = "contributionItem";
    }

    public static interface RenderedToolBar {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/RenderedToolBar";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/RenderedToolBar/*";
        public static final String TOPIC_CONTRIBUTIONMANAGER = "org/eclipse/e4/ui/model/menu/RenderedToolBar/contributionManager/*";
        public static final String CONTRIBUTIONMANAGER = "contributionManager";
    }

    public static interface SnippetContainer {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/SnippetContainer";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/SnippetContainer/*";
        public static final String TOPIC_SNIPPETS = "org/eclipse/e4/ui/model/ui/SnippetContainer/snippets/*";
        public static final String SNIPPETS = "snippets";
    }

    public static interface StringToObjectMap {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/application/StringToObjectMap";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/application/StringToObjectMap/*";
        public static final String TOPIC_KEY = "org/eclipse/e4/ui/model/application/StringToObjectMap/key/*";
        public static final String TOPIC_VALUE = "org/eclipse/e4/ui/model/application/StringToObjectMap/value/*";
        public static final String KEY = "key";
        public static final String VALUE = "value";
    }

    public static interface StringToStringMap {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/application/StringToStringMap";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/application/StringToStringMap/*";
        public static final String TOPIC_KEY = "org/eclipse/e4/ui/model/application/StringToStringMap/key/*";
        public static final String TOPIC_VALUE = "org/eclipse/e4/ui/model/application/StringToStringMap/value/*";
        public static final String KEY = "key";
        public static final String VALUE = "value";
    }

    public static interface ToolBarContribution {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/ToolBarContribution";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/ToolBarContribution/*";
        public static final String TOPIC_PARENTID = "org/eclipse/e4/ui/model/menu/ToolBarContribution/parentId/*";
        public static final String TOPIC_POSITIONINPARENT = "org/eclipse/e4/ui/model/menu/ToolBarContribution/positionInParent/*";
        public static final String PARENTID = "parentId";
        public static final String POSITIONINPARENT = "positionInParent";
    }

    public static interface ToolBarContributions {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/ToolBarContributions";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/ToolBarContributions/*";
        public static final String TOPIC_TOOLBARCONTRIBUTIONS = "org/eclipse/e4/ui/model/menu/ToolBarContributions/toolBarContributions/*";
        public static final String TOOLBARCONTRIBUTIONS = "toolBarContributions";
    }

    public static interface ToolItem {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/ToolItem";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/ToolItem/*";
        public static final String TOPIC_MENU = "org/eclipse/e4/ui/model/menu/ToolItem/menu/*";
        public static final String MENU = "menu";
    }

    public static interface TrimBar {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/basic/TrimBar";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/basic/TrimBar/*";
        public static final String TOPIC_PENDINGCLEANUP = "org/eclipse/e4/ui/model/basic/TrimBar/pendingCleanup/*";
        public static final String PENDINGCLEANUP = "pendingCleanup";
    }

    public static interface TrimContribution {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/TrimContribution";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/TrimContribution/*";
        public static final String TOPIC_PARENTID = "org/eclipse/e4/ui/model/menu/TrimContribution/parentId/*";
        public static final String TOPIC_POSITIONINPARENT = "org/eclipse/e4/ui/model/menu/TrimContribution/positionInParent/*";
        public static final String PARENTID = "parentId";
        public static final String POSITIONINPARENT = "positionInParent";
    }

    public static interface TrimContributions {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/menu/TrimContributions";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/menu/TrimContributions/*";
        public static final String TOPIC_TRIMCONTRIBUTIONS = "org/eclipse/e4/ui/model/menu/TrimContributions/trimContributions/*";
        public static final String TRIMCONTRIBUTIONS = "trimContributions";
    }

    public static interface TrimmedWindow {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/basic/TrimmedWindow";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/basic/TrimmedWindow/*";
        public static final String TOPIC_TRIMBARS = "org/eclipse/e4/ui/model/basic/TrimmedWindow/trimBars/*";
        public static final String TRIMBARS = "trimBars";
    }

    public static interface UIElement {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/UIElement";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/UIElement/*";
        public static final String TOPIC_ACCESSIBILITYPHRASE = "org/eclipse/e4/ui/model/ui/UIElement/accessibilityPhrase/*";
        public static final String TOPIC_CONTAINERDATA = "org/eclipse/e4/ui/model/ui/UIElement/containerData/*";
        public static final String TOPIC_CURSHAREDREF = "org/eclipse/e4/ui/model/ui/UIElement/curSharedRef/*";
        public static final String TOPIC_ONTOP = "org/eclipse/e4/ui/model/ui/UIElement/onTop/*";
        public static final String TOPIC_PARENT = "org/eclipse/e4/ui/model/ui/UIElement/parent/*";
        public static final String TOPIC_RENDERER = "org/eclipse/e4/ui/model/ui/UIElement/renderer/*";
        public static final String TOPIC_TOBERENDERED = "org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*";
        public static final String TOPIC_VISIBLE = "org/eclipse/e4/ui/model/ui/UIElement/visible/*";
        public static final String TOPIC_VISIBLEWHEN = "org/eclipse/e4/ui/model/ui/UIElement/visibleWhen/*";
        public static final String TOPIC_WIDGET = "org/eclipse/e4/ui/model/ui/UIElement/widget/*";
        public static final String TOPIC_LOCALIZED_ACCESSIBILITYPHRASE = "org/eclipse/e4/ui/model/ui/UIElement/localizedAccessibilityPhrase/*";
        public static final String ACCESSIBILITYPHRASE = "accessibilityPhrase";
        public static final String CONTAINERDATA = "containerData";
        public static final String CURSHAREDREF = "curSharedRef";
        public static final String ONTOP = "onTop";
        public static final String PARENT = "parent";
        public static final String RENDERER = "renderer";
        public static final String TOBERENDERED = "toBeRendered";
        public static final String VISIBLE = "visible";
        public static final String VISIBLEWHEN = "visibleWhen";
        public static final String WIDGET = "widget";
        public static final String LOCALIZED_ACCESSIBILITYPHRASE = "localizedAccessibilityPhrase";
    }

    public static interface UILabel {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/ui/UILabel";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/ui/UILabel/*";
        public static final String TOPIC_ICONURI = "org/eclipse/e4/ui/model/ui/UILabel/iconURI/*";
        public static final String TOPIC_LABEL = "org/eclipse/e4/ui/model/ui/UILabel/label/*";
        public static final String TOPIC_TOOLTIP = "org/eclipse/e4/ui/model/ui/UILabel/tooltip/*";
        public static final String TOPIC_LOCALIZED_LABEL = "org/eclipse/e4/ui/model/ui/UILabel/localizedLabel/*";
        public static final String TOPIC_LOCALIZED_TOOLTIP = "org/eclipse/e4/ui/model/ui/UILabel/localizedTooltip/*";
        public static final String ICONURI = "iconURI";
        public static final String LABEL = "label";
        public static final String TOOLTIP = "tooltip";
        public static final String LOCALIZED_LABEL = "localizedLabel";
        public static final String LOCALIZED_TOOLTIP = "localizedTooltip";
    }

    public static interface UILifeCycle {
        public static final String TOPIC = "org/eclipse/e4/ui/LifeCycle";
        public static final String BRINGTOTOP = "org/eclipse/e4/ui/LifeCycle/bringToTop";
        public static final String ACTIVATE = "org/eclipse/e4/ui/LifeCycle/activate";
        public static final String PERSPECTIVE_SAVED = "org/eclipse/e4/ui/LifeCycle/perpSaved";
        public static final String PERSPECTIVE_OPENED = "org/eclipse/e4/ui/LifeCycle/perspOpened";
        public static final String PERSPECTIVE_RESET = "org/eclipse/e4/ui/LifeCycle/perspReset";
        public static final String APP_STARTUP_COMPLETE = "org/eclipse/e4/ui/LifeCycle/appStartupComplete";
        public static final String APP_SHUTDOWN_STARTED = "org/eclipse/e4/ui/LifeCycle/appShutdownStarted";
        public static final String THEME_CHANGED = "org/eclipse/e4/ui/LifeCycle/themeChanged";
        public static final String THEME_DEFINITION_CHANGED = "org/eclipse/e4/ui/LifeCycle/themeDefinitionChanged";
    }

    public static interface Window {
        @Deprecated
        public static final String TOPIC = "org/eclipse/e4/ui/model/basic/Window";
        public static final String TOPIC_ALL = "org/eclipse/e4/ui/model/basic/Window/*";
        public static final String TOPIC_HEIGHT = "org/eclipse/e4/ui/model/basic/Window/height/*";
        public static final String TOPIC_MAINMENU = "org/eclipse/e4/ui/model/basic/Window/mainMenu/*";
        public static final String TOPIC_SHAREDELEMENTS = "org/eclipse/e4/ui/model/basic/Window/sharedElements/*";
        public static final String TOPIC_WIDTH = "org/eclipse/e4/ui/model/basic/Window/width/*";
        public static final String TOPIC_WINDOWS = "org/eclipse/e4/ui/model/basic/Window/windows/*";
        public static final String TOPIC_X = "org/eclipse/e4/ui/model/basic/Window/x/*";
        public static final String TOPIC_Y = "org/eclipse/e4/ui/model/basic/Window/y/*";
        public static final String HEIGHT = "height";
        public static final String MAINMENU = "mainMenu";
        public static final String SHAREDELEMENTS = "sharedElements";
        public static final String WIDTH = "width";
        public static final String WINDOWS = "windows";
        public static final String X = "x";
        public static final String Y = "y";
    }
}

