/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.AbstractPublishApplicationOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public abstract class ApplicationOperation
extends AbstractPublishApplicationOperation {
    private DeploymentConfiguration configuration;
    private boolean clearConsole = true;

    protected ApplicationOperation(CloudFoundryServerBehaviour behaviour, IModule[] modules, boolean clearConsole) {
        super(behaviour, modules);
        this.clearConsole = clearConsole;
    }

    protected DeploymentConfiguration getDeploymentConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.getDefaultDeploymentConfiguration();
        }
        return this.configuration;
    }

    @Override
    protected void doApplicationOperation(IProgressMonitor monitor) throws CoreException {
        if (this.getModules().length != 1) {
            return;
        }
        CloudFoundryApplicationModule appModule = this.getOrCreateCloudApplicationModule(this.getModules());
        try {
            CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
            CloudFoundryPlugin.getCallback().stopApplicationConsole(appModule, cloudServer);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.configuration = this.prepareForDeployment(appModule, (IProgressMonitor)subMonitor.newChild(20));
            appModule.validateAndUpdateStatus();
            if (this.clearConsole) {
                this.getBehaviour().clearAndPrintlnConsole(appModule, NLS.bind((String)Messages.CONSOLE_PREPARING_APP, (Object)appModule.getDeployedApplicationName()));
            } else {
                this.getBehaviour().printlnToConsole(appModule, NLS.bind((String)Messages.CONSOLE_PREPARING_APP, (Object)appModule.getDeployedApplicationName()));
            }
            this.performDeployment(appModule, (IProgressMonitor)subMonitor.newChild(60));
            appModule = this.getBehaviour().updateModuleWithAllCloudInfo(appModule.getDeployedApplicationName(), (IProgressMonitor)subMonitor.newChild(20));
        }
        catch (CoreException ce) {
            this.getBehaviour().printErrorlnToConsole(appModule, ce.getMessage());
            throw ce;
        }
    }

    protected DeploymentConfiguration prepareForDeployment(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return null;
    }

    protected abstract DeploymentConfiguration getDefaultDeploymentConfiguration();

    protected abstract void performDeployment(CloudFoundryApplicationModule var1, IProgressMonitor var2) throws CoreException;
}

