/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.provisional.IMemoryRenderingViewportProvider;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlock;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlockRetrieval;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.debug.ui.memory.traditional.AbstractPane;
import org.eclipse.cdt.debug.ui.memory.traditional.CopyAddressAction;
import org.eclipse.cdt.debug.ui.memory.traditional.CopyAllAction;
import org.eclipse.cdt.debug.ui.memory.traditional.CopyBinaryAction;
import org.eclipse.cdt.debug.ui.memory.traditional.CopyDefaultAction;
import org.eclipse.cdt.debug.ui.memory.traditional.CopyTextAction;
import org.eclipse.cdt.debug.ui.memory.traditional.IMemorySelection;
import org.eclipse.cdt.debug.ui.memory.traditional.IMemorySpacePreferencesHelper;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.RenderingAddressInfo;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalMemoryRenderingFactory;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.IMemoryBlockConnection;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressAction;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.UIJob;

public class TraditionalRendering
extends AbstractMemoryRendering
implements IRepositionableMemoryRendering,
IResettableMemoryRendering,
IMemoryRenderingViewportProvider,
IModelChangedListener {
    protected Rendering fRendering;
    protected Action displayEndianBigAction;
    protected Action displayEndianLittleAction;
    private IWorkbenchAdapter fWorkbenchAdapter;
    private IMemoryBlockConnection fConnection;
    private String fMemorySpaceId;
    private static final int MAX_MENU_COLUMN_COUNT = 8;
    private IMemorySpacePreferencesHelper fMemSpacePreferenceHelper;
    private BigInteger fBigBaseAddress;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;
    private int fAddressableSize;
    private int fAddressSize;
    private IModelProxy fModel;
    private static final String ID_GO_TO_ADDRESS_COMMAND = "org.eclipse.debug.ui.command.gotoaddress";
    private AbstractHandler fGoToAddressHandler;
    private IAction fSavedActionHandler;
    private Color colorBackground;
    private Color colorChanged;
    private Color[] colorsChanged = null;
    private Color colorEdit;
    private Color colorSelection;
    private Color colorText;
    private Color colorTextAlternate;
    private Map<Integer, Font> fonts = new HashMap<Integer, Font>(3);

    public TraditionalRendering(String id) {
        super(id);
        JFaceResources.getFontRegistry().addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.debug.ui.MemoryViewTableFont")) {
                    TraditionalRendering.this.fRendering.handleFontPreferenceChange(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
                }
            }
        });
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IMemoryRendering sourceRendering = (IMemoryRendering)event.getSource();
                if (!sourceRendering.getMemoryBlock().equals(TraditionalRendering.this.getMemoryBlock())) {
                    return;
                }
                Object address = event.getNewValue();
                if (event.getProperty().equals("selectedAddress") && address instanceof BigInteger) {
                    TraditionalRendering.this.fRendering.ensureVisible((BigInteger)address);
                }
            }
        });
        TraditionalRenderingPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TraditionalRendering.this.disposeColors();
                TraditionalRendering.this.allocateColors();
                TraditionalRendering.this.applyPreferences();
            }
        });
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.debug.ui.memory.paddedStr") && TraditionalRendering.this.fRendering != null) {
                    TraditionalRendering.this.setRenderingPadding((String)event.getNewValue());
                    TraditionalRendering.this.fRendering.redrawPanes();
                }
            }
        });
    }

    private void setRenderingPadding(String padding) {
        if (padding == null || padding.length() == 0) {
            padding = "?";
        }
        this.fRendering.setPaddingString(padding);
    }

    protected void logError(String message, Exception e) {
        Status status = new Status(4, this.getRenderingId(), 5013, message, (Throwable)e);
        TraditionalRenderingPlugin.getDefault().getLog().log((IStatus)status);
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        int flags = delta.getFlags();
        if ((flags & 0x800) != 0) {
            this.fRendering.handleSuspend(false);
        }
        this.fRendering.handleChange();
    }

    public void dispose() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TraditionalRendering.this.fModel != null) {
                    TraditionalRendering.this.fModel.removeModelChangedListener((IModelChangedListener)TraditionalRendering.this);
                    TraditionalRendering.this.fModel.dispose();
                }
            }
        });
        if (this.fRendering != null) {
            this.fRendering.dispose();
        }
        this.disposeColors();
        this.disposeFonts();
        super.dispose();
    }

    public void init(final IMemoryRenderingContainer container, final IMemoryBlock block) {
        BigInteger endAddress;
        IModelProxyFactory factory;
        super.init(container, block);
        this.fMemSpacePreferenceHelper = TraditionalMemoryRenderingFactory.getMemorySpacesPreferencesHelper();
        if (block instanceof IMemorySpaceAwareMemoryBlock) {
            String id;
            IMemorySpaceAwareMemoryBlock memBlock = (IMemorySpaceAwareMemoryBlock)block;
            this.fMemorySpaceId = id = memBlock.getMemorySpaceID();
        }
        if (block instanceof IMemorySpaceAwareMemoryBlock) {
            IMemoryBlockRetrieval retrieval = ((IMemorySpaceAwareMemoryBlock)block).getMemoryBlockRetrieval();
            ((IMemorySpaceAwareMemoryBlockRetrieval)retrieval).getMemorySpaces((Object)block, (IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest)new GetMemorySpacesRequest(this){

                public void done() {
                    final String[] spaces = this.isSuccess() ? this.getMemorySpaces() : new String[]{};
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            fMemSpacePreferenceHelper.updateMemorySpaces(spaces);
                        }
                    });
                }
            });
        }
        if ((factory = (IModelProxyFactory)DebugPlugin.getAdapter((Object)block, IModelProxyFactory.class)) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IMemoryRenderingSite site = container.getMemoryRenderingSite();
                    MemoryViewPresentationContext context = new MemoryViewPresentationContext(site, container, (IMemoryRendering)TraditionalRendering.this);
                    TraditionalRendering.this.fModel = factory.createModelProxy((Object)block, (IPresentationContext)context);
                    if (TraditionalRendering.this.fModel != null) {
                        TraditionalRendering.this.fModel.installed(null);
                        TraditionalRendering.this.fModel.addModelChangedListener((IModelChangedListener)TraditionalRendering.this);
                    }
                }
            });
        }
        try {
            this.fBigBaseAddress = ((IMemoryBlockExtension)block).getBigBaseAddress();
        }
        catch (DebugException de) {
            this.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_RETRIEVE_BASE_ADDRESS"), (Exception)((Object)de));
        }
        try {
            this.fAddressableSize = ((IMemoryBlockExtension)block).getAddressableSize();
        }
        catch (DebugException de) {
            this.fAddressableSize = 1;
        }
        try {
            this.fStartAddress = ((IMemoryBlockExtension)block).getMemoryBlockStartAddress();
        }
        catch (DebugException de) {
            this.fStartAddress = null;
            this.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_RETRIEVE_START_ADDRESS"), (Exception)((Object)de));
        }
        try {
            this.fAddressSize = ((IMemoryBlockExtension)block).getAddressSize();
        }
        catch (DebugException e) {
            this.fAddressSize = 0;
        }
        try {
            endAddress = ((IMemoryBlockExtension)block).getMemoryBlockEndAddress();
            if (endAddress != null) {
                this.fEndAddress = endAddress;
            }
        }
        catch (DebugException e) {
            this.fEndAddress = null;
        }
        if (this.fEndAddress == null) {
            int addressSize;
            try {
                addressSize = ((IMemoryBlockExtension)block).getAddressSize();
            }
            catch (DebugException e) {
                addressSize = 4;
            }
            endAddress = BigInteger.valueOf(2L);
            endAddress = endAddress.pow(addressSize * 8);
            this.fEndAddress = endAddress = endAddress.subtract(BigInteger.valueOf(1L));
        }
        if (this.fEndAddress == null) {
            this.fEndAddress = BigInteger.valueOf(Integer.MAX_VALUE);
        }
    }

    public BigInteger getBigBaseAddress() {
        return this.fBigBaseAddress;
    }

    public BigInteger getMemoryBlockStartAddress() {
        return this.fStartAddress;
    }

    public BigInteger getMemoryBlockEndAddress() {
        return this.fEndAddress;
    }

    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }

    public Control createControl(Composite parent) {
        this.allocateColors();
        this.fRendering = new RenderingAddressInfo(parent, this);
        this.applyPreferences();
        this.createMenus();
        return this.fRendering;
    }

    public void activated() {
        IActionBars actionBars;
        super.activated();
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (commandSupport != null) {
            Command gotoCommand = commandSupport.getCommand(ID_GO_TO_ADDRESS_COMMAND);
            if (this.fGoToAddressHandler == null) {
                this.fGoToAddressHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent event) throws ExecutionException {
                        return null;
                    }
                };
            }
            gotoCommand.setHandler((IHandler)this.fGoToAddressHandler);
        }
        CopyDefaultAction defaultAction = new CopyDefaultAction(this.fRendering, 1);
        IWorkbenchPartSite site = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSite();
        if (site instanceof IViewSite && (actionBars = ((IViewSite)site).getActionBars()) != null) {
            this.fSavedActionHandler = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)defaultAction);
        }
    }

    public void deactivated() {
        IActionBars actionBars;
        IWorkbenchPartSite site;
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (commandSupport != null) {
            Command command = commandSupport.getCommand(ID_GO_TO_ADDRESS_COMMAND);
            command.setHandler(null);
        }
        if ((site = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSite()) instanceof IViewSite && (actionBars = ((IViewSite)site).getActionBars()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.fSavedActionHandler);
        }
        super.deactivated();
    }

    public void setSelection(BigInteger start, BigInteger end) {
        this.fRendering.getSelection().setStart(start, start);
        this.fRendering.getSelection().setEnd(end, end);
    }

    public void gotoAddress(BigInteger address) {
        this.fRendering.gotoAddress(address);
    }

    public void updateRenderingLabels() {
        UIJob job = new UIJob("updateLabels"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String fLabel = TraditionalRendering.this.getLabel();
                TraditionalRendering.this.firePropertyChangedEvent(new PropertyChangeEvent((Object)TraditionalRendering.this, "org.eclipse.jface.text", null, (Object)fLabel));
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void allocateColors() {
        String key;
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        this.colorBackground = null;
        if (this.fMemorySpaceId != null && store.getString(key = this.fMemSpacePreferenceHelper.getMemorySpaceKey(this.fMemorySpaceId)) != "") {
            this.colorBackground = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)key));
        }
        if (this.colorBackground == null) {
            this.colorBackground = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorBackground"));
        }
        this.colorChanged = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorChanged"));
        this.colorEdit = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorEdit"));
        this.colorSelection = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorSelection"));
        this.colorText = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorText"));
        Color textColor = this.getColorText();
        int red = textColor.getRed();
        int green = textColor.getGreen();
        int blue = textColor.getBlue();
        float scale = store.getInt("memoryColorScaleTextAlternate");
        red = (int)Math.min((float)red + (float)((255 - red) / 10) * scale, 255.0f);
        green = (int)Math.min((float)green + (float)((255 - green) / 10) * scale, 255.0f);
        blue = (int)Math.min((float)blue + (float)((255 - blue) / 10) * scale, 255.0f);
        this.colorTextAlternate = new Color((Device)Display.getDefault(), new RGB(red, green, blue));
    }

    public void disposeColors() {
        if (this.colorBackground != null) {
            this.colorBackground.dispose();
        }
        this.colorBackground = null;
        if (this.colorChanged != null) {
            this.colorChanged.dispose();
        }
        this.colorChanged = null;
        if (this.colorEdit != null) {
            this.colorEdit.dispose();
        }
        this.colorEdit = null;
        if (this.colorSelection != null) {
            this.colorSelection.dispose();
        }
        this.colorSelection = null;
        if (this.colorText != null) {
            this.colorText.dispose();
        }
        this.colorText = null;
        if (this.colorTextAlternate != null) {
            this.colorTextAlternate.dispose();
        }
        this.colorTextAlternate = null;
        this.disposeChangedColors();
    }

    public void disposeFonts() {
        for (Font font : this.fonts.values()) {
            font.dispose();
        }
    }

    public void applyPreferences() {
        if (this.fRendering != null && !this.fRendering.isDisposed()) {
            IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
            this.fRendering.setHistoryDepth(store.getInt("memoryHistoryTrailsCount"));
            this.fRendering.setBackground(this.getColorBackground());
            AbstractPane[] panes = this.fRendering.getRenderingPanes();
            int i = 0;
            while (i < panes.length) {
                panes[i].setBackground(this.getColorBackground());
                ++i;
            }
            this.setRenderingPadding(TraditionalRenderingPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr"));
            if (store.getBoolean("memCrossReferenceInfo")) {
                this.fRendering.resolveAddressInfoForCurrentSelection();
            }
            this.fRendering.redrawPanes();
        }
    }

    private Font makeFont(Font font, String boldKey, String italicKey) {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        int style = 0;
        if (store.getBoolean(boldKey)) {
            style |= 1;
        }
        if (store.getBoolean(italicKey)) {
            style |= 2;
        }
        if (style == 0) {
            return font;
        }
        Font modified = this.fonts.get(style);
        if (modified == null) {
            FontData fontData = font.getFontData()[0];
            modified = new Font(font.getDevice(), fontData.getName(), fontData.getHeight(), fontData.getStyle() | style);
            this.fonts.put(style, modified);
        }
        return modified;
    }

    public Font getFontChanged(Font font) {
        return this.makeFont(font, "memoryColorChanged.bold", "memoryColorChanged.italic");
    }

    public Font getFontEdit(Font font) {
        return this.makeFont(font, "memoryColorEdit.bold", "memoryColorEdit.italic");
    }

    public boolean getBoxChanged() {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("memoryColorChanged.box");
    }

    public boolean getBoxEdit() {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("memoryColorEdit.box");
    }

    public Color getColorBackground() {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("memUseGlobalBackground")) {
            return Display.getDefault().getSystemColor(25);
        }
        return this.colorBackground;
    }

    public Color getColorChanged() {
        return this.colorChanged;
    }

    private void disposeChangedColors() {
        if (this.colorsChanged != null) {
            int i = 0;
            while (i < this.colorsChanged.length) {
                this.colorsChanged[i].dispose();
                ++i;
            }
        }
        this.colorsChanged = null;
    }

    public Color[] getColorsChanged() {
        if (this.colorsChanged != null && this.colorsChanged.length != this.fRendering.getHistoryDepth()) {
            this.disposeChangedColors();
        }
        if (this.colorsChanged == null) {
            this.colorsChanged = new Color[this.fRendering.getHistoryDepth()];
            this.colorsChanged[0] = this.colorChanged;
            int shades = this.fRendering.getHistoryDepth() + 4;
            int red = (255 - this.colorChanged.getRed()) / shades;
            int green = (255 - this.colorChanged.getGreen()) / shades;
            int blue = (255 - this.colorChanged.getBlue()) / shades;
            int i = 1;
            while (i < this.fRendering.getHistoryDepth()) {
                this.colorsChanged[i] = new Color(this.colorChanged.getDevice(), this.colorChanged.getRed() + (shades - i) * red, this.colorChanged.getGreen() + (shades - i) * green, this.colorChanged.getBlue() + (shades - i) * blue);
                ++i;
            }
        }
        return this.colorsChanged;
    }

    public Color getColorEdit() {
        return this.colorEdit;
    }

    public Color getColorSelection() {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("memUseGlobalSelection")) {
            return Display.getDefault().getSystemColor(26);
        }
        return this.colorSelection;
    }

    public Color getColorText() {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("memUseGlobalText")) {
            return Display.getDefault().getSystemColor(24);
        }
        return this.colorText;
    }

    public Color getColorTextAlternate() {
        return this.colorTextAlternate;
    }

    @Deprecated
    public boolean isShowCrossRefInfoGlobalPref() {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("memCrossReferenceInfo");
    }

    public void createMenus() {
        AbstractPane[] renderingControls = this.fRendering.getRenderingPanes();
        int i = 0;
        while (i < renderingControls.length) {
            super.createPopupMenu((Control)renderingControls[i]);
            ++i;
        }
        super.createPopupMenu((Control)this.fRendering);
        final CopyBinaryAction copyBinaryAction = new CopyBinaryAction(this.fRendering);
        final CopyTextAction copyTextAction = new CopyTextAction(this.fRendering);
        final CopyAddressAction copyAddressAction = new CopyAddressAction(this.fRendering);
        final CopyAllAction copyAllAction = new CopyAllAction(this.fRendering);
        GoToAddressAction goToAddressAction = new GoToAddressAction(this.getMemoryRenderingContainer(), (IRepositionableMemoryRendering)this);
        final Action gotoBaseAddressAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.RESET_TO_BASE_ADDRESS")){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).TraditionalRendering.this.fRendering.gotoAddress((this).TraditionalRendering.this.fRendering.fBaseAddress);
                    }
                });
            }
        };
        Action refreshAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.REFRESH")){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Method m = (this).TraditionalRendering.this.fRendering.getMemoryBlock().getClass().getMethod("clearCache", new Class[0]);
                            if (m != null) {
                                m.invoke((Object)(this).TraditionalRendering.this.fRendering.getMemoryBlock(), new Object[0]);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        (this).TraditionalRendering.this.fRendering.refresh();
                    }
                });
            }
        };
        final Action displayAddressPaneAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.ADDRESS"), 2){

            public void run() {
                TraditionalRendering.this.fRendering.setPaneVisible(1, this.isChecked());
            }
        };
        displayAddressPaneAction.setChecked(this.fRendering.getPaneVisible(1));
        final Action displayBinaryPaneAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.BINARY"), 2){

            public void run() {
                TraditionalRendering.this.fRendering.setPaneVisible(2, this.isChecked());
            }
        };
        displayBinaryPaneAction.setChecked(this.fRendering.getPaneVisible(2));
        final Action displayTextPaneAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.TEXT"), 2){

            public void run() {
                TraditionalRendering.this.fRendering.setPaneVisible(3, this.isChecked());
            }
        };
        displayTextPaneAction.setChecked(this.fRendering.getPaneVisible(3));
        final Action displaySize1BytesAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.1_BYTE"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setBytesPerColumn(1);
            }
        };
        displaySize1BytesAction.setChecked(this.fRendering.getBytesPerColumn() == 1);
        final Action displaySize2BytesAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.2_BYTES"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setBytesPerColumn(2);
            }
        };
        displaySize2BytesAction.setChecked(this.fRendering.getBytesPerColumn() == 2);
        final Action displaySize4BytesAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.4_BYTES"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setBytesPerColumn(4);
            }
        };
        displaySize4BytesAction.setChecked(this.fRendering.getBytesPerColumn() == 4);
        final Action displaySize8BytesAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.8_BYTES"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setBytesPerColumn(8);
            }
        };
        displaySize8BytesAction.setChecked(this.fRendering.getBytesPerColumn() == 8);
        final Action displayCharactersISO8859Action = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.ISO-8859-1"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setTextMode(1);
            }
        };
        displayCharactersISO8859Action.setChecked(this.fRendering.getTextMode() == 1);
        final Action displayCharactersUSASCIIAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.USASCII"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setTextMode(2);
            }
        };
        displayCharactersUSASCIIAction.setChecked(this.fRendering.getTextMode() == 2);
        final Action displayCharactersUTF8Action = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.UTF8"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setTextMode(3);
            }
        };
        displayCharactersUTF8Action.setChecked(this.fRendering.getTextMode() == 3);
        this.displayEndianBigAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.BIG"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setDisplayLittleEndian(false);
            }
        };
        this.displayEndianBigAction.setChecked(!this.fRendering.isTargetLittleEndian());
        this.displayEndianLittleAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.LITTLE"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setDisplayLittleEndian(true);
            }
        };
        this.displayEndianLittleAction.setChecked(this.fRendering.isTargetLittleEndian());
        final Action displayRadixHexAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.HEX"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setRadix(1);
            }
        };
        displayRadixHexAction.setChecked(this.fRendering.getRadix() == 1);
        final Action displayRadixDecSignedAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.DECIMAL_SIGNED"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setRadix(2);
            }
        };
        displayRadixDecSignedAction.setChecked(this.fRendering.getRadix() == 2);
        final Action displayRadixDecUnsignedAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.DECIMAL_UNSIGNED"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setRadix(3);
            }
        };
        displayRadixDecUnsignedAction.setChecked(this.fRendering.getRadix() == 3);
        final Action displayRadixOctAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.OCTAL"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setRadix(4);
            }
        };
        displayRadixOctAction.setChecked(this.fRendering.getRadix() == 4);
        final Action displayRadixBinAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.BINARY"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setRadix(5);
            }
        };
        displayRadixBinAction.setChecked(this.fRendering.getRadix() == 5);
        final Action displayColumnCountAuto = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.COLUMN_COUNT_AUTO"), 8){

            public void run() {
                TraditionalRendering.this.fRendering.setColumnsSetting(0);
            }
        };
        displayColumnCountAuto.setChecked(this.fRendering.getColumnsSetting() == 0);
        final Action[] displayColumnCounts = new Action[8];
        int i2 = 0;
        int j = 1;
        while (i2 < 8) {
            final int finali = j;
            displayColumnCounts[i2] = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.COLUMN_COUNT_" + finali), 8){

                public void run() {
                    TraditionalRendering.this.fRendering.setColumnsSetting(finali);
                }
            };
            displayColumnCounts[i2].setChecked(this.fRendering.getColumnsSetting() == finali);
            ++i2;
            j *= 2;
        }
        final Action displayColumnCountCustomValue = new Action("", 8){

            public void run() {
            }
        };
        final Action displayColumnCountCustom = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.COLUMN_COUNT_CUSTOM"), 8){

            public void run() {
                int newColumnCount;
                block11: {
                    InputDialog inputDialog = new InputDialog(TraditionalRendering.this.fRendering.getShell(), "Set Column Count", "Please enter column count", "", new IInputValidator(){

                        public String isValid(String input) {
                            int i;
                            block4: {
                                try {
                                    i = Integer.parseInt(input);
                                    if (i > 0) break block4;
                                    return "Please enter a positive integer";
                                }
                                catch (NumberFormatException x) {
                                    return "Please enter a positive integer";
                                }
                            }
                            if (i > 200) {
                                return "Please enter a positive integer not greater than 200";
                            }
                            return null;
                        }
                    });
                    if (inputDialog.open() != 0) {
                        this.setChecked(false);
                        int currentColumnSetting = TraditionalRendering.this.fRendering.getColumnsSetting();
                        if (currentColumnSetting == 0) {
                            displayColumnCountAuto.setChecked(true);
                        } else {
                            boolean currentCountIsCustom = true;
                            int i = 0;
                            int j = 1;
                            while (i < 8 && currentCountIsCustom) {
                                boolean bl = currentCountIsCustom = j != TraditionalRendering.this.fRendering.getColumnsSetting();
                                if (j == TraditionalRendering.this.fRendering.getColumnsSetting()) {
                                    displayColumnCounts[i].setChecked(true);
                                }
                                ++i;
                                j *= 2;
                            }
                            if (currentCountIsCustom) {
                                displayColumnCountCustomValue.setChecked(true);
                            }
                        }
                        return;
                    }
                    newColumnCount = -1;
                    try {
                        newColumnCount = Integer.parseInt(inputDialog.getValue());
                    }
                    catch (NumberFormatException x) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError();
                    }
                }
                boolean customIsOneOfStandardListChoices = false;
                int i = 0;
                int j = 1;
                while (i < 8) {
                    if (newColumnCount == j) {
                        customIsOneOfStandardListChoices = true;
                        TraditionalRendering.this.fRendering.setColumnsSetting(newColumnCount);
                        this.setChecked(false);
                        displayColumnCountCustomValue.setChecked(false);
                        displayColumnCounts[i].setChecked(true);
                        break;
                    }
                    ++i;
                    j *= 2;
                }
                if (!customIsOneOfStandardListChoices) {
                    TraditionalRendering.this.fRendering.setColumnsSetting(newColumnCount);
                    this.setChecked(false);
                    displayColumnCountCustomValue.setChecked(true);
                    displayColumnCountCustomValue.setText(Integer.valueOf(TraditionalRendering.this.fRendering.getColumnsSetting()).toString());
                }
            }
        };
        this.getPopupMenuManager().addMenuListener(new IMenuListener((IAction)goToAddressAction, refreshAction){
            private final /* synthetic */ IAction val$goToAddressAction;
            private final /* synthetic */ Action val$refreshAction;
            {
                this.val$goToAddressAction = iAction;
                this.val$refreshAction = action20;
            }

            public void menuAboutToShow(IMenuManager manager) {
                Action[] dynamicActions;
                manager.add((IContributionItem)new Separator());
                MenuManager sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.PANES"));
                sub.add((IAction)displayAddressPaneAction);
                sub.add((IAction)displayBinaryPaneAction);
                sub.add((IAction)displayTextPaneAction);
                manager.add((IContributionItem)sub);
                if (TraditionalRendering.this.fRendering.isShowCrossReferenceInfo() && (dynamicActions = TraditionalRendering.this.fRendering.getDynamicActions()) != null) {
                    sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRenderingPreferencePage_ShowCrossRefInfo_Label"));
                    Action[] actionArray = dynamicActions;
                    int n = dynamicActions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Action action = actionArray[n2];
                        sub.add((IAction)action);
                        ++n2;
                    }
                    manager.add((IContributionItem)sub);
                }
                sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.ENDIAN"));
                sub.add((IAction)TraditionalRendering.this.displayEndianBigAction);
                sub.add((IAction)TraditionalRendering.this.displayEndianLittleAction);
                manager.add((IContributionItem)sub);
                sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.TEXT"));
                sub.add((IAction)displayCharactersISO8859Action);
                sub.add((IAction)displayCharactersUSASCIIAction);
                sub.add((IAction)displayCharactersUTF8Action);
                manager.add((IContributionItem)sub);
                sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.CELL_SIZE"));
                sub.add((IAction)displaySize1BytesAction);
                sub.add((IAction)displaySize2BytesAction);
                sub.add((IAction)displaySize4BytesAction);
                sub.add((IAction)displaySize8BytesAction);
                manager.add((IContributionItem)sub);
                sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.RADIX"));
                sub.add((IAction)displayRadixHexAction);
                sub.add((IAction)displayRadixDecSignedAction);
                sub.add((IAction)displayRadixDecUnsignedAction);
                sub.add((IAction)displayRadixOctAction);
                sub.add((IAction)displayRadixBinAction);
                manager.add((IContributionItem)sub);
                sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.COLUMN_COUNT"));
                sub.add((IAction)displayColumnCountAuto);
                int i = 0;
                while (i < displayColumnCounts.length) {
                    sub.add((IAction)displayColumnCounts[i]);
                    ++i;
                }
                boolean currentCountIsCustom = TraditionalRendering.this.fRendering.getColumnsSetting() != 0;
                int i2 = 0;
                int j = 1;
                while (i2 < 8 && currentCountIsCustom) {
                    currentCountIsCustom = j != TraditionalRendering.this.fRendering.getColumnsSetting();
                    ++i2;
                    j *= 2;
                }
                if (currentCountIsCustom) {
                    sub.add((IAction)displayColumnCountCustomValue);
                }
                sub.add((IAction)displayColumnCountCustom);
                manager.add((IContributionItem)sub);
                Action updateAlwaysAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.UPDATE_ALWAYS"), 8){

                    public void run() {
                        (this).TraditionalRendering.this.fRendering.setUpdateMode(1);
                    }
                };
                updateAlwaysAction.setChecked(TraditionalRendering.this.fRendering.getUpdateMode() == 1);
                Action updateOnBreakpointAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.UPDATE_ON_BREAKPOINT"), 8){

                    public void run() {
                        (this).TraditionalRendering.this.fRendering.setUpdateMode(2);
                    }
                };
                updateOnBreakpointAction.setChecked(TraditionalRendering.this.fRendering.getUpdateMode() == 2);
                Action updateManualAction = new Action(TraditionalRenderingMessages.getString("TraditionalRendering.UPDATE_MANUAL"), 8){

                    public void run() {
                        (this).TraditionalRendering.this.fRendering.setUpdateMode(3);
                    }
                };
                updateManualAction.setChecked(TraditionalRendering.this.fRendering.getUpdateMode() == 3);
                sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.UPDATEMODE"));
                sub.add((IAction)updateAlwaysAction);
                sub.add((IAction)updateOnBreakpointAction);
                sub.add((IAction)updateManualAction);
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator());
                BigInteger start = TraditionalRendering.this.fRendering.getSelection().getStart();
                BigInteger end = TraditionalRendering.this.fRendering.getSelection().getEnd();
                copyBinaryAction.setEnabled(start != null && end != null);
                copyTextAction.setEnabled(start != null && end != null);
                sub = new MenuManager(TraditionalRenderingMessages.getString("TraditionalRendering.COPY"));
                sub.add((IAction)copyBinaryAction);
                sub.add((IAction)copyTextAction);
                sub.add((IAction)copyAddressAction);
                sub.add((IAction)copyAllAction);
                manager.add((IContributionItem)sub);
                copyBinaryAction.checkStatus();
                copyTextAction.checkStatus();
                copyAddressAction.checkStatus();
                copyAllAction.checkStatus();
                manager.add((IAction)gotoBaseAddressAction);
                manager.add(this.val$goToAddressAction);
                manager.add((IAction)this.val$refreshAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
    }

    public Control getControl() {
        return this.fRendering;
    }

    public BigInteger getSelectedAddress() {
        IMemorySelection selection = this.fRendering.getSelection();
        if (selection == null || selection.getStart() == null) {
            return this.fRendering.getCaretAddress();
        }
        return selection.getStartLow();
    }

    public MemoryByte[] getSelectedAsBytes() {
        try {
            BigInteger startAddr = this.fRendering.getCaretAddress();
            int byteCount = this.fRendering.getBytesPerColumn();
            IMemorySelection selection = this.fRendering.getSelection();
            if (selection != null && selection.getStart() != null) {
                startAddr = this.getSelectedAddress();
                if (selection.getHigh() != null) {
                    byteCount = selection.getHigh().subtract(selection.getLow()).intValue() * this.fRendering.getAddressableSize();
                }
            }
            return this.fRendering.getViewportCache().getBytes(startAddr, byteCount);
        }
        catch (DebugException de) {
            return null;
        }
    }

    public void goToAddress(final BigInteger address) throws DebugException {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TraditionalRendering.this.fRendering.gotoAddress(address);
            }
        });
    }

    protected void setTargetMemoryLittleEndian(boolean littleEndian) {
        this.displayEndianBigAction.setChecked(!littleEndian);
        this.displayEndianLittleAction.setChecked(littleEndian);
        this.fRendering.setDisplayLittleEndian(littleEndian);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            if (this.fWorkbenchAdapter == null) {
                this.fWorkbenchAdapter = new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return new Object[0];
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return null;
                    }

                    public String getLabel(Object o) {
                        return TraditionalRenderingMessages.getString("TraditionalRendering.RENDERING_NAME");
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            return (T)this.fWorkbenchAdapter;
        }
        if (adapter == IMemoryBlockConnection.class) {
            if (this.fConnection == null) {
                this.fConnection = new IMemoryBlockConnection(){

                    public void update() {
                        Display display = TraditionalRenderingPlugin.getDefault().getWorkbench().getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (TraditionalRendering.this.fBigBaseAddress != (this).TraditionalRendering.this.fRendering.getMemoryBlock().getBigBaseAddress()) {
                                        TraditionalRendering.this.fBigBaseAddress = (this).TraditionalRendering.this.fRendering.getMemoryBlock().getBigBaseAddress();
                                        (this).TraditionalRendering.this.fRendering.gotoAddress(TraditionalRendering.this.fBigBaseAddress);
                                    }
                                    (this).TraditionalRendering.this.fRendering.refresh();
                                }
                                catch (DebugException debugException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                };
            }
            return (T)this.fConnection;
        }
        return (T)super.getAdapter(adapter);
    }

    public void resetRendering() throws DebugException {
        this.fRendering.gotoAddress(this.fRendering.fBaseAddress);
    }

    public BigInteger getViewportAddress() {
        return this.fRendering.getViewportStartAddress();
    }

    private class GetMemorySpacesRequest
    extends CRequest
    implements IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest {
        String[] fMemorySpaces;

        private GetMemorySpacesRequest() {
        }

        public String[] getMemorySpaces() {
            return this.fMemorySpaces;
        }

        public void setMemorySpaces(String[] memorySpaceIds) {
            this.fMemorySpaces = memorySpaceIds;
        }
    }
}

