/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;

public class LamiTimeRangeDurationAspect
extends LamiTableEntryAspect {
    private final int fColIndex;

    public LamiTimeRangeDurationAspect(String timeRangeName, int colIndex) {
        super(String.valueOf(timeRangeName) + " (" + Messages.LamiAspect_TimeRangeDuration + ')', "ns");
        this.fColIndex = colIndex;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isTimeStamp() {
        return false;
    }

    @Override
    public boolean isTimeDuration() {
        return true;
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiTimeRange range;
        Long duration;
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiTimeRange && (duration = (range = (LamiTimeRange)data).getDuration()) != null) {
            return String.valueOf(duration);
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(@NonNull LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiTimeRange) {
            LamiTimeRange range = (LamiTimeRange)data;
            return range.getDuration();
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return (o1, o2) -> {
            Number d1 = this.resolveNumber((LamiTableEntry)o1);
            Number d2 = this.resolveNumber((LamiTableEntry)o2);
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return Long.compare(d1.longValue(), d2.longValue());
        };
    }
}

