/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramDescriptionProvider;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class HideDDiagramElementAction
extends Action
implements IObjectActionDelegate,
Disposable {
    private ISelection selection;
    private IWorkbenchPart representationPart;

    public HideDDiagramElementAction() {
    }

    public HideDDiagramElementAction(String text) {
        this(text, DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/categoryHidden.gif"));
    }

    public HideDDiagramElementAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(text);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setActionPart(IWorkbenchPart actionPart) {
        this.representationPart = actionPart;
    }

    public final boolean isEnabled() {
        boolean result = false;
        ISelection currentSelection = this.selection;
        if (this.selection == null) {
            currentSelection = this.getCurrentSelection();
        }
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty()) {
            HashSet<DDiagramElement> ddes = new HashSet<DDiagramElement>();
            for (Object selected : ((IStructuredSelection)currentSelection).toList()) {
                if (selected instanceof IDiagramElementEditPart) {
                    DDiagramElement dDiagramElement;
                    IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)selected;
                    if (!diagramElementEditPart.isActive() || (dDiagramElement = diagramElementEditPart.resolveDiagramElement()) == null) continue;
                    ddes.add(dDiagramElement);
                    continue;
                }
                if (!(selected instanceof DDiagramElement)) continue;
                ddes.add((DDiagramElement)selected);
            }
            if (!ddes.isEmpty()) {
                DDiagram parentDiagram = ((DDiagramElement)ddes.iterator().next()).getParentDiagram();
                Predicate<DDiagramElement> allowsHideReveal = HideDDiagramElementAction.allowsHideReveal(parentDiagram);
                Predicate notDirectlyHidden = dde -> !new DDiagramElementQuery(dde).isHidden();
                return Iterables.all(ddes, (Predicate)Predicates.and(allowsHideReveal, (Predicate)notDirectlyHidden));
            }
        }
        return result;
    }

    private ISelection getCurrentSelection() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
    }

    public void run(IAction action) {
        IStructuredSelection structuredSelection;
        HashSet<Object> minimizedSelection;
        if (this.selection instanceof IStructuredSelection && (minimizedSelection = new HashSet<Object>(Arrays.asList((structuredSelection = (IStructuredSelection)this.selection).toArray()))).size() > 0) {
            Object nextSelected = minimizedSelection.iterator().next();
            if (nextSelected instanceof EditPart) {
                RootEditPart root = ((EditPart)nextSelected).getRoot();
                DDiagramEditor diagramEditor = (DDiagramEditor)((EditPart)nextSelected).getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
                this.runHideCommand(root, diagramEditor, this.partsToSemantic(Arrays.asList(structuredSelection.toArray())));
            } else if (nextSelected instanceof DDiagramElement) {
                HashSet<EObject> eObjectSelection = new HashSet<EObject>();
                for (Object e : minimizedSelection) {
                    if (!(e instanceof EObject)) continue;
                    eObjectSelection.add((EObject)e);
                }
                this.run(eObjectSelection);
            }
        }
    }

    public void run() {
        this.selection = this.getCurrentSelection();
        this.run((IAction)this);
        this.selection = null;
    }

    private void run(Set<EObject> minimizedSelection) {
        if (this.selection instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            DiagramOutlinePage.TreeSelectionWrapper wrapper = (DiagramOutlinePage.TreeSelectionWrapper)this.selection;
            RootEditPart root = wrapper.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)wrapper.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runHideCommand(root, diagramEditor, minimizedSelection);
        }
    }

    private void runHideCommand(RootEditPart root, DDiagramEditor editor, Set<EObject> elements) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)editor.getEditingDomain().getResourceSet());
        IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        Command cmd = emfCommandFactory.buildHideCommand(elements);
        ((TransactionalEditingDomain)editor.getAdapter(EditingDomain.class)).getCommandStack().execute(cmd);
    }

    private Set<EObject> partsToSemantic(List<Object> asList) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (Object obj : asList) {
            IGraphicalEditPart part;
            EObject element;
            if (!(obj instanceof IGraphicalEditPart) || (element = (part = (IGraphicalEditPart)obj).resolveSemanticElement()) == null) continue;
            result.add(element);
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection s) {
        IWorkbenchPart selectedPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (this.representationPart != null && !this.representationPart.equals(selectedPart)) {
            return;
        }
        this.selection = s;
        this.setEnabled(this.isEnabled());
    }

    public static Predicate<DDiagramElement> allowsHideReveal(DDiagram diagram) {
        Object result = new Predicate<DDiagramElement>(){

            public boolean apply(DDiagramElement dde) {
                if (dde instanceof DDiagramElementContainer) {
                    DDiagramElementContainerExperimentalQuery query = new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dde);
                    return !query.isRegion();
                }
                return true;
            }
        };
        if (diagram == null || diagram.getDescription() == null || !HideDDiagramElementAction.isEditable(diagram)) {
            return Predicates.alwaysFalse();
        }
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(diagram.getDescription().eClass().getEPackage())) continue;
            final IDiagramDescriptionProvider provider = diagramTypeDescriptor.getDiagramDescriptionProvider();
            result = new Predicate<DDiagramElement>(){

                public boolean apply(DDiagramElement input) {
                    return provider.allowsHideReveal(input);
                }
            };
            break;
        }
        return result;
    }

    private static boolean isEditable(DDiagram diagram) {
        boolean isEditable = false;
        Resource resource = diagram.eResource();
        if (resource != null) {
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resource.getResourceSet());
            isEditable = permissionAuthority.canEditInstance((EObject)diagram);
        }
        return isEditable;
    }

    public void dispose() {
        this.representationPart = null;
        this.selection = null;
    }
}

