/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.common.tools.api.resource.AbstractResourceSyncBackend;
import org.eclipse.sirius.common.tools.api.resource.FileModificationValidatorProvider;
import org.eclipse.sirius.common.tools.api.resource.IFileModificationValidator;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.common.tools.internal.resource.WorkspaceBackend;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class ResourceSetSync
extends ResourceSetListenerImpl
implements ResourceSyncClient {
    public static final String CDO_URI_SCHEME = "cdo";
    private static final String FILE_MODIFICATION_VALIDATION_STATUS = "File modification validation status";
    private boolean notificationIsRequired = true;
    private final List<AbstractResourceSyncBackend> backends = new ArrayList<AbstractResourceSyncBackend>();
    private final List<ResourceSyncClient> clients = new ArrayList<ResourceSyncClient>();
    private final Map<Resource, ResourceStatus> statuses = new HashMap<Resource, ResourceStatus>();
    private Collection<Resource> savedResources = new LinkedHashSet<Resource>();
    private final ArrayList<IFileModificationValidator> fileModificationValidators;
    private final AtomicBoolean notificationInProgress = new AtomicBoolean(false);

    private ResourceSetSync() {
        super(NotificationFilter.ANY);
        this.addDefaultBackends();
        this.fileModificationValidators = FileModificationValidatorProvider.INSTANCE.getFileModificationValidator();
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        ArrayList<ResourceSyncClient.ResourceStatusChange> changes = new ArrayList<ResourceSyncClient.ResourceStatusChange>();
        for (Notification notif : Iterables.filter((Iterable)event.getNotifications(), Notification.class)) {
            if (!this.isCustom(notif)) {
                this.notifyChanged(notif, changes);
            }
            if (!(notif.getNotifier() instanceof ResourceSet)) continue;
            if (notif.getEventType() == 3 && notif.getNewValue() instanceof Resource) {
                this.newResourceOnTheResourceSet((Resource)notif.getNewValue(), changes);
                continue;
            }
            if (notif.getEventType() != 4 || !(notif.getOldValue() instanceof Resource)) continue;
            this.removeResource((Resource)notif.getNewValue());
        }
        this.notifyClientsInBatch(changes);
    }

    private boolean isCustom(Notification notif) {
        return notif.getEventType() == -1;
    }

    public static ResourceSetSync getOrInstallResourceSetSync(TransactionalEditingDomain domain) {
        ResourceSetSync sync = ResourceSetSync.getResourceSetSync(domain.getResourceSet());
        if (sync == null) {
            sync = new ResourceSetSync();
            sync.setTarget(domain.getResourceSet());
            sync.install();
            domain.addResourceSetListener((ResourceSetListener)sync);
        }
        return sync;
    }

    public static Option<ResourceSetSync> getResourceSetSync(TransactionalEditingDomain domain) {
        return Options.newSome((Object)ResourceSetSync.getResourceSetSync(domain.getResourceSet()));
    }

    private static ResourceSetSync getResourceSetSync(ResourceSet resourceSet) {
        UnmodifiableIterator it;
        if (resourceSet != null && (it = Iterators.filter((Iterator)resourceSet.eAdapters().iterator(), MarkerAdapter.class)).hasNext()) {
            return ((MarkerAdapter)((Object)it.next())).getSync();
        }
        return null;
    }

    public static ResourceStatus getStatus(Resource res) {
        ResourceSetSync rss;
        ResourceStatus result = ResourceStatus.UNKNOWN;
        ResourceSet rs = res.getResourceSet();
        if (rs != null && (rss = ResourceSetSync.getResourceSetSync(rs)) != null) {
            result = rss.getResourceStatus(res);
        }
        return result;
    }

    public static boolean isReadOnly(Resource resource) {
        boolean readonly = false;
        URI resourceURI = resource.getURI();
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceURI != null && ResourceSetSync.isMetamodel(resource) || resourceSet != null && Boolean.TRUE.equals(resourceSet.getURIConverter().getAttributes(resourceURI, null).get("readOnly"))) {
            readonly = true;
        }
        return readonly;
    }

    private static boolean isMetamodel(Resource resource) {
        boolean isMetamodel = false;
        URI resourceURI = resource.getURI();
        ResourceSet resourceSet = resource.getResourceSet();
        isMetamodel = EPackage.Registry.INSTANCE.containsKey((Object)resourceURI.toString()) || resourceSet != null && resourceSet.getPackageRegistry().containsKey((Object)resourceURI.toString());
        return isMetamodel;
    }

    public static void uninstallResourceSetSync(TransactionalEditingDomain domain) {
        ResourceSetSync sync = ResourceSetSync.getResourceSetSync(domain.getResourceSet());
        if (sync != null) {
            sync.uninstall();
            for (MarkerAdapter adapter : Lists.newArrayList((Iterable)Iterables.filter((Iterable)domain.getResourceSet().eAdapters(), MarkerAdapter.class))) {
                domain.getResourceSet().eAdapters().remove((Object)adapter);
            }
            domain.removeResourceSetListener((ResourceSetListener)sync);
        }
    }

    private void addDefaultBackends() {
        IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
        if (workspaceRoot != null) {
            this.backends.add(new WorkspaceBackend(this));
        }
    }

    private ResourceStatus getResourceStatus(Resource res) {
        return this.retrieveOldStatus(res);
    }

    protected void install() {
        for (AbstractResourceSyncBackend backend : this.backends) {
            backend.install();
        }
    }

    private void newResourceOnTheResourceSet(Resource res, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (res.isModified()) {
            this.resourceNewStatus(res, ResourceStatus.CHANGED, changes);
        }
    }

    private void removeResource(Resource newValue) {
        this.statuses.remove(newValue);
    }

    public void notifyChanged(Notification notification, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject && !notification.isTouch() && !new NotificationQuery(notification).isTransientNotification()) {
            Resource resource = ((EObject)notifier).eResource();
            if (resource != null) {
                this.handleResourceChange(resource, changes);
            }
        } else if (notifier instanceof Resource) {
            Resource res = (Resource)notifier;
            if (notification.getFeatureID(null) == 3 && !res.isModified()) {
                this.resourceNewStatus(res, ResourceStatus.SYNC, changes);
            } else if (res.isModified() && notification.getFeatureID(null) == 2) {
                this.handleResourceChange(res, changes);
            }
        }
    }

    private void handleResourceChange(Resource resource, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        this.resourceNewStatus(resource, ResourceStatus.CHANGED, changes);
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void registerClient(ResourceSyncClient client) {
        this.clients.add(client);
    }

    private ResourceStatus retrieveOldStatus(Resource resource) {
        ResourceStatus status = this.statuses.get(resource);
        if (status == null) {
            status = ResourceStatus.UNKNOWN;
        }
        return status;
    }

    public void setNotificationIsRequired(boolean newValue) {
        this.notificationIsRequired = newValue;
    }

    private void resourceNewStatus(Resource resource, ResourceStatus newStatus, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        ResourceStatus oldStatus = this.retrieveOldStatus(resource);
        if (!(oldStatus == newStatus || resource.getURI() != null && resource.getURI().isPlatformPlugin())) {
            this.statuses.put(resource, newStatus);
            changes.add(new ResourceSyncClient.ResourceStatusChange(resource, newStatus, oldStatus));
            this.notifyClientsWhileProcessing(resource, newStatus, oldStatus);
        }
    }

    private void notifyClientsWhileProcessing(Resource resource, ResourceStatus newStatus, ResourceStatus oldStatus) {
        if (this.notificationIsRequired) {
            for (ResourceSyncClient client : new ArrayList<ResourceSyncClient>(this.clients)) {
                client.statusChanged(resource, oldStatus, newStatus);
            }
        }
    }

    private void notifyClientsInBatch(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.notificationInProgress.compareAndSet(false, true)) {
            try {
                if (this.notificationIsRequired && changes.size() > 0) {
                    for (ResourceSyncClient client : new ArrayList<ResourceSyncClient>(this.clients)) {
                        client.statusesChanged(changes);
                    }
                }
            }
            finally {
                this.notificationInProgress.set(false);
            }
        }
    }

    protected void setTarget(ResourceSet target) {
        target.eAdapters().add((Object)new MarkerAdapter(this));
        for (AbstractResourceSyncBackend backend : this.backends) {
            backend.setResourceSet(target);
        }
    }

    @Override
    public void statusChanged(Resource resource, ResourceStatus oldStatus, ResourceStatus newStatus) {
        this.statusesChanged(Collections.singletonList(new ResourceSyncClient.ResourceStatusChange(resource, newStatus, oldStatus)));
    }

    @Override
    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changesFromBackend) {
        LinkedHashSet<ResourceSyncClient.ResourceStatusChange> changesToTransmit = new LinkedHashSet<ResourceSyncClient.ResourceStatusChange>();
        for (ResourceSyncClient.ResourceStatusChange changeFromWorkspace : changesFromBackend) {
            if (this.itsAChangeWeReExpectingFromOurSave(changeFromWorkspace.getResource(), changeFromWorkspace.getNewStatus())) continue;
            this.resourceNewStatus(changeFromWorkspace.getResource(), changeFromWorkspace.getNewStatus(), changesToTransmit);
        }
        this.notifyClientsInBatch(changesToTransmit);
    }

    private boolean itsAChangeWeReExpectingFromOurSave(Resource resource, ResourceStatus newStatus) {
        return (newStatus == ResourceStatus.EXTERNAL_CHANGED || newStatus == ResourceStatus.CONFLICTING_CHANGED || newStatus == ResourceStatus.SYNC) && this.savedResources.remove(resource);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (Map.Entry<Resource, ResourceStatus> entry : this.statuses.entrySet()) {
            buff.append(entry.getKey().getURI());
            buff.append(":");
            buff.append((Object)entry.getValue());
        }
        return buff.toString();
    }

    protected void uninstall() {
        for (AbstractResourceSyncBackend backend : this.backends) {
            backend.uninstall();
        }
        this.statuses.clear();
    }

    public void unregisterClient(ResourceSyncClient client) {
        this.clients.remove(client);
    }

    public void save(Iterable<Resource> resourcesToSave, Iterable<Resource> resourcesToUpdateStatus, Map<?, ?> saveOptions) throws IOException, InterruptedException {
        LinkedHashSet<ResourceSyncClient.ResourceStatusChange> changesToTransmit = new LinkedHashSet<ResourceSyncClient.ResourceStatusChange>();
        this.doSave(resourcesToSave, saveOptions, changesToTransmit);
        for (Resource resource : resourcesToUpdateStatus) {
            ResourceStatus oldStatus = this.retrieveOldStatus(resource);
            if (oldStatus != ResourceStatus.UNKNOWN && oldStatus != ResourceStatus.CHANGED) continue;
            this.resourceNewStatus(resource, ResourceStatus.SYNC, changesToTransmit);
        }
        this.notifyClientsInBatch(changesToTransmit);
    }

    private void doSave(Iterable<Resource> resourcesToSave, Map<?, ?> saveOptions, Collection<ResourceSyncClient.ResourceStatusChange> changesToTransmit) throws InterruptedException, IOException {
        ArrayList<IFile> files2Validate = new ArrayList<IFile>();
        for (Resource resourceToSave : resourcesToSave) {
            IFile file;
            if (!resourceToSave.getURI().isPlatformResource() || (file = WorkspaceSynchronizer.getFile((Resource)resourceToSave)) == null || !file.isReadOnly()) continue;
            files2Validate.add(file);
        }
        if (files2Validate.size() > 0) {
            MultiStatus status = new MultiStatus("org.eclipse.sirius.common", 4, FILE_MODIFICATION_VALIDATION_STATUS, null);
            if (this.fileModificationValidators.size() == 0) {
                status.add(ResourcesPlugin.getWorkspace().validateEdit(files2Validate.toArray(new IFile[files2Validate.size()]), IWorkspace.VALIDATE_PROMPT));
            } else {
                for (IFileModificationValidator fileModificationValidator : this.fileModificationValidators) {
                    IStatus validationStatus = fileModificationValidator.validateEdit(files2Validate);
                    if (validationStatus == null) continue;
                    status.add(validationStatus);
                    if (!validationStatus.isOK()) break;
                }
            }
            if (status.getChildren().length == 0 || !status.isOK()) {
                throw new InterruptedException(String.valueOf(status.getPlugin()) + ":" + status.getMessage());
            }
        }
        this.savedResources = new LinkedHashSet<Resource>();
        for (Resource resource : resourcesToSave) {
            try {
                this.savedResources.add(resource);
                resource.save(saveOptions);
                resource.setModified(false);
            }
            catch (UnknownServiceException unknownServiceException) {}
        }
        for (Resource res : resourcesToSave) {
            this.resourceNewStatus(res, ResourceStatus.SYNC, changesToTransmit);
        }
    }

    public void addFileModificationValidator(IFileModificationValidator fileModificationValidator) {
        this.fileModificationValidators.add(fileModificationValidator);
    }

    public void removeFileModificationValidator(IFileModificationValidator fileModificationValidator) {
        this.fileModificationValidators.remove(fileModificationValidator);
    }

    class MarkerAdapter
    extends AdapterImpl {
        private ResourceSetSync synchronizer;

        MarkerAdapter(ResourceSetSync synchronizer) {
            this.synchronizer = synchronizer;
        }

        public ResourceSetSync getSync() {
            return this.synchronizer;
        }
    }

    public static enum ResourceStatus {
        CHANGED,
        EXTERNAL_CHANGED,
        CONFLICTING_CHANGED,
        CONFLICTING_DELETED,
        DELETED,
        SYNC,
        CHANGES_CANCELED,
        UNKNOWN;

    }
}

