/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.papiselect.papic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.papiselect.papic.ETItem;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventSet;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventTree;
import org.eclipse.ptp.etfw.tau.papiselect.papic.PapiInfoParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapiCSelect {
    PapiInfoParser pparser;
    IFileStore toolPath;
    private static final String papiApp = "papi_xml_event_info";
    SAXParser sp;
    IBuildLaunchUtils blt = null;

    PapiCSelect(IFileStore tpath, IBuildLaunchUtils blt) {
        this.blt = blt;
        this.toolPath = tpath.getChild(papiApp);
        try {
            this.sp = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.pparser = new PapiInfoParser();
    }

    public EventTree findET(List<String> commands) {
        EventTree et = null;
        byte[] xbytes = this.blt.runToolGetOutput(commands, null, null);
        if (xbytes == null) {
            return null;
        }
        ByteArrayInputStream stringIS = new ByteArrayInputStream(xbytes);
        et = this.parseETree(stringIS);
        return et;
    }

    public Set<Integer>[] getAvailable(int component, Set<String> checked) {
        HashSet[] index = new HashSet[2];
        this.pparser.reset();
        ArrayList<String> cAl = new ArrayList<String>(checked);
        cAl.add(0, String.valueOf(component));
        cAl.add(0, "-c");
        cAl.add(0, this.toolPath.toURI().getPath());
        EventTree et = this.findET(cAl);
        if (et == null) {
            return null;
        }
        index[0] = ((EventSet)((ETItem)et.children.get((int)0)).children.get((int)0)).fullSet;
        index[1] = ((EventSet)((ETItem)et.children.get((int)0)).children.get((int)1)).fullSet;
        return index;
    }

    public EventTree getEventTree() {
        EventTree et = null;
        try {
            this.pparser.reset();
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.toolPath.toURI().getPath());
            et = this.findET(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return et;
    }

    private EventTree parseETree(InputStream is) {
        this.sp.reset();
        try {
            this.sp.parse(is, (DefaultHandler)this.pparser);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.pparser.getEventTree();
    }
}

