/*
 * Decompiled with CFR 0.152.
 */
package model.impl;

import model.Company;
import model.Customer;
import model.ModelFactory;
import model.ModelPackage;
import model.Nationality;
import model.Person;
import model.impl.CompanyImpl;
import model.impl.CustomerImpl;
import model.impl.PersonImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class ModelFactoryImpl
extends EFactoryImpl
implements ModelFactory {
    public static ModelFactory init() {
        try {
            ModelFactory theModelFactory = (ModelFactory)EPackage.Registry.INSTANCE.getEFactory("http://org/eclipse/pmf/pim/tests/initialize/dynamic");
            if (theModelFactory != null) {
                return theModelFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ModelFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createPerson();
            }
            case 1: {
                return this.createCompany();
            }
            case 2: {
                return this.createCustomer();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createNationalityFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertNationalityToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Person createPerson() {
        PersonImpl person = new PersonImpl();
        return person;
    }

    @Override
    public Company createCompany() {
        CompanyImpl company = new CompanyImpl();
        return company;
    }

    @Override
    public Customer createCustomer() {
        CustomerImpl customer = new CustomerImpl();
        return customer;
    }

    public Nationality createNationalityFromString(EDataType eDataType, String initialValue) {
        Nationality result = Nationality.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertNationalityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public ModelPackage getModelPackage() {
        return (ModelPackage)this.getEPackage();
    }

    @Deprecated
    public static ModelPackage getPackage() {
        return ModelPackage.eINSTANCE;
    }
}

