/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmTypeHelper;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmWritableBoundClass;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MoveCodeToCallOrigAdapter
extends AbstractTransformableClassNode {
    private static final String BOUND_METHOD_ID = "_OT$boundMethodId";
    private Method method;
    private int boundMethodId;
    private int firstArgIndex;
    private int argOffset;
    private Method callOrig;
    private boolean superIsWeavable = true;
    private boolean baseSuperRequired;
    private AbstractBoundClass superclass;

    public MoveCodeToCallOrigAdapter(AsmWritableBoundClass clazz, Method method, int boundMethodId, boolean baseSuperRequired, IWeavingContext weavingContext) {
        this.method = method;
        this.boundMethodId = boundMethodId;
        if (method.isStatic()) {
            this.firstArgIndex = 0;
            this.argOffset = clazz.isRole() ? 2 : 0;
            this.callOrig = clazz.getCallOrigStatic();
        } else {
            this.firstArgIndex = 1;
            this.callOrig = ConstantMembers.callOrig;
        }
        if (weavingContext != null) {
            this.superIsWeavable = weavingContext.isWeavable(clazz.getSuperClassName(), false, false);
        }
        if (this.superIsWeavable) {
            this.superclass = clazz.getSuperclass();
        }
        this.baseSuperRequired = baseSuperRequired;
    }

    @Override
    public boolean transform() {
        MethodNode orgMethod = this.getMethod(this.method);
        if ((orgMethod.access & 0x400) != 0) {
            return false;
        }
        MethodNode callOrig = this.getMethod(this.callOrig);
        Type returnType = Type.getReturnType((String)orgMethod.desc);
        InsnList newInstructions = new InsnList();
        Type[] args = Type.getArgumentTypes((String)orgMethod.desc);
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        newInstructions.add((AbstractInsnNode)start);
        int line = this.peekFirstLineNumber(orgMethod.instructions);
        if (line != -1) {
            this.addLineNumber(newInstructions, line);
        }
        int boundMethodIdSlot = this.firstArgIndex;
        if (args.length > 0) {
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, boundMethodIdSlot));
            boundMethodIdSlot = orgMethod.maxLocals + 1;
            this.addLocal(callOrig, BOUND_METHOD_ID, "I", boundMethodIdSlot, start, end, false);
            newInstructions.add((AbstractInsnNode)new VarInsnNode(54, boundMethodIdSlot));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, this.firstArgIndex + this.argOffset + 1));
            int slot = this.firstArgIndex + this.argOffset;
            List origLocals = orgMethod.localVariables;
            int i = this.argOffset;
            while (i < args.length) {
                if (i < args.length - 1) {
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                }
                newInstructions.add(this.createLoadIntConstant(i));
                newInstructions.add((AbstractInsnNode)new InsnNode(50));
                Type arg = args[i];
                if (arg.getSort() != 9 && arg.getSort() != 10) {
                    String objectType = AsmTypeHelper.getBoxingType(arg);
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
                    newInstructions.add(AsmTypeHelper.getUnboxingInstructionForType(arg, objectType));
                } else {
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, arg.getInternalName()));
                }
                newInstructions.add((AbstractInsnNode)new VarInsnNode(args[i].getOpcode(54), slot));
                int origLocalIdx = i + this.firstArgIndex;
                if (origLocals != null && origLocalIdx < origLocals.size()) {
                    this.addLocal(callOrig, ((LocalVariableNode)origLocals.get((int)origLocalIdx)).name, arg.getDescriptor(), slot, start, end, false);
                }
                slot += arg.getSize();
                ++i;
            }
        } else {
            this.addLocal(callOrig, BOUND_METHOD_ID, "I", boundMethodIdSlot, start, end, false);
        }
        InsnList orgInstructions = orgMethod.instructions;
        if (this.superIsWeavable) {
            this.adjustSuperCalls(orgInstructions, orgMethod.name, orgMethod.desc, args, returnType, boundMethodIdSlot);
        }
        this.replaceReturn(orgInstructions, returnType);
        newInstructions.add(orgInstructions);
        this.addLineNumber(orgMethod.instructions, line);
        this.addReturn(orgMethod.instructions, Type.getReturnType((String)orgMethod.desc));
        if (orgMethod.tryCatchBlocks != null) {
            this.addTryCatchBlocks(orgMethod, callOrig);
            orgMethod.tryCatchBlocks.clear();
        }
        if (orgMethod.localVariables != null) {
            orgMethod.localVariables.clear();
        }
        newInstructions.add((AbstractInsnNode)end);
        this.addNewLabelToSwitch(callOrig.instructions, newInstructions, this.boundMethodId);
        if (this.baseSuperRequired && !this.superName.equals(ClassNames.OBJECT_SLASH) && !this.method.isStatic()) {
            newInstructions = this.superOrigCall(this.method, args);
            this.addNewLabelToSwitch(callOrig.instructions, newInstructions, this.boundMethodId + 1);
        }
        callOrig.maxStack = Math.max(Math.max(callOrig.maxStack, orgMethod.maxStack), 3);
        if (returnType.getSort() == 0) {
            ++callOrig.maxStack;
        }
        callOrig.maxLocals = Math.max(callOrig.maxLocals, orgMethod.maxLocals);
        return true;
    }

    private void addTryCatchBlocks(MethodNode orgMethod, MethodNode callOrig) {
        if (callOrig.tryCatchBlocks == null) {
            callOrig.tryCatchBlocks = new ArrayList();
        }
        callOrig.tryCatchBlocks.addAll(orgMethod.tryCatchBlocks);
    }

    private InsnList superOrigCall(Method method, Type[] args) {
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int i = this.argOffset;
        while (i < args.length) {
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, this.firstArgIndex + this.argOffset + 1));
            newInstructions.add(this.createLoadIntConstant(i));
            newInstructions.add((AbstractInsnNode)new InsnNode(50));
            Type arg = args[i];
            if (arg.getSort() != 9 && arg.getSort() != 10) {
                String objectType = AsmTypeHelper.getBoxingType(arg);
                newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
                newInstructions.add(AsmTypeHelper.getUnboxingInstructionForType(arg, objectType));
            } else {
                newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, arg.getInternalName()));
            }
            ++i;
        }
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(183, this.superName, method.getName(), method.getSignature(), false));
        Type returnType = Type.getReturnType((String)method.getSignature());
        switch (returnType.getSort()) {
            case 0: {
                newInstructions.add((AbstractInsnNode)new InsnNode(1));
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            default: {
                newInstructions.add(AsmTypeHelper.getBoxingInstructionForType(returnType));
            }
        }
        newInstructions.add((AbstractInsnNode)new InsnNode(176));
        return newInstructions;
    }

    private void adjustSuperCalls(InsnList instructions, String selector, String descriptor, Type[] args, Type returnType, final int boundMethodIdSlot) {
        ArrayList<MethodInsnNode> toReplace = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode orgMethodNode : instructions) {
            if (orgMethodNode.getOpcode() != 183 || !((MethodInsnNode)orgMethodNode).name.equals(selector) || !((MethodInsnNode)orgMethodNode).desc.equals(descriptor)) continue;
            toReplace.add((MethodInsnNode)orgMethodNode);
        }
        if (toReplace.isEmpty()) {
            return;
        }
        this.replaceSuperCallsWithCallToCallOrig(instructions, toReplace, true, this.superclass, new AbstractTransformableClassNode.IBoundMethodIdInsnProvider(){

            @Override
            public AbstractInsnNode getLoadBoundMethodIdInsn(MethodInsnNode methodInsn) {
                return new VarInsnNode(21, boundMethodIdSlot);
            }
        });
    }
}

