/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LRUList<E>
implements Iterable<E> {
    Map<E, Entry> object2entry = new HashMap<E, Entry>();
    Entry root;

    public LRUList() {
        this.root.next = this.root.previous = (this.root = new Entry());
    }

    @Override
    public Iterator<E> iterator() {
        return this.object2entry.keySet().iterator();
    }

    public void clear() {
        this.object2entry.clear();
        this.root.next = this.root.previous = this.root;
    }

    public void add(E obj) {
        Entry entry = new Entry();
        entry.value = obj;
        this.object2entry.put(obj, entry);
        this.doAdd(entry);
    }

    public void remove(E obj) {
        Entry entry = this.object2entry.remove(obj);
        if (entry != null) {
            this.doRemove(entry);
        }
    }

    public void touch(E obj) {
        Entry entry = this.object2entry.get(obj);
        if (entry != null) {
            this.doRemove(entry);
            this.doAdd(entry);
        }
    }

    public E peek() {
        return this.root.next.value;
    }

    public String toString() {
        ArrayList elements = new ArrayList();
        Entry e = this.root;
        while (e.next.value != null) {
            elements.add(e.next.value);
            e = e.next;
        }
        return ((Object)elements).toString();
    }

    private void doAdd(Entry entry) {
        entry.previous = this.root;
        entry.next = this.root.next;
        this.root.next.previous = entry;
        this.root.next = entry;
    }

    private void doRemove(Entry entry) {
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        entry.previous = null;
        entry.next = null;
    }

    private class Entry {
        E value;
        Entry next;
        Entry previous;

        private Entry() {
        }
    }
}

