/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class FileUtils {
    private static DirDeleter deleterThread = new DirDeleter();

    static {
        Runtime.getRuntime().addShutdownHook(deleterThread);
    }

    private FileUtils() {
    }

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        byte[] b = new byte[256];
        int i = 0;
        while ((i = in.read(b)) != -1) {
            out.write(b, 0, i);
        }
    }

    public static File createTempDirectory(String prefix, File parent) throws IOException {
        File tempFile = File.createTempFile(prefix, "", parent);
        if (!tempFile.delete()) {
            throw new IOException();
        }
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        deleterThread.add(tempFile);
        return tempFile;
    }

    public static String toFilename(String name, String extension) {
        return FileUtils.toFilename(name, "", extension);
    }

    public static String toFilename(String prefix, String suffix, String extension) {
        StringBuilder buf = new StringBuilder(prefix.length() + suffix.length() + extension.length() + 1);
        String[] stringArray = new String[]{prefix, suffix};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int ii = 0;
            while (ii < s.length() && ii < 20) {
                char c = s.charAt(ii);
                if (Character.isLetterOrDigit(c)) {
                    buf.append(c);
                } else {
                    buf.append("_");
                }
                ++ii;
            }
            ++n2;
        }
        buf.append(".").append(extension);
        return buf.toString();
    }

    private static class DirDeleter
    extends Thread {
        private List<File> dirList = new ArrayList<File>();

        private DirDeleter() {
        }

        public synchronized void add(File dir) {
            this.dirList.add(dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DirDeleter dirDeleter = this;
            synchronized (dirDeleter) {
                for (File dir : this.dirList) {
                    this.deleteDirectory(dir);
                }
            }
        }

        private void deleteDirectory(File dir) {
            if (!dir.exists()) {
                return;
            }
            File[] fileArray = dir.listFiles();
            if (fileArray != null) {
                int i = 0;
                while (i < fileArray.length) {
                    if (fileArray[i].isDirectory()) {
                        this.deleteDirectory(fileArray[i]);
                    } else {
                        fileArray[i].delete();
                    }
                    ++i;
                }
            }
            dir.delete();
        }
    }
}

