/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOLexer;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOParser;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CFileData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.keywordhandler.IKeywordHandler;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.keywordhandler.KeywordHandlerRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.AbstractLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtCompletionCompiler
extends QVTOCompiler {
    private final QvtCompletionData myData;
    private final Map<URI, CFileData> myCFileDataMap = new LinkedHashMap<URI, CFileData>();
    private QvtOperationalEnv myEnvironment;

    public QvtCompletionCompiler(IMetamodelRegistryProvider metamodelProvider, QvtCompletionData data) {
        super(metamodelProvider);
        this.myData = data;
    }

    public Map<URI, CFileData> getCFileDataMap() {
        return this.myCFileDataMap;
    }

    public AbstractLexer createLexer(UnitProxy unit) throws IOException, ParserException, BadLocationException {
        CFileData cFileData = this.getCFileData(unit.getURI());
        if (cFileData.getLexer() != null) {
            return cFileData.getLexer();
        }
        Reader reader = this.createReader(unit);
        QVTOLexer lexer = new QVTOLexer((Environment)new QvtOperationalEnvFactory(this.getEPackageRegistry(unit.getURI())).createEnvironment(unit.getURI()));
        cFileData.setLexer((AbstractLexer)lexer);
        try {
            lexer.reset(new OCLInput(reader).getContent(), unit.getURI().lastSegment());
            QVTOParser qvtoParser = new QVTOParser(lexer);
            lexer.lexer(qvtoParser.getIPrsStream());
            cFileData.setParser((AbstractQVTParser)qvtoParser);
        }
        finally {
            reader.close();
        }
        return lexer;
    }

    protected Reader createReader(UnitProxy source) throws IOException {
        if (source.getURI().equals(this.myData.getCFile().getURI())) {
            String documentText = this.myData.getDocument().get();
            return new StringReader(documentText);
        }
        return super.createReader(source);
    }

    public QvtOperationalEnv compileAll() {
        if (this.myEnvironment == null) {
            URI uri = this.myData.getCFile().getURI();
            this.myEnvironment = new QvtOperationalEnvFactory(this.getEPackageRegistry(uri)).createEnvironment(uri);
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setReportErrors(false);
            options.setShowAnnotations(false);
            options.setSourceLineNumbersEnabled(false);
            try {
                this.compile(this.myData.getCFile(), options, null);
            }
            catch (MdaException ex) {
                Activator.log(ex);
            }
        }
        return this.myEnvironment;
    }

    protected QvtOperationalVisitorCS createAnalyzer(AbstractQVTParser parser, QvtCompilerOptions options, IProgressMonitor monitor) {
        return new QvtCompletionVisitorCS(parser, options, monitor){

            protected void setEnv(QvtOperationalEnv env) {
                super.setEnv(env);
                QvtCompletionCompiler.this.myEnvironment = env;
            }
        };
    }

    protected QVTOCompiler.CSTParseResult parse(UnitProxy source, QvtCompilerOptions options) throws ParserException {
        CFileData cFileData = this.compile(source);
        AbstractQVTParser qvtParser = cFileData.getParser();
        UnitCS unitCS = cFileData.getUnitCS();
        QvtOperationalFileEnv env = (QvtOperationalFileEnv)cFileData.getLexer().getEnvironment();
        QVTOCompiler.CSTParseResult result = new QVTOCompiler.CSTParseResult();
        result.unitCS = unitCS;
        result.env = env;
        result.parser = qvtParser;
        return result;
    }

    private CFileData compile(UnitProxy cFile) {
        CFileData cFileData = this.getCFileData(cFile.getURI());
        try {
            AbstractLexer lexer = this.createLexer(cFile);
            IPrsStream prsStream = lexer.getILexStream().getIPrsStream();
            IKeywordHandler[] keywordHandlers = KeywordHandlerRegistry.getInstance().getKeywordHandlers();
            StringBuilder lightweightScriptBuilder = new StringBuilder(lexer.getILexStream().getStreamLength());
            int i = 0;
            int n = prsStream.getSize();
            while (i < n) {
                IToken token = prsStream.getTokenAt(i);
                IKeywordHandler[] iKeywordHandlerArray = keywordHandlers;
                int n2 = keywordHandlers.length;
                int n3 = 0;
                while (n3 < n2) {
                    IKeywordHandler keywordHandler = iKeywordHandlerArray[n3];
                    String contribution = keywordHandler.handle(token, prsStream, this.myData, cFileData);
                    if (contribution != null) {
                        int offsetDelta = token.getStartOffset() - lightweightScriptBuilder.length();
                        int j = 0;
                        while (j < offsetDelta - 1) {
                            lightweightScriptBuilder.append(' ');
                            ++j;
                        }
                        lightweightScriptBuilder.append(contribution);
                        break;
                    }
                    ++n3;
                }
                ++i;
            }
            String lightweightScript = lightweightScriptBuilder.toString();
            cFileData.setLightweightScript(lightweightScript);
            CSTNode cstNode = LightweightParserUtil.parse(lightweightScript, cFile, LightweightParserUtil.ParserTypeEnum.LIGHTWEIGHT_PARSER);
            cFileData.setUnitCS((UnitCS)cstNode);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
        return cFileData;
    }

    public CFileData getCFileData(URI unitURI) {
        CFileData cFileData = this.myCFileDataMap.get(unitURI);
        if (cFileData == null) {
            cFileData = new CFileData();
            this.myCFileDataMap.put(unitURI, cFileData);
        }
        return cFileData;
    }

    public CFileData getCFileData(MappingModuleCS mappingModuleCS) {
        for (CFileData cFileData : this.myCFileDataMap.values()) {
            UnitCS unitCS = cFileData.getUnitCS();
            if (unitCS == null || !unitCS.getModules().contains((Object)mappingModuleCS)) continue;
            return cFileData;
        }
        return null;
    }
}

