/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.CompIdentifierPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.ObjectMappingCategoryPO;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="OM_ASSOC")
public class ObjectMappingAssoziationPO
implements IObjectMappingAssoziationPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedLazy,
PersistenceWeavedRest {
    private static final String ID_COLUMN_NAME = "OBJECTMAPPINGASSOZIATIONPO_ID";
    private transient Long m_id = null;
    private Long m_parentProjectId = null;
    private String m_type = null;
    private transient Integer m_version;
    private ICompIdentifierPO m_technicalName = null;
    private IObjectMappingCategoryPO m_category = null;
    private Set<String> m_logicalNames = new HashSet<String>();
    private transient IComponentIdentifier m_compIdentifier = null;
    static final long serialVersionUID = -408015419231043148L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected WeavedAttributeValueHolderInterface _persistence_hbmCategory_vh;
    protected WeavedAttributeValueHolderInterface _persistence_technicalName_vh;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    ObjectMappingAssoziationPO() {
    }

    ObjectMappingAssoziationPO(IComponentIdentifier tech) {
        this.setCompIdentifier(tech);
        if (tech != null) {
            ICompIdentifierPO techNamePO = this.createCompIdPoObject(tech);
            this.setTechnicalName(techNamePO);
            if (techNamePO != null) {
                techNamePO.setParentProjectId(this.getParentProjectId());
            }
        }
    }

    ObjectMappingAssoziationPO(IComponentIdentifier tec, Set<String> logic) {
        this(tec);
        this.setLogicalNames(logic);
    }

    ObjectMappingAssoziationPO(IComponentIdentifier tec, String logic) {
        this(tec);
        Assert.verify((logic != null ? 1 : 0) != 0);
        this.getLogicalNames().add(logic);
    }

    @Override
    @Basic
    @Column(length=4000)
    public String getType() {
        return this.m_type;
    }

    @Override
    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public void setLogicalNames(Set<String> logicalNames) {
        this.m_logicalNames = logicalNames;
    }

    @Override
    public void addLogicalName(String name) {
        if (name != null && !this.getLogicalNames().contains(name)) {
            this.getLogicalNames().add(name);
        }
    }

    @Override
    public void removeLogicalName(String name) {
        if (name != null) {
            this.getLogicalNames().remove(name);
        }
    }

    @Override
    @OneToOne(cascade={CascadeType.ALL}, targetEntity=CompIdentifierPO.class, fetch=FetchType.LAZY)
    @BatchFetch(value=BatchFetchType.JOIN)
    public ICompIdentifierPO getTechnicalName() {
        this._persistence_initialize_technicalName_vh();
        if (!this._persistence_technicalName_vh.isInstantiated()) {
            this.setTechnicalName((ICompIdentifierPO)this._persistence_technicalName_vh.getValue());
        }
        return this.m_technicalName;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="LOGICAL_NAME", uniqueConstraints={@UniqueConstraint(columnNames={"LOGICAL_NAME", "OBJECTMAPPINGASSOZIATIONPO_ID"})})
    @JoinColumn(name="OM_ASSOC")
    @Column(name="LOGICAL_NAME", length=4000)
    @BatchFetch(value=BatchFetchType.JOIN)
    public Set<String> getLogicalNames() {
        return this.m_logicalNames;
    }

    @Override
    public void setTechnicalName(ICompIdentifierPO technicalName) {
        this.m_technicalName = technicalName;
        this._persistence_initialize_technicalName_vh();
        this._persistence_technicalName_vh.setValue((Object)technicalName);
        this._persistence_technicalName_vh.setIsCoordinatedWithProperty(true);
    }

    @Override
    @Transient
    public IObjectMappingCategoryPO getCategory() {
        return this.getHbmCategory();
    }

    @Override
    public void setCategory(IObjectMappingCategoryPO category) {
        this.setHbmCategory(category);
    }

    @ManyToOne(targetEntity=ObjectMappingCategoryPO.class, fetch=FetchType.LAZY)
    @JoinColumn(name="FK_CATEGORY", insertable=false, updatable=false)
    public IObjectMappingCategoryPO getHbmCategory() {
        this._persistence_initialize_hbmCategory_vh();
        if (!this._persistence_hbmCategory_vh.isInstantiated()) {
            this.setHbmCategory((IObjectMappingCategoryPO)this._persistence_hbmCategory_vh.getValue());
        }
        return this.m_category;
    }

    private void setHbmCategory(IObjectMappingCategoryPO category) {
        this.m_category = category;
        this._persistence_initialize_hbmCategory_vh();
        this._persistence_hbmCategory_vh.setValue((Object)category);
        this._persistence_hbmCategory_vh.setIsCoordinatedWithProperty(true);
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    private void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        if (this.getTechnicalName() != null) {
            this.m_technicalName.setParentProjectId(projectId);
        }
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    private ICompIdentifierPO createCompIdPoObject(IComponentIdentifier tech) {
        CompIdentifierPO techNamePO = new CompIdentifierPO();
        techNamePO.setComponentClassName(tech.getComponentClassName());
        techNamePO.setHierarchyNames(tech.getHierarchyNames());
        techNamePO.setNeighbours(tech.getNeighbours());
        techNamePO.setSupportedClassName(tech.getSupportedClassName());
        techNamePO.setAlternativeDisplayName(tech.getAlternativeDisplayName());
        techNamePO.setProfile(tech.getProfile());
        return techNamePO;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return this.toString();
    }

    @Override
    public void changeCompName(String oldCompNameGuid, String newCompNameGuid) {
        this.removeLogicalName(oldCompNameGuid);
        this.addLogicalName(newCompNameGuid);
    }

    @Override
    public String getComponentType(IWritableComponentNameCache compNameCache, Collection<Component> availableComponents) {
        String supportedClassName;
        ICompIdentifierPO techName = this.getTechnicalName();
        if (techName != null && (supportedClassName = this.getTechnicalName().getSupportedClassName()) != null) {
            return CompSystem.getComponentType((String)supportedClassName, availableComponents);
        }
        return null;
    }

    @Override
    @Transient
    public IObjectMappingCategoryPO getSection() {
        IObjectMappingCategoryPO category = this.getCategory();
        IObjectMappingCategoryPO section = null;
        if (category != null) {
            section = category.getSection();
        }
        return section;
    }

    @Override
    public void setCompIdentifier(IComponentIdentifier compIdentifier) {
        this.m_compIdentifier = compIdentifier;
    }

    @Override
    @Transient
    public IComponentIdentifier getCompIdentifier() {
        return this.m_compIdentifier;
    }

    public Object _persistence_post_clone() {
        if (this._persistence_hbmCategory_vh != null) {
            this._persistence_hbmCategory_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmCategory_vh.clone();
        }
        if (this._persistence_technicalName_vh != null) {
            this._persistence_technicalName_vh = (WeavedAttributeValueHolderInterface)this._persistence_technicalName_vh.clone();
        }
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ObjectMappingAssoziationPO();
    }

    public Object _persistence_get(String string) {
        if (string == "logicalNames") {
            return this.logicalNames;
        }
        if (string == "hbmCategory") {
            return this.hbmCategory;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "technicalName") {
            return this.technicalName;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "logicalNames") {
            this.logicalNames = (Set)object;
            return;
        }
        if (string == "hbmCategory") {
            this.hbmCategory = (IObjectMappingCategoryPO)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "type") {
            this.type = (String)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "technicalName") {
            this.technicalName = (ICompIdentifierPO)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
    }

    protected void _persistence_initialize_hbmCategory_vh() {
        if (this._persistence_hbmCategory_vh == null) {
            this._persistence_hbmCategory_vh = new ValueHolder();
            this._persistence_hbmCategory_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmCategory_vh() {
        IObjectMappingCategoryPO iObjectMappingCategoryPO;
        this._persistence_initialize_hbmCategory_vh();
        if ((this._persistence_hbmCategory_vh.isCoordinatedWithProperty() || this._persistence_hbmCategory_vh.isNewlyWeavedValueHolder()) && (iObjectMappingCategoryPO = this.getHbmCategory()) != this._persistence_hbmCategory_vh.getValue()) {
            this.setHbmCategory(iObjectMappingCategoryPO);
        }
        return this._persistence_hbmCategory_vh;
    }

    public void _persistence_set_hbmCategory_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        IObjectMappingCategoryPO iObjectMappingCategoryPO;
        this._persistence_hbmCategory_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (iObjectMappingCategoryPO = this.getHbmCategory()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmCategory((IObjectMappingCategoryPO)object);
        }
    }

    protected void _persistence_initialize_technicalName_vh() {
        if (this._persistence_technicalName_vh == null) {
            this._persistence_technicalName_vh = new ValueHolder();
            this._persistence_technicalName_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_technicalName_vh() {
        ICompIdentifierPO iCompIdentifierPO;
        this._persistence_initialize_technicalName_vh();
        if ((this._persistence_technicalName_vh.isCoordinatedWithProperty() || this._persistence_technicalName_vh.isNewlyWeavedValueHolder()) && (iCompIdentifierPO = this.getTechnicalName()) != this._persistence_technicalName_vh.getValue()) {
            this.setTechnicalName(iCompIdentifierPO);
        }
        return this._persistence_technicalName_vh;
    }

    public void _persistence_set_technicalName_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        ICompIdentifierPO iCompIdentifierPO;
        this._persistence_technicalName_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (iCompIdentifierPO = this.getTechnicalName()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setTechnicalName((ICompIdentifierPO)object);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

