/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.List;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.jee.model.internal.mergers.WebAppMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApp3Merger
extends WebAppMerger {
    public WebApp3Merger(JavaEEObject _base, JavaEEObject merge, int kind) {
        super(_base, merge, kind);
    }

    @Override
    protected void mergeServlets(List warnings) {
        List baseservlets = this.getBaseWebApp().getServlets();
        List toMergeServlets = this.getToMergeWebApp().getServlets();
        if (baseservlets != null && toMergeServlets != null && baseservlets.size() > 0 && toMergeServlets.size() > 0) {
            for (Servlet servlet : baseservlets) {
                Servlet toMergeArtifact = (Servlet)this.getArtifactFromList(servlet, toMergeServlets);
                if (!this.artifactIsValid(servlet) || toMergeArtifact == null) continue;
                this.mergeServlet(servlet, toMergeArtifact);
            }
        }
        if (this.getToMergeWebApp().getServlets() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getServlets(), this.getBaseWebApp().getServlets());
        }
        if (this.getToMergeWebApp().getFilterMappings() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getServletMappings(), this.getBaseWebApp().getServletMappings());
        }
        this.mergeServletMappings(this.getBaseWebApp().getServletMappings(), this.getToMergeWebApp().getServletMappings());
    }

    private void mergeServlet(Servlet servlet, Servlet toMergeArtifact) {
        this.mergeInitParams(servlet.getInitParams(), toMergeArtifact.getInitParams());
    }

    private void mergeServletMappings(List<ServletMapping> servletMappingsBase, List<ServletMapping> servletMappingsToMerge) {
        if (servletMappingsBase != null && servletMappingsToMerge != null && servletMappingsToMerge.size() > 0) {
            for (ServletMapping toMergeMapping : servletMappingsToMerge) {
                ServletMapping baseMapping = (ServletMapping)this.getArtifactFromList(toMergeMapping, servletMappingsBase);
                if (baseMapping == null || !baseMapping.getServletName().equals(toMergeMapping.getServletName())) continue;
                this.copyMissingContentInBase(toMergeMapping.getUrlPatterns(), baseMapping.getUrlPatterns());
            }
        }
    }

    @Override
    protected void mergeFilters(List warnings) {
        List basefilters = this.getBaseWebApp().getFilters();
        List toMergeFilters = this.getToMergeWebApp().getFilters();
        if (basefilters != null && toMergeFilters != null && basefilters.size() > 0 && toMergeFilters.size() > 0) {
            for (Filter filter : basefilters) {
                Filter toMergeArtifact = (Filter)this.getArtifactFromList(filter, toMergeFilters);
                if (!this.artifactIsValid(filter) || toMergeArtifact == null) continue;
                this.mergeFilter(filter, toMergeArtifact);
            }
        }
        if (this.getToMergeWebApp().getFilters() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getFilters(), this.getBaseWebApp().getFilters());
        }
        if (this.getToMergeWebApp().getFilterMappings() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getFilterMappings(), this.getBaseWebApp().getFilterMappings());
        }
        this.mergeFilterMappings(this.getBaseWebApp().getFilterMappings(), this.getToMergeWebApp().getFilterMappings());
    }

    private void mergeFilterMappings(List<FilterMapping> filterMappingsBase, List<FilterMapping> filterMappingsToMerge) {
        if (filterMappingsBase != null && filterMappingsToMerge != null && filterMappingsToMerge.size() > 0) {
            for (FilterMapping toMergeMapping : filterMappingsToMerge) {
                FilterMapping baseMapping = (FilterMapping)this.getArtifactFromList(toMergeMapping, filterMappingsBase);
                if (baseMapping == null || !baseMapping.getFilterName().equals(toMergeMapping.getFilterName())) continue;
                this.copyMissingContentInBase(toMergeMapping.getUrlPatterns(), baseMapping.getUrlPatterns());
            }
        }
    }

    private void mergeFilter(Filter filter, Filter toMergeArtifact) {
        this.mergeInitParams(filter.getInitParams(), toMergeArtifact.getInitParams());
    }

    private void mergeInitParams(List<ParamValue> initParams, List<ParamValue> initParams2) {
        if (initParams != null && initParams2 != null && initParams.size() > 0 && initParams2.size() > 0) {
            for (ParamValue value : initParams) {
                ParamValue artifactFromList = (ParamValue)this.getArtifactFromList(value, initParams2);
                if (artifactFromList == null || !value.getParamName().equals(artifactFromList.getParamName())) continue;
                value.setParamValue(artifactFromList.getParamValue());
            }
        }
        this.copyMissingContentInBase(initParams2, initParams);
    }
}

