/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcSun15HttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.exceptions.ESCertificateException;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.Messages;
import org.eclipse.emf.emfstore.internal.common.ESCollections;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.EObjectTypeFactory;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcClientManager {
    private final String serverInterface;
    private XmlRpcClient client;
    private static boolean serializationOptionsInitialized;
    private static boolean gzipCompressionEnabled;
    private static boolean gzipRequestingEnabled;

    public XmlRpcClientManager(String serverInterface) {
        this.serverInterface = serverInterface;
    }

    public void initConnection(ServerInfo serverInfo) throws ConnectionException {
        try {
            XmlRpcClientManager.initSerializationOptions();
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(this.createURL(serverInfo));
            config.setEnabledForExceptions(true);
            config.setEnabledForExtensions(true);
            config.setConnectionTimeout(Configuration.getXMLRPC().getXMLRPCConnectionTimeout());
            config.setReplyTimeout(Configuration.getXMLRPC().getXMLRPCReplyTimeout());
            config.setContentLengthOptional(true);
            config.setGzipCompressing(gzipCompressionEnabled);
            config.setGzipRequesting(gzipRequestingEnabled);
            this.client = new XmlRpcClient();
            this.client.setTypeFactory((TypeFactory)new EObjectTypeFactory((XmlRpcController)this.client));
            XmlRpcSun15HttpTransportFactory factory = new XmlRpcSun15HttpTransportFactory(this.client);
            try {
                factory.setSSLSocketFactory(KeyStoreManager.getInstance().getSSLContext().getSocketFactory());
            }
            catch (ESCertificateException e) {
                throw new ConnectionException(Messages.XmlRpcClientManager_Could_Not_Load_Certificate, (Throwable)e);
            }
            this.client.setTransportFactory((XmlRpcTransportFactory)factory);
            this.client.setConfig((XmlRpcClientConfig)config);
        }
        catch (MalformedURLException e) {
            throw new ConnectionException(Messages.XmlRpcClientManager_Malformed_URL_Or_Port, (Throwable)e);
        }
    }

    private URL createURL(ServerInfo serverInfo) throws MalformedURLException {
        this.checkUrl(serverInfo.getUrl());
        return new URL("https", serverInfo.getUrl(), serverInfo.getPort(), "/xmlrpc");
    }

    private void checkUrl(String url) throws MalformedURLException {
        if (!(url == null || url.equals("") || url.contains(":") || url.contains("/"))) {
            return;
        }
        throw new MalformedURLException();
    }

    public <T> T callWithResult(String methodName, Class<T> returnType, Object ... parameters) throws ESException {
        return this.executeCall(methodName, returnType, parameters);
    }

    public <T> List<T> callWithListResult(String methodName, Class<T> returnType, Object ... parameters) throws ESException {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] callResult = this.executeCall(methodName, Object[].class, parameters);
        if (callResult == null) {
            return result;
        }
        Object[] objectArray = callResult;
        int n = callResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result.add(obj);
            ++n2;
        }
        return result;
    }

    public void call(String methodName, Object ... parameters) throws ESException {
        this.executeCall(methodName, null, parameters);
    }

    private <T> T executeCall(String methodName, Class<T> returnType, Object[] params) throws ESException {
        if (this.client == null) {
            throw new ConnectionException(ConnectionManager.REMOTE);
        }
        Object[] adjustedParams = this.adjustParameters(params);
        try {
            Object result = this.client.execute(String.valueOf(this.serverInterface) + "." + methodName, adjustedParams);
            return (T)this.adjustResult((Optional<SessionId>)ESCollections.find((Object[])params, SessionId.class), (Optional<ProjectId>)ESCollections.find((Object[])params, ProjectId.class), result);
        }
        catch (XmlRpcException e) {
            if (e.getCause() instanceof ESException) {
                throw (ESException)e.getCause();
            }
            if (e.linkedException instanceof SAXException && ((SAXException)e.linkedException).getException() instanceof SerializationException) {
                SerializationException serialE = (SerializationException)((Object)((SAXException)e.linkedException).getException());
                throw new org.eclipse.emf.emfstore.internal.server.exceptions.SerializationException((Throwable)serialE);
            }
            throw new ConnectionException(String.valueOf(ConnectionManager.REMOTE) + e.getMessage(), (Throwable)e);
        }
    }

    private Object[] adjustParameters(Object[] params) throws ESException {
        if (!Configuration.getClientBehavior().getChangePackageFragmentSize().isPresent()) {
            return params;
        }
        Optional maybeSessionId = ESCollections.find((Object[])params, SessionId.class);
        Optional maybeProjectId = ESCollections.find((Object[])params, ProjectId.class);
        if (!maybeSessionId.isPresent() || !maybeProjectId.isPresent()) {
            return params;
        }
        int i = 0;
        while (i < params.length) {
            Object param = params[i];
            if (FileBasedChangePackage.class.isInstance(param) && !ChangePackageProxy.class.isInstance(param)) {
                params[i] = this.uploadInFragments((SessionId)maybeSessionId.get(), (ProjectId)maybeProjectId.get(), (FileBasedChangePackage)FileBasedChangePackage.class.cast(param));
            }
            ++i;
        }
        return params;
    }

    private <T> T adjustResult(Optional<SessionId> maybeSessionId, Optional<ProjectId> maybeProjectId, T result) throws ESException {
        if (result instanceof Object[]) {
            Object[] objects = (Object[])result;
            int i = 0;
            while (i < objects.length) {
                Object item = objects[i];
                objects[i] = this.adjustResult(maybeSessionId, maybeProjectId, item);
                ++i;
            }
            return (T)objects;
        }
        if (result instanceof List) {
            List l = (List)result;
            int i = 0;
            while (i < l.size()) {
                l.set(i, this.adjustResult(maybeSessionId, maybeProjectId, result));
                ++i;
            }
        } else if (result instanceof ChangePackageProxy) {
            return (T)this.downloadAndResolveChangePackage((ChangePackageProxy)result, maybeSessionId, maybeProjectId);
        }
        return result;
    }

    private AbstractChangePackage downloadAndResolveChangePackage(ChangePackageProxy proxy, Optional<SessionId> maybeSession, Optional<ProjectId> maybeProjectId) throws ESException {
        if (!maybeSession.isPresent()) {
            throw new ESException(Messages.XmlRpcClientManager_NoValidSessionId);
        }
        if (!maybeProjectId.isPresent()) {
            throw new ESException(Messages.XmlRpcClientManager_NoValidProjectId);
        }
        int fragmentIndex = 0;
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        changePackage.initialize(FileUtil.createLocationForTemporaryChangePackage());
        File file = new File(changePackage.getTempFilePath());
        FileWriter writer = null;
        try {
            try {
                ChangePackageEnvelope envelope;
                writer = new FileWriter(file);
                do {
                    envelope = this.executeCall("downloadChangePackageFragment", ChangePackageEnvelope.class, new Object[]{maybeSession.get(), maybeProjectId.get(), proxy.getId(), fragmentIndex});
                    for (String s : envelope.getFragment()) {
                        writer.write(String.valueOf(s) + System.getProperty("line.separator"));
                    }
                    ++fragmentIndex;
                } while (!envelope.isLast());
            }
            catch (IOException ex) {
                throw new ESException(Messages.XmlRpcClientManager_DownloadOfFragmentFailed, (Throwable)ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    throw new ESException(Messages.XmlRpcClientManager_DownloadOfFragmentFailed, (Throwable)ex);
                }
            }
        }
        try {
            changePackage.setLogMessage((LogMessage)ModelUtil.clone((EObject)proxy.getLogMessage()));
            changePackage.save();
        }
        catch (IOException ex) {
            throw new ESException(Messages.XmlRpcClientManager_SaveChangePackageFailed, (Throwable)ex);
        }
        return changePackage;
    }

    private ChangePackageProxy uploadInFragments(SessionId sessionId, ProjectId projectId, FileBasedChangePackage changePackage) throws ESException {
        Iterator envelopes = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)((Integer)Configuration.getClientBehavior().getChangePackageFragmentSize().get()));
        String proxyId = null;
        try {
            while (envelopes.hasNext()) {
                proxyId = this.uploadChangePackageFragment(sessionId, projectId, (ChangePackageEnvelope)envelopes.next());
            }
        }
        catch (XmlRpcException ex) {
            throw new ESException(Messages.XmlRpcClientManager_UploadChangePackageFragmentCallFailed, (Throwable)ex);
        }
        ChangePackageProxy proxy = VersioningFactory.eINSTANCE.createChangePackageProxy();
        proxy.setLogMessage((LogMessage)ModelUtil.clone((EObject)changePackage.getLogMessage()));
        proxy.setId(proxyId);
        return proxy;
    }

    private String uploadChangePackageFragment(SessionId sessionId, ProjectId projectId, ChangePackageEnvelope envelope) throws XmlRpcException {
        return (String)this.client.execute(String.valueOf(this.serverInterface) + "." + "uploadChangePackageFragment", new Object[]{sessionId, projectId, envelope});
    }

    private static void initSerializationOptions() {
        if (serializationOptionsInitialized) {
            return;
        }
        gzipRequestingEnabled = false;
        gzipCompressionEnabled = false;
        ESExtensionElement element = new ESExtensionPoint("org.eclipse.emf.emfstore.common.model.serializationOptions").getFirst();
        if (element != null) {
            gzipCompressionEnabled = element.getBoolean("GzipCompression");
            gzipRequestingEnabled = element.getBoolean("GzipRequesting");
        }
        serializationOptionsInitialized = true;
    }
}

