/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.pattern.common.java.AbstractJavaAssemblyContentProvider;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;

public class JetAssemblyContentProvider
extends AbstractJavaAssemblyContentProvider {
    public JetAssemblyContentProvider(Pattern pattern) {
        super(pattern, new JavaMethodGenerationHelper("stringBuffer"));
    }

    protected void call(PatternCall call) throws PatternException {
        this.content.append("<%");
        super.call(call);
        this.content.append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(BackCall object) throws PatternException {
        this.content.append("<%");
        super.call(object);
        this.content.append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(SuperCall call) throws PatternException {
        this.content.append("<%");
        super.call(call);
        this.content.append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(PatternInjectedCall call) throws PatternException {
        this.content.append("<%");
        super.call(call);
        this.content.append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(MethodCall object) throws PatternException {
        this.content.append("<%").append(EGFCommonConstants.LINE_SEPARATOR);
        this.javaMethodHelper.addCallStatement(object.getCalled());
        this.content.append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void addMethodBodies() throws PatternException {
        this.content.append("<%").append("//Start of methods").append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternMethod method : PatternHelper.getUserMethods((Pattern)this.pattern)) {
            this.content.append("<%");
            this.javaMethodHelper.addSignature(method);
            this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("%>");
            this.content.append(this.getMethodContent(method));
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("<%InternalPatternContext ictx = (InternalPatternContext) ctx;").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("new Node.DataLeaf(ictx.getNode(), getClass(), \"").append(method.getName()).append("\", ").append(this.javaMethodHelper.getBufferName()).append(".toString());").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("}%>").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        PatternMethod conditionMethod = this.pattern.getConditionMethod();
        if (conditionMethod != null) {
            String methodContent = this.getMethodContent(conditionMethod);
            if (methodContent == null || "".equals(methodContent.trim())) {
                methodContent = this.pattern.getSuperPattern() == null || this.pattern.getSuperPattern().getConditionMethod() == null ? "return true;" : null;
            }
            if (methodContent != null) {
                this.content.append("<%");
                this.javaMethodHelper.addConditionSignature(conditionMethod);
                this.content.append(EGFCommonConstants.LINE_SEPARATOR);
                this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
                this.content.append(methodContent).append(EGFCommonConstants.LINE_SEPARATOR);
                this.content.append("}%>").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        this.content.append("<%").append("//End of methods").append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }
}

