/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdatePasswordDialog
extends MessageDialog {
    private String password;
    private String verifyPassword;
    private final String username;
    private Label description;

    public UpdatePasswordDialog(Shell parentShell, String username, String serverid) {
        super(parentShell, Messages.UpdatePasswordCommand_TEXT_PW_UPDATE, null, NLS.bind((String)Messages.UpdatePasswordDialog_TEXT_ENTER_NEW_PW, (Object)username, (Object)serverid), 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)area);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(area);
        this.description = new Label(area, 64);
        GridDataFactory.fillDefaults().hint(400, -1).applyTo((Control)this.description);
        this.description.setText(Messages.UpdatePasswordDialog_TEXT_DESCRIPTION);
        Composite composite = new Composite(area, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label updatePasswordLabel = new Label(composite, 0);
        updatePasswordLabel.setText(Messages.UpdatePasswordDialog_TEXT_NEW_PW_LABEL);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)updatePasswordLabel);
        final Text newPasswordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)newPasswordText);
        newPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UpdatePasswordDialog.this.password = newPasswordText.getText();
                UpdatePasswordDialog.this.update();
            }
        });
        Label verifyPasswordLabel = new Label(composite, 0);
        verifyPasswordLabel.setText(Messages.UpdatePasswordDialog_TEXT_VERIFY_PW_LABEL);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)verifyPasswordLabel);
        final Text verifyPasswordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)verifyPasswordText);
        verifyPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UpdatePasswordDialog.this.verifyPassword = verifyPasswordText.getText();
                UpdatePasswordDialog.this.update();
            }
        });
        return area;
    }

    private void update() {
        this.getButton(0).setEnabled(this.password != null && this.password.length() > 0 && this.verifyPassword != null && this.verifyPassword.length() > 0);
        if (this.password == null || this.password.length() == 0) {
            this.description.setText(Messages.UpdatePasswordDialog_TEXT_DESCRIPTION);
            this.getButton(0).setEnabled(false);
        } else if (this.verifyPassword == null || this.verifyPassword.length() == 0) {
            this.description.setText(NLS.bind((String)Messages.UpdatePasswordDialog_TEXT_VERIFY_PW_FOR, (Object)this.username));
            this.getButton(0).setEnabled(false);
        } else if (!this.password.equals(this.verifyPassword)) {
            this.description.setText(Messages.UpdatePasswordDialog_TEXT_MISMATCH_PW);
            this.getButton(0).setEnabled(false);
        } else {
            this.description.setText(Messages.UpdatePasswordDialog_TEXT_PROMPT_OK);
            this.getButton(0).setEnabled(true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }
}

