/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.preference.IPreferenceChangeListener;
import org.eclipse.birt.core.preference.PreferenceChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedUIAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.extensions.IMenuBuilder;
import org.eclipse.birt.report.designer.ui.extensions.IProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExtensionPointManager
implements IPreferenceChangeListener {
    private Map<String, ExtendedElementUIPoint> reportItemUIMap = null;
    private Map<String, IMenuBuilder> menuBuilderMap = null;
    private Map<String, IProviderFactory> providerFactoryMap = null;
    private Map<String, List<String>> prefereces = new HashMap<String, List<String>>();
    private Map<String, List<IPreferenceChangeListener>> prefListeners = new HashMap<String, List<IPreferenceChangeListener>>();
    private static volatile ExtensionPointManager instance = null;

    private ExtensionPointManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtensionPointManager getInstance() {
        if (instance != null) return instance;
        Class<ExtensionPointManager> clazz = ExtensionPointManager.class;
        synchronized (ExtensionPointManager.class) {
            if (instance != null) return instance;
            instance = new ExtensionPointManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<ExtendedElementUIPoint> getExtendedElementPoints() {
        return Arrays.asList(this.getReportItemUIMap().values().toArray(new ExtendedElementUIPoint[this.getReportItemUIMap().size()]));
    }

    public ExtendedElementUIPoint getExtendedElementPoint(String extensionName) {
        assert (extensionName != null);
        return this.getReportItemUIMap().get(extensionName);
    }

    public IMenuBuilder getMenuBuilder(String elementName) {
        return this.getMenuBuilderMap().get(elementName);
    }

    public IProviderFactory getProviderFactory(String elementName) {
        return this.getProviderFactoryMap().get(elementName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ExtendedElementUIPoint> getReportItemUIMap() {
        ExtensionPointManager extensionPointManager = this;
        synchronized (extensionPointManager) {
            if (this.reportItemUIMap == null) {
                this.reportItemUIMap = new HashMap<String, ExtendedElementUIPoint>();
                for (IExtension extension : this.getExtensionElements("org.eclipse.birt.report.designer.ui.reportitemUI")) {
                    ExtendedElementUIPoint point = this.createReportItemUIPoint(extension);
                    if (point == null) continue;
                    this.reportItemUIMap.put(point.getExtensionName(), point);
                }
            }
            return this.reportItemUIMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IMenuBuilder> getMenuBuilderMap() {
        ExtensionPointManager extensionPointManager = this;
        synchronized (extensionPointManager) {
            if (this.menuBuilderMap == null) {
                this.menuBuilderMap = new HashMap<String, IMenuBuilder>();
                for (IExtension extension : this.getExtensionElements("org.eclipse.birt.report.designer.ui.menuBuilders")) {
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int i = 0;
                    while (i < elements.length) {
                        if ("menuBuilder".equals(elements[i].getName())) {
                            String elementId = elements[i].getAttribute("elementName");
                            try {
                                Object menuBuilder = elements[i].createExecutableExtension("class");
                                if (menuBuilder instanceof IMenuBuilder) {
                                    this.menuBuilderMap.put(elementId, (IMenuBuilder)menuBuilder);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        ++i;
                    }
                }
            }
            return this.menuBuilderMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IProviderFactory> getProviderFactoryMap() {
        ExtensionPointManager extensionPointManager = this;
        synchronized (extensionPointManager) {
            if (this.providerFactoryMap == null) {
                this.providerFactoryMap = new HashMap<String, IProviderFactory>();
                for (IExtension extension : this.getExtensionElements("org.eclipse.birt.report.designer.ui.providerFactories")) {
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int i = 0;
                    while (i < elements.length) {
                        if ("providerFactory".equals(elements[i].getName())) {
                            String elementId = elements[i].getAttribute("elementName");
                            try {
                                Object factory = elements[i].createExecutableExtension("class");
                                if (factory instanceof IProviderFactory) {
                                    this.providerFactoryMap.put(elementId, (IProviderFactory)factory);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        ++i;
                    }
                }
            }
            return this.providerFactoryMap;
        }
    }

    private List<IExtension> getExtensionElements(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return Collections.emptyList();
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(id);
        if (extensionPoint == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(extensionPoint.getExtensions());
    }

    private ExtendedElementUIPoint createReportItemUIPoint(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            return this.loadElements(elements);
        }
        return null;
    }

    private ExtendedElementUIPoint loadElements(IConfigurationElement[] elements) {
        ExtendedElementUIPoint newPoint = new ExtendedElementUIPoint();
        if (elements != null) {
            try {
                int i = 0;
                while (i < elements.length) {
                    this.loadAttributes(newPoint, elements[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
                return null;
            }
        }
        if (DEUtil.getMetaDataDictionary().getExtension(newPoint.getExtensionName()) == null) {
            return null;
        }
        if (Policy.TRACING_EXTENSION_LOAD) {
            System.out.println("GUI Extesion Manager >> Loads " + newPoint.getExtensionName());
        }
        return newPoint;
    }

    private void loadAttributes(ExtendedElementUIPoint newPoint, IConfigurationElement element) throws CoreException {
        String value;
        String elementName = element.getName();
        if ("model".equals(elementName)) {
            String value2 = element.getAttribute("extensionName");
            newPoint.setExtensionName(value2);
        } else if ("reportItemFigureUI".equals(elementName) || "reportItemImageUI".equals(elementName) || "reportItemLabelUI".equals(elementName)) {
            String className = element.getAttribute("class");
            if (className != null) {
                Object ui = element.createExecutableExtension("class");
                newPoint.setReportItemUI(new ExtendedUIAdapter(ui));
            }
        } else if ("builder".equals(elementName)) {
            this.loadClass(newPoint, element, "class", "builder");
        } else if ("propertyPage".equals(elementName)) {
            this.loadClass(newPoint, element, "class", "propertyPage");
        } else if ("palette".equals(elementName)) {
            this.loadIconAttribute(newPoint, element, "paletteIcon", "icon", false);
            this.loadIconAttribute(newPoint, element, "paletteIconLarge", "largeIcon", false);
            this.loadStringAttribute(newPoint, element, "category");
            this.loadStringAttribute(newPoint, element, "categoryDisplayName");
        } else if ("editor".equals(elementName)) {
            this.loadBooleanAttribute(newPoint, element, "showInDesigner");
            this.loadStringAttribute(newPoint, element, "showInDesignerByPreference");
            this.loadBooleanAttribute(newPoint, element, "showInMasterPage");
            this.loadBooleanAttribute(newPoint, element, "canResize");
            this.loadStringAttribute(newPoint, element, "menuLabel");
        } else if ("outline".equals(elementName)) {
            this.loadIconAttribute(newPoint, element, "outlineIcon", "icon", true);
        } else if ("description".equals(elementName) && (value = element.getValue()) != null) {
            newPoint.setAttribute("description", value);
        }
    }

    private void loadClass(ExtendedElementUIPoint newPoint, IConfigurationElement element, String className, String attributeName) {
        String value = element.getAttribute(className);
        if (value != null) {
            try {
                newPoint.setClass(attributeName, element.createExecutableExtension(className));
            }
            catch (CoreException coreException) {}
        }
    }

    private ImageDescriptor getImageDescriptor(IConfigurationElement element, String attrName) {
        assert (element != null);
        IExtension extension = element.getDeclaringExtension();
        String iconPath = element.getAttribute(attrName);
        if (iconPath == null) {
            return null;
        }
        URL path = Platform.getBundle((String)extension.getNamespace()).getEntry("/");
        try {
            return ImageDescriptor.createFromURL((URL)new URL(path, iconPath));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void loadStringAttribute(ExtendedElementUIPoint newPoint, IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            newPoint.setAttribute(attributeName, value);
        }
    }

    private void loadBooleanAttribute(ExtendedElementUIPoint newPoint, IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            newPoint.setAttribute(attributeName, Boolean.valueOf(value));
        }
    }

    private void loadIconAttribute(ExtendedElementUIPoint newPoint, IConfigurationElement element, String keyName, String attributeName, boolean shared) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(element, attributeName);
        if (imageDescriptor != null) {
            if (shared) {
                String symbolName = ReportPlatformUIImages.getIconSymbolName(newPoint.getExtensionName(), keyName);
                ReportPlatformUIImages.declareImage(symbolName, imageDescriptor);
            }
            newPoint.setAttribute(keyName, imageDescriptor);
        }
    }

    public void preferenceChange(PreferenceChangeEvent event) {
        for (String extension : this.prefereces.keySet()) {
            List<IPreferenceChangeListener> listeners;
            List<String> prefs = this.prefereces.get(extension);
            if (!prefs.contains(event.getKey()) || (listeners = this.prefListeners.get(extension)) == null) continue;
            int i = 0;
            while (i < listeners.size()) {
                listeners.get(i).preferenceChange(event);
                ++i;
            }
        }
    }

    public void addPreference(String extension, String preference) {
        if (preference != null && extension != null) {
            List<String> prefs;
            if (!this.prefereces.containsKey(extension)) {
                this.prefereces.put(extension, new ArrayList());
            }
            if (!(prefs = this.prefereces.get(extension)).contains(preference)) {
                prefs.add(preference);
            }
        }
    }

    public void removePreference(String extension, String preference) {
        if (preference != null && extension != null) {
            if (!this.prefereces.containsKey(extension)) {
                return;
            }
            List<String> prefs = this.prefereces.get(extension);
            if (prefs.contains(preference)) {
                prefs.remove(preference);
            }
        }
    }

    public void addPreferenceChangeListener(String extension, IPreferenceChangeListener listener) {
        if (listener != null && extension != null) {
            List<IPreferenceChangeListener> lisnteners;
            if (!this.prefListeners.containsKey(extension)) {
                this.prefListeners.put(extension, new ArrayList());
            }
            if (!(lisnteners = this.prefListeners.get(extension)).contains(listener)) {
                lisnteners.add(listener);
            }
        }
    }

    public void removePreferenceChangeListener(String extension, IPreferenceChangeListener listener) {
        if (listener != null && extension != null) {
            if (!this.prefListeners.containsKey(extension)) {
                return;
            }
            List<IPreferenceChangeListener> listeners = this.prefListeners.get(extension);
            if (listeners.contains(listener)) {
                listeners.remove(listener);
            }
        }
    }
}

