/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.wizards.ExportReportWizardPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExportLibraryHandler
extends SelectionHandler {
    private static String windowTitle = Messages.getString((String)"ExportToLibraryAction.wizard.windowTitle");
    private static final String DIALOG_TITLE = Messages.getString((String)"ExportToLibraryAction.Dialog.Title");
    private static final String DIALOG_MESSAGE = Messages.getString((String)"ExportToLibraryAction.Dialog.Message");
    private static final String BUTTON_YES = Messages.getString((String)"ExportToLibraryAction.Button.Yes");
    private static final String BUTTON_NO = Messages.getString((String)"ExportToLibraryAction.Button.No");
    private static final String BUTTON_CANCEL = Messages.getString((String)"ExportToLibraryAction.Button.Cancel");
    private static final String REMEMBER_DECISION = Messages.getString((String)"ExportToLibraryAction.Message.RememberDecision");
    private boolean saveDecision;
    private int pref;
    private DesignElementHandle selection;
    public static final int PREF_OVERWRITE = 1;
    public static final int PREF_NOT_OVERWRITE = 2;
    public static final int PREF_PROMPT = 0;
    public static final String PREF_KEY = "ExportToLibraryAction.Pref";

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean retBoolean = true;
        super.execute(event);
        this.selection = (DesignElementHandle)this.getElementHandles().get(0);
        ExportReportWizard exportReportWizard = new ExportReportWizard();
        BaseWizardDialog wDialog = new BaseWizardDialog(UIUtil.getDefaultShell(), (IWizard)exportReportWizard);
        wDialog.setPageSize(500, 250);
        wDialog.open();
        return retBoolean;
    }

    public class ExportReportWizard
    extends Wizard {
        private ExportReportWizardPage page;

        public ExportReportWizard() {
            this.setWindowTitle(windowTitle);
            this.page = new ExportReportWizardPage("");
            this.addPage((IWizardPage)this.page);
        }

        public Image getDefaultPageImage() {
            return ReportPlugin.getImage("/icons/wizban/create_project_wizard.gif");
        }

        public boolean performFinish() {
            block7: {
                String filename;
                block8: {
                    MessageDialog prefDialog;
                    filename = this.page.getFullName();
                    if (!filename.endsWith(".rptlibrary")) {
                        filename = String.valueOf(filename) + ".rptlibrary";
                    }
                    ExportLibraryHandler.this.pref = ReportPlugin.getDefault().getPreferenceStore().getInt(ExportLibraryHandler.PREF_KEY);
                    if (filename == null) break block7;
                    if (ExportLibraryHandler.this.pref != 0 || !new File(filename).exists() || (prefDialog = new MessageDialog(UIUtil.getDefaultShell(), DIALOG_TITLE, null, DIALOG_MESSAGE, 2, new String[]{BUTTON_YES, BUTTON_NO, BUTTON_CANCEL}, 0){

                        protected Control createCustomArea(Composite parent) {
                            Composite container = new Composite(parent, 0);
                            GridLayout gridLayout = new GridLayout();
                            gridLayout.marginWidth = 20;
                            container.setLayout((Layout)gridLayout);
                            Button chkbox = new Button(container, 32);
                            chkbox.setText(REMEMBER_DECISION);
                            chkbox.addSelectionListener(new SelectionListener(){

                                public void widgetSelected(SelectionEvent e) {
                                    ExportLibraryHandler.this.saveDecision = !ExportLibraryHandler.this.saveDecision;
                                }

                                public void widgetDefaultSelected(SelectionEvent e) {
                                    ExportLibraryHandler.this.saveDecision = false;
                                }
                            });
                            return super.createCustomArea(parent);
                        }

                        protected void buttonPressed(int buttonId) {
                            switch (buttonId) {
                                case 0: {
                                    ExportLibraryHandler.this.pref = 1;
                                    break;
                                }
                                case 1: {
                                    ExportLibraryHandler.this.pref = 2;
                                    break;
                                }
                            }
                            if (ExportLibraryHandler.this.saveDecision) {
                                ReportPlugin.getDefault().getPreferenceStore().setValue(ExportLibraryHandler.PREF_KEY, ExportLibraryHandler.this.pref);
                            }
                            super.buttonPressed(buttonId);
                        }
                    }).open() != 2) break block8;
                    return true;
                }
                try {
                    if (ExportLibraryHandler.this.selection instanceof ReportDesignHandle) {
                        ElementExportUtil.exportDesign((ReportDesignHandle)((ReportDesignHandle)ExportLibraryHandler.this.selection), (String)filename, (ExportLibraryHandler.this.pref == 1 ? 1 : 0) != 0, (boolean)true);
                    } else {
                        ElementExportUtil.exportElement((DesignElementHandle)ExportLibraryHandler.this.selection, (String)filename, (ExportLibraryHandler.this.pref == 1 ? 1 : 0) != 0);
                    }
                    IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
                    if (synchronizer != null) {
                        synchronizer.notifyResourceChanged(new ReportResourceChangeEvent((Object)this, Path.fromOSString((String)filename), 1));
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
            }
            return true;
        }
    }
}

