/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;

class ClobLocatorInputStream
extends InputStream {
    private final ClientConnection connection;
    private final ClientClob clob;
    private long currentPos;

    ClobLocatorInputStream(ClientConnection clientConnection, ClientClob clientClob) throws SqlException {
        this.connection = clientConnection;
        this.clob = clientClob;
        this.currentPos = 1L;
    }

    ClobLocatorInputStream(ClientConnection clientConnection, ClientClob clientClob, long l) throws SqlException {
        this(clientConnection, clientClob);
        this.currentPos = l;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = this.readBytes(1);
        if (byArray.length == 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = this.readBytes(n2);
        if (byArray2.length == 0) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    private byte[] readBytes(int n) throws IOException {
        try {
            int n2 = (int)Math.min((long)n, this.clob.sqlLength() - this.currentPos + 1L);
            String string = this.connection.locatorProcedureCall().clobGetSubString(this.clob.getLocator(), this.currentPos, n2);
            byte[] byArray = this.getBytesFromString(string);
            this.currentPos += (long)byArray.length;
            return byArray;
        }
        catch (SqlException sqlException) {
            throw new IOException(sqlException);
        }
    }

    private byte[] getBytesFromString(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 1; i <= string.length(); ++i) {
            char c = string.charAt(i - 1);
            byArray[i - 1] = c <= '\u00ff' ? (int)c : 63;
        }
        return byArray;
    }
}

