/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.style.impl;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.AbstractStylePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.actions.RadioStyleAction;

public final class MacroStylePropertyImpl
extends SubStylePropertyImpl {
    private final long[] m_flags;
    private final String[] m_sFlags;

    public MacroStylePropertyImpl(AbstractStylePropertyEditor editor, String title, long[] flags, String[] sFlags) {
        super(editor, title);
        this.m_flags = flags;
        this.m_sFlags = sFlags;
    }

    public PropertyEditor createEditor() {
        return new StringComboPropertyEditor(this.m_sFlags);
    }

    public long getFlag(String sFlag) {
        return this.m_flags[ArrayUtils.indexOf((Object[])this.m_sFlags, (Object)sFlag)];
    }

    public String getFlagValue(Property property) throws Exception {
        long style = this.getStyleValue(property);
        int i = 0;
        while (i < this.m_flags.length) {
            long flag = this.m_flags[i];
            if ((style & flag) == flag) {
                return this.m_sFlags[i];
            }
            ++i;
        }
        return null;
    }

    public Object getValue(Property property) throws Exception {
        return StringUtils.defaultString((String)this.getFlagValue(property));
    }

    public void setValue(Property property, Object value) throws Exception {
        String sFlag;
        long style = 0L;
        if (value != Property.UNKNOWN_VALUE && !StringUtils.isEmpty((String)(sFlag = (String)value))) {
            style = this.getFlag(sFlag);
        }
        this.setStyleValue(property, style);
    }

    public void contributeActions(Property property, IMenuManager manager) throws Exception {
        manager.add((IContributionItem)new Separator());
        long style = this.getStyleValue(property);
        int i = 0;
        while (i < this.m_flags.length) {
            RadioStyleAction action = new RadioStyleAction(property, this, this.m_sFlags[i]);
            long flag = this.m_flags[i];
            if ((style & flag) == flag) {
                action.setChecked(true);
            }
            manager.add((IAction)action);
            ++i;
        }
    }
}

