/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.ui.modelconnector.AdapterUtil;
import org.eclipse.viatra.query.runtime.ui.modelconnector.EMFModelConnector;
import org.eclipse.viatra.query.runtime.ui.modelconnector.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class LoadResourceSetHandler extends AbstractHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    IEditorPart editorPart = HandlerUtil.getActiveEditorChecked(event);
    final IViewPart resultView = HandlerUtil.getActiveSite(event).getPage().findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      try {
        IModelConnector modelConnector = AdapterUtil.getModelConnectorFromIEditorPart(editorPart);
        if ((modelConnector instanceof EMFModelConnector)) {
          ((EMFModelConnector)modelConnector).loadModel(IModelConnectorTypeEnum.RESOURCESET);
          ((QueryResultView)resultView).loadModel(((EMFModelConnector)modelConnector), IModelConnectorTypeEnum.RESOURCESET);
        }
      } catch (final Throwable _t) {
        if (_t instanceof ViatraQueryException) {
          final ViatraQueryException ex = (ViatraQueryException)_t;
          String _message = ex.getMessage();
          String _plus = ("Error while initializing Query Engine: " + _message);
          throw new ExecutionException(_plus, ex);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    return null;
  }
}
